/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GroupByPackages {
    private final Map<File, Collection<File>> myParentToChildrenMap = new HashMap<File, Collection<File>>();
    private final Collection<File> myRoots = new HashSet<File>();

    public GroupByPackages(@NotNull Collection<File> files) {
        for (File file2 : files) {
            this.process(file2);
        }
        this.splitRoots();
    }

    private void splitRoots() {
        for (File oldRoot : new ArrayList<File>(this.myRoots)) {
            File newRoot;
            if (oldRoot.equals(newRoot = this.splitRoot(oldRoot))) continue;
            this.replaceRoot(oldRoot, newRoot);
        }
    }

    private void replaceRoot(File oldRoot, File newRoot) {
        this.myRoots.remove(oldRoot);
        this.myRoots.add(newRoot);
    }

    private File splitRoot(@NotNull File oldRoot) {
        List<File> children2 = this.getChildren(oldRoot);
        if (children2.size() == 1) {
            return this.splitRoot(children2.get(0));
        }
        return oldRoot;
    }

    private void process(@NotNull File file2) {
        File f = file2;
        for (File parent = file2.getParentFile(); parent != null; parent = parent.getParentFile()) {
            Collection<File> files = this.myParentToChildrenMap.get(parent);
            if (files == null) {
                files = new HashSet<File>();
                this.myParentToChildrenMap.put(parent, files);
            }
            files.add(f);
            f = parent;
        }
        this.myRoots.add(f);
    }

    @NotNull
    public List<File> getRoots() {
        return new ArrayList<File>(this.myRoots);
    }

    @NotNull
    public List<File> getChildren(File file2) {
        Collection<File> collection = this.myParentToChildrenMap.get(file2);
        if (collection == null) {
            return ContainerUtil.emptyList();
        }
        return new ArrayList<File>(collection);
    }
}

