/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.ActionEvent;
import java.nio.charset.Charset;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncompatibleEncodingDialog
extends DialogWrapper {
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Charset charset;
    @NotNull
    private final EncodingUtil.Magic8 safeToReload;
    @NotNull
    private final EncodingUtil.Magic8 safeToConvert;
    static final int RELOAD_EXIT_CODE = 10;
    static final int CONVERT_EXIT_CODE = 20;

    IncompatibleEncodingDialog(@NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull EncodingUtil.Magic8 safeToReload, @NotNull EncodingUtil.Magic8 safeToConvert) {
        super(false);
        this.virtualFile = virtualFile;
        this.charset = charset;
        this.safeToReload = safeToReload;
        this.safeToConvert = safeToConvert;
        this.setTitle(virtualFile.getName() + ": Reload or Convert to " + charset.displayName());
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JLabel label = new JLabel(XmlStringUtil.wrapInHtml((CharSequence)("The encoding you've chosen ('" + this.charset.displayName() + "') may change the contents of '" + this.virtualFile.getName() + "'.<br>Do you want to reload the file from disk or<br>convert the text and save in the new encoding?")));
        label.setIcon(Messages.getQuestionIcon());
        label.setIconTextGap(10);
        return label;
    }

    @NotNull
    protected Action[] createActions() {
        DialogWrapper.DialogWrapperAction reloadAction = new DialogWrapper.DialogWrapperAction("Reload"){

            protected void doAction(ActionEvent e) {
                if (IncompatibleEncodingDialog.this.safeToReload == EncodingUtil.Magic8.NO_WAY) {
                    int res;
                    Pair<Charset, String> detected = EncodingUtil.checkCanReload(IncompatibleEncodingDialog.this.virtualFile);
                    String failReason = (String)detected.second;
                    Charset autoDetected = (Charset)detected.first;
                    byte[] bom = IncompatibleEncodingDialog.this.virtualFile.getBOM();
                    if (bom != null) {
                        Messages.showErrorDialog((String)XmlStringUtil.wrapInHtml((CharSequence)("File '" + IncompatibleEncodingDialog.this.virtualFile.getName() + "' can't be reloaded in the '" + IncompatibleEncodingDialog.this.charset.displayName() + "' encoding.<br><br>" + (failReason == null ? "" : "Why: " + failReason + "<br>") + (autoDetected == null ? "" : "Detected encoding: '" + autoDetected.displayName() + "'"))), (String)("Incompatible Encoding: " + IncompatibleEncodingDialog.this.charset.displayName()));
                        res = -1;
                    } else {
                        res = Messages.showDialog((String)XmlStringUtil.wrapInHtml((CharSequence)("File '" + IncompatibleEncodingDialog.this.virtualFile.getName() + "' most likely isn't stored in the '" + IncompatibleEncodingDialog.this.charset.displayName() + "' encoding.<br><br>" + (failReason == null ? "" : "Why: " + failReason + "<br>") + (autoDetected == null ? "" : "Detected encoding: '" + autoDetected.displayName() + "'"))), (String)("Incompatible Encoding: " + IncompatibleEncodingDialog.this.charset.displayName()), (String[])new String[]{"Reload anyway", "Cancel"}, (int)1, (Icon)AllIcons.General.WarningDialog);
                    }
                    if (res != 0) {
                        IncompatibleEncodingDialog.this.doCancelAction();
                        return;
                    }
                }
                IncompatibleEncodingDialog.this.close(10);
            }
        };
        if (!SystemInfo.isMac && this.safeToReload == EncodingUtil.Magic8.NO_WAY) {
            reloadAction.putValue("SmallIcon", (Object)AllIcons.General.Warning);
        }
        reloadAction.putValue("MnemonicKey", (Object)82);
        DialogWrapper.DialogWrapperAction convertAction = new DialogWrapper.DialogWrapperAction("Convert"){

            protected void doAction(ActionEvent e) {
                if (IncompatibleEncodingDialog.this.safeToConvert == EncodingUtil.Magic8.NO_WAY) {
                    String error = EncodingUtil.checkCanConvert(IncompatibleEncodingDialog.this.virtualFile);
                    int res = Messages.showDialog((String)XmlStringUtil.wrapInHtml((CharSequence)("Please do not convert to '" + IncompatibleEncodingDialog.this.charset.displayName() + "'.<br><br>" + (error == null ? "Encoding '" + IncompatibleEncodingDialog.this.charset.displayName() + "' does not support some characters from the text." : "Because " + error))), (String)("Incompatible Encoding: " + IncompatibleEncodingDialog.this.charset.displayName()), (String[])new String[]{"Convert anyway", "Cancel"}, (int)1, (Icon)AllIcons.General.WarningDialog);
                    if (res != 0) {
                        IncompatibleEncodingDialog.this.doCancelAction();
                        return;
                    }
                }
                IncompatibleEncodingDialog.this.close(20);
            }

            public boolean isEnabled() {
                return !FileUtilRt.isTooLarge((long)IncompatibleEncodingDialog.this.virtualFile.getLength());
            }
        };
        if (!SystemInfo.isMac && this.safeToConvert == EncodingUtil.Magic8.NO_WAY) {
            convertAction.putValue("SmallIcon", (Object)AllIcons.General.Warning);
        }
        convertAction.putValue("MnemonicKey", (Object)67);
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        return new Action[]{reloadAction, convertAction, cancelAction};
    }
}

