/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilePointerPartNode {
    private static final FilePointerPartNode[] EMPTY_ARRAY = new FilePointerPartNode[0];
    @NotNull
    String part;
    @NotNull
    FilePointerPartNode[] children;
    FilePointerPartNode parent;
    private Object leaves;
    volatile Pair<VirtualFile, String> myFileAndUrl;
    volatile long myLastUpdated = -1L;
    volatile int useCount;
    int pointersUnder;
    private static final VirtualFileManager ourFileManager = VirtualFileManager.getInstance();
    private static final ManagingFS ourManagingFS = ManagingFS.getInstance();
    private static final boolean UNIT_TEST = ApplicationManager.getApplication().isUnitTestMode();

    FilePointerPartNode(@NotNull String part, FilePointerPartNode parent, Pair<VirtualFile, String> fileAndUrl) {
        this.part = part;
        this.parent = parent;
        this.children = EMPTY_ARRAY;
        this.myFileAndUrl = fileAndUrl;
    }

    public String toString() {
        return this.part + (this.children.length == 0 ? "" : " -> " + this.children.length);
    }

    private int position(@Nullable VirtualFile parent, @Nullable CharSequence parentName, boolean separator, @NotNull CharSequence childName, @NotNull FilePointerPartNode[] outNode) {
        int index;
        int partStart;
        if (parent == null) {
            partStart = 0;
            outNode[0] = this;
        } else {
            VirtualFile gParent;
            CharSequence gParentName = (gParent = parent.getParent()) == null ? null : gParent.getNameSequence();
            partStart = this.position(gParent, gParentName, gParentName != null && !StringUtil.equals((CharSequence)gParentName, (CharSequence)"/"), parentName, outNode);
            if (partStart == -1) {
                return -1;
            }
        }
        boolean childSeparator = false;
        if (separator) {
            if (partStart == outNode[0].part.length()) {
                childSeparator = true;
            } else {
                int sepIndex = FilePointerPartNode.indexOfFirstDifferentChar("/", 0, outNode[0].part, partStart);
                if (sepIndex != 1) {
                    return -1;
                }
                ++partStart;
            }
        }
        if ((index = FilePointerPartNode.indexOfFirstDifferentChar(childName, 0, outNode[0].part, partStart)) == childName.length()) {
            return partStart + index;
        }
        if (partStart + index == outNode[0].part.length()) {
            for (FilePointerPartNode child : outNode[0].children) {
                int childPos = child.position(null, null, childSeparator, childName.subSequence(index, childName.length()), outNode);
                if (childPos == -1) continue;
                return childPos;
            }
        }
        return -1;
    }

    void addPointersUnder(@Nullable VirtualFile parent, boolean separator, @NotNull CharSequence childName, @NotNull List<FilePointerPartNode> out) {
        FilePointerPartNode[] outNode;
        CharSequence parentName = parent == null ? null : parent.getNameSequence();
        int position = this.position(parent, parentName, separator, childName, outNode = new FilePointerPartNode[1]);
        if (position != -1) {
            FilePointerPartNode node = outNode[0];
            FilePointerPartNode.addAllPointersUnder(node, out);
        }
    }

    private static void addAllPointersUnder(@NotNull FilePointerPartNode node, @NotNull List<FilePointerPartNode> out) {
        if (node.leaves != null) {
            out.add(node);
        }
        for (FilePointerPartNode child : node.children) {
            FilePointerPartNode.addAllPointersUnder(child, out);
        }
    }

    void checkConsistency() {
        if (UNIT_TEST && !ApplicationInfoImpl.isInStressTest()) {
            this.doCheckConsistency(false);
        }
    }

    private void doCheckConsistency(boolean dotDotOccurred) {
        boolean hasFile;
        dotDotOccurred |= this.part.contains("..");
        int childSum = 0;
        for (FilePointerPartNode child : this.children) {
            childSum += child.pointersUnder;
            child.doCheckConsistency(dotDotOccurred);
            assert (child.parent == this);
        }
        childSum += this.leavesNumber();
        assert (this.useCount == 0 == (this.leaves == null)) : this.useCount + " - " + (this.leaves instanceof VirtualFilePointerImpl ? this.leaves : Arrays.toString((Object[])((VirtualFilePointerImpl[])this.leaves)));
        assert (this.pointersUnder == childSum) : "expected: " + this.pointersUnder + "; actual: " + childSum;
        Pair<VirtualFile, String> fileAndUrl = this.myFileAndUrl;
        if (fileAndUrl != null && fileAndUrl.second != null) {
            String url = (String)fileAndUrl.second;
            assert (FilePointerPartNode.endsWith(url, this.part)) : "part is: '" + this.part + "' but url is: '" + url + "'";
        }
        boolean bl = hasFile = fileAndUrl != null && fileAndUrl.first != null;
        assert (!hasFile || !dotDotOccurred) : "Path is not canonical: '" + this.getUrl() + "'; my part: '" + this.part + "'";
    }

    @NotNull
    FilePointerPartNode findPointerOrCreate(@NotNull String path, int start, @NotNull Pair<VirtualFile, String> fileAndUrl, int pointersToStore) {
        FilePointerPartNode[] filePointerPartNodeArray;
        String pathRest;
        FilePointerPartNode newNode;
        int index = this.indexOfFirstDifferentChar(path, start);
        if (index == path.length() && index - start == this.part.length()) {
            if (this.leaves == null) {
                this.pointersUnder += pointersToStore;
            }
            return this;
        }
        if (index - start == this.part.length()) {
            for (FilePointerPartNode child : this.children) {
                int i2 = child.indexOfFirstDifferentChar(path, index);
                if (i2 == index || i2 <= index + 1 && path.charAt(index) == '/' && index != 0) continue;
                FilePointerPartNode node = child.findPointerOrCreate(path, index, fileAndUrl, pointersToStore);
                if (node.leaves == null) {
                    this.pointersUnder += pointersToStore;
                }
                return node;
            }
            String pathRest2 = path.substring(index);
            FilePointerPartNode newNode2 = new FilePointerPartNode(pathRest2, this, fileAndUrl);
            newNode2.pointersUnder += pointersToStore;
            this.children = (FilePointerPartNode[])ArrayUtil.append((Object[])this.children, (Object)newNode2);
            this.pointersUnder += pointersToStore;
            return newNode2;
        }
        if (index > start + 1 && index != path.length() && path.charAt(index - 1) == '/') {
            --index;
        }
        FilePointerPartNode filePointerPartNode = newNode = (pathRest = path.substring(index)).isEmpty() ? this : new FilePointerPartNode(pathRest, this, fileAndUrl);
        if (newNode != this) {
            newNode.pointersUnder = pointersToStore;
        }
        String commonPredecessor = StringUtil.first((String)this.part, (int)(index - start), (boolean)false);
        FilePointerPartNode splittedAway = new FilePointerPartNode(this.part.substring(index - start), this, this.myFileAndUrl);
        splittedAway.children = this.children;
        for (FilePointerPartNode child : this.children) {
            child.parent = splittedAway;
        }
        splittedAway.pointersUnder = this.pointersUnder;
        splittedAway.useCount = this.useCount;
        splittedAway.associate(this.leaves, this.myFileAndUrl);
        this.useCount = 0;
        this.part = commonPredecessor;
        if (newNode == this) {
            FilePointerPartNode[] filePointerPartNodeArray2 = new FilePointerPartNode[1];
            filePointerPartNodeArray = filePointerPartNodeArray2;
            filePointerPartNodeArray2[0] = splittedAway;
        } else {
            FilePointerPartNode[] filePointerPartNodeArray3 = new FilePointerPartNode[2];
            filePointerPartNodeArray3[0] = splittedAway;
            filePointerPartNodeArray = filePointerPartNodeArray3;
            filePointerPartNodeArray3[1] = newNode;
        }
        this.children = filePointerPartNodeArray;
        this.pointersUnder += pointersToStore;
        this.associate(null, null);
        return newNode;
    }

    @NotNull
    FilePointerPartNode remove() {
        int pointersNumber = this.leavesNumber();
        assert (this.leaves != null) : this.toString();
        this.associate(null, null);
        this.useCount = 0;
        this.myLastUpdated = -1L;
        FilePointerPartNode node = this;
        while (node.parent != null) {
            node.pointersUnder -= pointersNumber;
            node = node.parent;
        }
        if ((node.pointersUnder -= pointersNumber) == 0) {
            node.children = EMPTY_ARRAY;
        }
        return node;
    }

    private int indexOfFirstDifferentChar(@NotNull CharSequence path, int start) {
        return FilePointerPartNode.indexOfFirstDifferentChar(path, start, this.part, 0);
    }

    private static boolean endsWith(@NotNull String string, @NotNull String end) {
        return FilePointerPartNode.indexOfFirstDifferentChar(string, string.length() - end.length(), end, 0) == string.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means this node's myFileAndUrl became invalid (e.g. after splitting into two other nodes)")
    Pair<VirtualFile, String> update() {
        Pair result2;
        boolean fileIsValid;
        long lastUpdated = this.myLastUpdated;
        Pair fileAndUrl = this.myFileAndUrl;
        if (fileAndUrl == null) {
            return null;
        }
        long fsModCount = ourManagingFS.getStructureModificationCount();
        if (lastUpdated == fsModCount) {
            return fileAndUrl;
        }
        VirtualFile file2 = (VirtualFile)fileAndUrl.first;
        String url = (String)fileAndUrl.second;
        boolean changed = false;
        if (url == null) {
            url = file2.getUrl();
            if (!file2.isValid()) {
                file2 = null;
            }
            changed = true;
        }
        boolean bl = fileIsValid = file2 != null && file2.isValid();
        if (file2 != null && !fileIsValid) {
            file2 = null;
            changed = true;
        }
        if (file2 == null) {
            file2 = ourFileManager.findFileByUrl(url);
            boolean bl2 = fileIsValid = file2 != null && file2.isValid();
            if (file2 != null) {
                changed = true;
            }
        }
        if (file2 != null) {
            if (fileIsValid) {
                url = file2.getUrl();
                changed |= !url.equals(fileAndUrl.second);
            } else {
                file2 = null;
                changed = true;
            }
        }
        if (changed) {
            result2 = Pair.create((Object)file2, (Object)url);
            VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
            synchronized (virtualFilePointerManager) {
                Pair<VirtualFile, String> storedFileAndUrl = this.myFileAndUrl;
                if (storedFileAndUrl == null || storedFileAndUrl != fileAndUrl) {
                    return null;
                }
                this.myFileAndUrl = result2;
            }
        } else {
            result2 = fileAndUrl;
        }
        this.myLastUpdated = fsModCount;
        return result2;
    }

    private static int indexOfFirstDifferentChar(@NotNull CharSequence s1, int start1, @NotNull String s2, int start2) {
        boolean ignoreCase = !SystemInfo.isFileSystemCaseSensitive;
        int len1 = s1.length();
        int len2 = s2.length();
        while (start1 < len1 && start2 < len2) {
            char c2;
            char c1 = s1.charAt(start1);
            if (!StringUtil.charsEqual((char)c1, (char)(c2 = s2.charAt(start2)), (boolean)ignoreCase)) {
                return start1;
            }
            ++start1;
            ++start2;
        }
        return start1;
    }

    void associate(Object leaves, Pair<VirtualFile, String> fileAndUrl) {
        this.leaves = leaves;
        this.myFileAndUrl = fileAndUrl;
        if (leaves != null) {
            if (leaves instanceof VirtualFilePointerImpl) {
                ((VirtualFilePointerImpl)((Object)leaves)).myNode = this;
            } else {
                for (VirtualFilePointerImpl pointer : (VirtualFilePointerImpl[])leaves) {
                    pointer.myNode = this;
                }
            }
        }
        this.myLastUpdated = -1L;
    }

    int incrementUsageCount(int delta) {
        return this.useCount += delta;
    }

    int numberOfPointersUnder() {
        return this.pointersUnder;
    }

    VirtualFilePointerImpl getAnyPointer() {
        Object leaves = this.leaves;
        return leaves == null ? null : (leaves instanceof VirtualFilePointerImpl ? (VirtualFilePointerImpl)((Object)leaves) : ((VirtualFilePointerImpl[])leaves)[0]);
    }

    private String getUrl() {
        return this.parent == null ? this.part : this.parent.getUrl() + this.part;
    }

    private int leavesNumber() {
        Object leaves = this.leaves;
        return leaves == null ? 0 : (leaves instanceof VirtualFilePointerImpl ? 1 : ((VirtualFilePointerImpl[])leaves).length);
    }

    void addAllPointersTo(@NotNull Collection<? super VirtualFilePointerImpl> outList) {
        Object leaves = this.leaves;
        if (leaves == null) {
            return;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            outList.add((VirtualFilePointerImpl)((Object)leaves));
        } else {
            ContainerUtil.addAll(outList, (Object[])((VirtualFilePointerImpl[])leaves));
        }
    }
}

