/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerContainerImpl
extends TraceableDisposable
implements VirtualFilePointerContainer,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer");
    @NotNull
    private final List<VirtualFilePointer> myList = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private final VirtualFilePointerManager myVirtualFilePointerManager;
    @NotNull
    private final Disposable myParent;
    private final VirtualFilePointerListener myListener;
    private volatile Trinity<String[], VirtualFile[], VirtualFile[]> myCachedThings;
    private volatile long myTimeStampOfCachedThings = -1L;
    @NonNls
    private static final String URL_ATTR = "url";
    private boolean myDisposed;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    private static final Trinity<String[], VirtualFile[], VirtualFile[]> EMPTY = Trinity.create((Object)ArrayUtil.EMPTY_STRING_ARRAY, (Object)VirtualFile.EMPTY_ARRAY, (Object)VirtualFile.EMPTY_ARRAY);

    VirtualFilePointerContainerImpl(@NotNull VirtualFilePointerManager manager, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        super(TRACE_CREATION && !ApplicationInfoImpl.isInStressTest());
        this.myVirtualFilePointerManager = manager;
        this.myParent = parentDisposable;
        this.myListener = listener2;
    }

    public void readExternal(@NotNull Element rootChild, @NotNull String childElements) throws InvalidDataException {
        List urls = rootChild.getChildren(childElements);
        for (Element url : urls) {
            String urlAttribute = url.getAttributeValue(URL_ATTR);
            if (urlAttribute == null) {
                throw new InvalidDataException("path element without url");
            }
            this.add(urlAttribute);
        }
    }

    public void writeExternal(@NotNull Element element, @NotNull String childElementName) {
        for (VirtualFilePointer pointer : this.myList) {
            String url = pointer.getUrl();
            Element rootPathElement = new Element(childElementName);
            rootPathElement.setAttribute(URL_ATTR, url);
            element.addContent(rootPathElement);
        }
    }

    public void moveUp(@NotNull String url) {
        int index = this.indexOf(url);
        if (index <= 0) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)(index - 1), (int)index);
    }

    public void moveDown(@NotNull String url) {
        int index = this.indexOf(url);
        if (index < 0 || index + 1 >= this.myList.size()) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)index, (int)(index + 1));
    }

    private int indexOf(@NotNull String url) {
        for (int i = 0; i < this.myList.size(); ++i) {
            VirtualFilePointer pointer = this.myList.get(i);
            if (!url.equals(pointer.getUrl())) continue;
            return i;
        }
        return -1;
    }

    public void killAll() {
        this.myList.clear();
    }

    public void add(@NotNull VirtualFile file2) {
        assert (!this.myDisposed);
        this.dropCaches();
        VirtualFilePointer pointer = this.create(file2);
        this.myList.add(pointer);
    }

    public void add(@NotNull String url) {
        assert (!this.myDisposed);
        this.dropCaches();
        VirtualFilePointer pointer = this.create(url);
        this.myList.add(pointer);
    }

    public void remove(@NotNull VirtualFilePointer pointer) {
        assert (!this.myDisposed);
        this.dropCaches();
        boolean result2 = this.myList.remove(pointer);
        LOG.assertTrue(result2);
    }

    @NotNull
    public List<VirtualFilePointer> getList() {
        assert (!this.myDisposed);
        return Collections.unmodifiableList(this.myList);
    }

    public void addAll(@NotNull VirtualFilePointerContainer that) {
        assert (!this.myDisposed);
        this.dropCaches();
        for (VirtualFilePointer pointer : that.getList()) {
            this.myList.add(this.duplicate(pointer));
        }
    }

    private void dropCaches() {
        this.myTimeStampOfCachedThings = -1L;
        this.myCachedThings = EMPTY;
    }

    @NotNull
    public String[] getUrls() {
        return (String[])this.getOrCache().first;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> getOrCache() {
        assert (!this.myDisposed);
        long timeStamp = this.myTimeStampOfCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> cached = this.myCachedThings;
        return timeStamp == this.myVirtualFilePointerManager.getModificationCount() ? cached : this.cacheThings();
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> cacheThings() {
        Trinity result2;
        if (this.myList.isEmpty()) {
            result2 = EMPTY;
        } else {
            ArrayList<VirtualFile> cachedFiles = new ArrayList<VirtualFile>(this.myList.size());
            ArrayList<String> cachedUrls = new ArrayList<String>(this.myList.size());
            ArrayList<VirtualFile> cachedDirectories = new ArrayList<VirtualFile>(this.myList.size() / 3);
            boolean allFilesAreDirs = true;
            for (VirtualFilePointer v : this.myList) {
                VirtualFile file2 = v.getFile();
                String url = v.getUrl();
                cachedUrls.add(url);
                if (file2 == null) continue;
                cachedFiles.add(file2);
                if (file2.isDirectory()) {
                    cachedDirectories.add(file2);
                    continue;
                }
                allFilesAreDirs = false;
            }
            VirtualFile[] directories = VfsUtilCore.toVirtualFileArray(cachedDirectories);
            VirtualFile[] files = allFilesAreDirs ? directories : VfsUtilCore.toVirtualFileArray(cachedFiles);
            String[] urlsArray = ArrayUtil.toStringArray(cachedUrls);
            result2 = Trinity.create((Object)urlsArray, (Object)files, (Object)directories);
        }
        this.myCachedThings = result2;
        this.myTimeStampOfCachedThings = this.myVirtualFilePointerManager.getModificationCount();
        return result2;
    }

    @NotNull
    public VirtualFile[] getFiles() {
        return (VirtualFile[])this.getOrCache().second;
    }

    @NotNull
    public VirtualFile[] getDirectories() {
        return (VirtualFile[])this.getOrCache().third;
    }

    @Nullable
    public VirtualFilePointer findByUrl(@NotNull String url) {
        assert (!this.myDisposed);
        for (VirtualFilePointer pointer : this.myList) {
            if (!url.equals(pointer.getUrl())) continue;
            return pointer;
        }
        return null;
    }

    public void clear() {
        this.dropCaches();
        this.killAll();
    }

    public int size() {
        return this.myList.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFilePointerContainerImpl)) {
            return false;
        }
        VirtualFilePointerContainerImpl virtualFilePointerContainer = (VirtualFilePointerContainerImpl)((Object)o);
        return this.myList.equals(virtualFilePointerContainer.myList);
    }

    public int hashCode() {
        return this.myList.hashCode();
    }

    protected VirtualFilePointer create(@NotNull VirtualFile file2) {
        return this.myVirtualFilePointerManager.create(file2, this.myParent, this.myListener);
    }

    protected VirtualFilePointer create(@NotNull String url) {
        return this.myVirtualFilePointerManager.create(url, this.myParent, this.myListener);
    }

    protected VirtualFilePointer duplicate(@NotNull VirtualFilePointer virtualFilePointer) {
        return this.myVirtualFilePointerManager.duplicate(virtualFilePointer, this.myParent, this.myListener);
    }

    @NotNull
    @NonNls
    public String toString() {
        return "VFPContainer: " + this.myList;
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent) {
        return this.clone(parent, null);
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        assert (!this.myDisposed);
        VirtualFilePointerContainer clone = this.myVirtualFilePointerManager.createContainer(parent, listener2);
        for (VirtualFilePointer pointer : this.myList) {
            clone.add(pointer.getUrl());
        }
        return clone;
    }

    public void dispose() {
        assert (!this.myDisposed);
        this.myDisposed = true;
        this.kill(null);
    }
}

