/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ZipEntryMap
extends AbstractMap<String, ArchiveHandler.EntryInfo> {
    private ArchiveHandler.EntryInfo[] entries;
    private int size = 0;
    private EntrySet entrySet;

    ZipEntryMap(int expectedSize) {
        this.entries = new ArchiveHandler.EntryInfo[Math.max(10, expectedSize * 2)];
    }

    @Override
    public ArchiveHandler.EntryInfo get(@NotNull Object key2) {
        ArchiveHandler.EntryInfo entry;
        int index;
        String relativePath = (String)key2;
        int i2 = index = ZipEntryMap.index(relativePath, this.entries);
        while ((entry = this.entries[i2]) != null && !ZipEntryMap.isTheOne(entry, relativePath)) {
            if (++i2 == this.entries.length) {
                i2 = 0;
            }
            if (i2 != index) continue;
            entry = null;
            break;
        }
        return entry;
    }

    private static int index(@NotNull String relativePath, @NotNull ArchiveHandler.EntryInfo[] entries) {
        return (relativePath.hashCode() & Integer.MAX_VALUE) % entries.length;
    }

    @Override
    public ArchiveHandler.EntryInfo put(String relativePath, ArchiveHandler.EntryInfo value2) {
        ArchiveHandler.EntryInfo old;
        if (this.size >= 5 * this.entries.length / 8) {
            this.rehash();
        }
        if ((old = ZipEntryMap.put(relativePath, value2, this.entries)) == null) {
            ++this.size;
        }
        return old;
    }

    @Nullable
    private static ArchiveHandler.EntryInfo put(@NotNull String relativePath, @NotNull ArchiveHandler.EntryInfo value2, @NotNull ArchiveHandler.EntryInfo[] entries) {
        ArchiveHandler.EntryInfo entry;
        int index;
        int i2 = index = ZipEntryMap.index(relativePath, entries);
        while (true) {
            if ((entry = entries[i2]) == null || ZipEntryMap.isTheOne(entry, relativePath)) break;
            if (++i2 != entries.length) continue;
            i2 = 0;
        }
        entries[i2] = value2;
        return entry;
    }

    private static boolean isTheOne(@NotNull ArchiveHandler.EntryInfo entry, @NotNull CharSequence relativePath) {
        int endIndex = relativePath.length();
        ArchiveHandler.EntryInfo e = entry;
        while (e != null) {
            CharSequence shortName = e.shortName;
            if (!CharArrayUtil.regionMatches((CharSequence)relativePath, (int)(endIndex - shortName.length()), (int)relativePath.length(), (CharSequence)shortName)) {
                return false;
            }
            if (e.parent != null && e.parent.shortName.length() != 0 && (endIndex -= shortName.length()) != 0) {
                if (relativePath.charAt(endIndex - 1) == '/') {
                    --endIndex;
                } else {
                    return false;
                }
            }
            e = e.parent;
        }
        return endIndex == 0;
    }

    @NotNull
    private ArchiveHandler.EntryInfo[] rehash() {
        ArchiveHandler.EntryInfo[] newEntries = new ArchiveHandler.EntryInfo[this.entries.length < 1000 ? this.entries.length * 2 : this.entries.length * 3 / 2];
        for (ArchiveHandler.EntryInfo entry : this.entries) {
            if (entry == null) continue;
            ZipEntryMap.put(ZipEntryMap.getRelativePath(entry), entry, newEntries);
        }
        this.entries = newEntries;
        return newEntries;
    }

    @NotNull
    private static String getRelativePath(@NotNull ArchiveHandler.EntryInfo entry) {
        StringBuilder result2 = new StringBuilder(entry.shortName.length() + 10);
        ArchiveHandler.EntryInfo e = entry;
        while (e != null) {
            if (result2.length() != 0 && e.shortName.length() != 0) {
                result2.append('/');
            }
            ZipEntryMap.appendReversed(result2, e.shortName);
            e = e.parent;
        }
        return result2.reverse().toString();
    }

    private static void appendReversed(@NotNull StringBuilder builder, @NotNull CharSequence sequence) {
        for (int i2 = sequence.length() - 1; i2 >= 0; --i2) {
            builder.append(sequence.charAt(i2));
        }
    }

    @Override
    public ArchiveHandler.EntryInfo remove(@NotNull Object key2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.entries = new ArchiveHandler.EntryInfo[10];
    }

    @NotNull
    public EntrySet entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    @Override
    @NotNull
    public Collection<ArchiveHandler.EntryInfo> values() {
        return ContainerUtil.filter((Object[])this.entries, (Condition)Condition.NOT_NULL);
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<String, ArchiveHandler.EntryInfo>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return ZipEntryMap.this.size();
        }

        @Override
        public final void clear() {
            ZipEntryMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<String, ArchiveHandler.EntryInfo>> iterator() {
            return ContainerUtil.mapIterator(ContainerUtil.iterate((Object[])ZipEntryMap.this.entries, (Condition)Condition.NOT_NULL).iterator(), entry -> new AbstractMap.SimpleEntry<String, ArchiveHandler.EntryInfo>(ZipEntryMap.getRelativePath(entry), (ArchiveHandler.EntryInfo)entry));
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key2 = (String)e.getKey();
            ArchiveHandler.EntryInfo value2 = (ArchiveHandler.EntryInfo)e.getValue();
            return value2.equals(ZipEntryMap.this.get(key2));
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

