/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipHandler
extends ArchiveHandler {
    private volatile String myCanonicalPathToZip;
    private volatile long myFileStamp;
    private volatile long myFileLength;
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        protected ZipFile createAccessor(ZipHandler key2) throws IOException {
            String canonicalPathToZip = key2.getCanonicalPathToZip();
            ZipHandler.setFileStampAndLength(key2, canonicalPathToZip);
            return new ZipFile(canonicalPathToZip);
        }

        protected void disposeAccessor(ZipFile fileAccessor) throws IOException {
            fileAccessor.close();
        }

        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path) {
        super(path);
    }

    protected static synchronized void setFileStampAndLength(ZipHandler zipHandler, String pathToZip) {
        FileAttributes attributes = FileSystemUtil.getAttributes((String)pathToZip);
        zipHandler.myFileStamp = attributes != null ? attributes.lastModified : -1L;
        zipHandler.myFileLength = attributes != null ? attributes.length : 0L;
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value2 = this.myCanonicalPathToZip;
        if (value2 == null) {
            this.myCanonicalPathToZip = value2 = this.getFileToUse().getCanonicalPath();
        }
        return value2;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        FileAccessorCache.Handle<ZipFile> existingZipRef = this.getCachedZipFileHandle(true);
        try {
            Map<String, ArchiveHandler.EntryInfo> map2 = this.buildEntryMapForZipFile((ZipFile)existingZipRef.get());
            return map2;
        }
        finally {
            existingZipRef.release();
        }
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(ZipFile zip) {
        ZipEntryMap map2 = new ZipEntryMap(zip.size());
        map2.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map2, zip);
        }
        return map2;
    }

    @Contract(value="true -> !null")
    protected FileAccessorCache.Handle<ZipFile> getCachedZipFileHandle(boolean createIfNeeded) throws IOException {
        try {
            FileAccessorCache.Handle handle;
            FileAccessorCache.Handle handle2 = handle = createIfNeeded ? ourZipFileFileAccessorCache.get((Object)this) : ourZipFileFileAccessorCache.getIfCached((Object)this);
            if (handle != null && this.getFile() == this.getFileToUse()) {
                FileAttributes attributes = FileSystemUtil.getAttributes((String)this.getCanonicalPathToZip());
                if (attributes == null) {
                    throw new FileNotFoundException(this.getCanonicalPathToZip());
                }
                if (attributes.lastModified == this.myFileStamp && attributes.length == this.myFileLength) {
                    return handle;
                }
                this.removeZipHandlerFromCache();
                handle.release();
                handle = ourZipFileFileAccessorCache.get((Object)this);
            }
            return handle;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    private void removeZipHandlerFromCache() {
        ourZipFileFileAccessorCache.remove((Object)this);
    }

    @NotNull
    protected File getFileToUse() {
        return this.getFile();
    }

    public void dispose() {
        super.dispose();
        this.removeZipHandlerFromCache();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar((CharSequence)entryName, (char)'/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map2.get(entryName)) != null) {
            return info;
        }
        Pair path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip);
        if (".".equals(path.second)) {
            return parentInfo;
        }
        info = ZipHandler.store(map2, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), this.myFileStamp, entryName);
        return info;
    }

    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map2, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String entryName) {
        CharSequence sequence = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfAsciiString((CharSequence)shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence, isDirectory, size, time, parentInfo);
        map2.put(entryName, info);
        return info;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info = map2.get(entryName);
        if (info == null) {
            ZipEntry entry = zip.getEntry(entryName + "/");
            if (entry != null) {
                return this.getOrCreate(entry, map2, zip);
            }
            Pair path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip);
            info = ZipHandler.store(map2, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(((Object)((Object)this)).getClass()).info(zip.getName() + ": " + entryName + " should be a directory");
            info = ZipHandler.store(map2, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        FileAccessorCache.Handle<ZipFile> zipRef = this.getCachedZipFileHandle(true);
        try {
            ZipFile zip = (ZipFile)zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry != null) {
                long length = entry.getSize();
                if (FileUtilRt.isTooLarge((long)length)) {
                    throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                }
                InputStream stream = zip.getInputStream(entry);
                if (stream != null) {
                    byte[] byArray;
                    try {
                        byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)length));
                    }
                    catch (Throwable throwable) {
                        stream.close();
                        throw throwable;
                    }
                    stream.close();
                    return byArray;
                }
            }
        }
        finally {
            zipRef.release();
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        boolean release = true;
        FileAccessorCache.Handle<ZipFile> zipRef = this.getCachedZipFileHandle(true);
        try {
            InputStream stream;
            ZipFile zip = (ZipFile)zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry != null && (stream = zip.getInputStream(entry)) != null) {
                long length = entry.getSize();
                if (!FileUtilRt.isTooLarge((long)length)) {
                    try {
                        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(FileUtil.loadBytes((InputStream)stream, (int)((int)length)));
                        return bufferExposingByteArrayInputStream;
                    }
                    finally {
                        stream.close();
                    }
                }
                release = false;
                InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(stream, zipRef);
                return inputStreamWrapper;
            }
        }
        finally {
            if (release) {
                zipRef.release();
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final InputStream myStream;
        private final FileAccessorCache.Handle<ZipFile> myZipRef;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public InputStreamWrapper(InputStream stream, FileAccessorCache.Handle<ZipFile> zipRef) {
            this.myStream = stream;
            this.myZipRef = zipRef;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            return this.myStream.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.myStream.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                try {
                    this.myStream.close();
                }
                finally {
                    this.myZipRef.release();
                }
            }
        }
    }
}

