/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

public class DefaultRemoteContentProvider
extends RemoteContentProvider {
    private static final Logger LOG = Logger.getInstance(DefaultRemoteContentProvider.class);

    @NotNull
    public static RequestBuilder addRequestTuner(@NotNull Url url, @NotNull RequestBuilder requestBuilder) {
        BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
        if (builtInServerManager.isOnBuiltInWebServer(url)) {
            requestBuilder.tuner(arg_0 -> ((BuiltInServerManager)builtInServerManager).configureRequestToWebServer(arg_0));
        }
        return requestBuilder;
    }

    @Override
    public boolean canProvideContent(@NotNull Url url) {
        return true;
    }

    @Override
    public void saveContent(@NotNull Url url, @NotNull File file2, @NotNull RemoteContentProvider.DownloadingCallback callback) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> DefaultRemoteContentProvider.downloadContent(url, file2, callback));
    }

    private static void downloadContent(final @NotNull Url url, final File file2, final RemoteContentProvider.DownloadingCallback callback) {
        LOG.debug("Downloading started: " + url);
        final String presentableUrl = StringUtil.trimMiddle((String)url.trimParameters().toDecodedForm(), (int)40);
        callback.setProgressText(VfsBundle.message((String)"download.progress.connecting", (Object[])new Object[]{presentableUrl}), true);
        try {
            DefaultRemoteContentProvider.addRequestTuner(url, HttpRequests.request((String)url.toExternalForm())).connectTimeout(60000).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

                public Object process(@NotNull HttpRequests.Request request) throws IOException {
                    FileType fileTypeByFileName;
                    int size = request.getConnection().getContentLength();
                    callback.setProgressText(VfsBundle.message((String)"download.progress.downloading", (Object[])new Object[]{presentableUrl}), size == -1);
                    request.saveToFile(file2, (ProgressIndicator)new AbstractProgressIndicatorExBase(){

                        @Override
                        public void setFraction(double fraction) {
                            callback.setProgressFraction(0.0);
                        }
                    });
                    FileType fileType = RemoteFileUtil.getFileType(request.getConnection().getContentType());
                    if (fileType == FileTypes.PLAIN_TEXT && (fileTypeByFileName = FileTypeRegistry.getInstance().getFileTypeByFileName(PathUtilRt.getFileName((String)url.getPath()))) != FileTypes.UNKNOWN) {
                        fileType = fileTypeByFileName;
                    }
                    LOG.debug("Downloading finished, " + size + " bytes downloaded");
                    callback.finished(fileType);
                    return null;
                }
            });
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            callback.errorOccurred(VfsBundle.message((String)"cannot.load.remote.file", (Object[])new Object[]{url, e.getMessage()}), false);
        }
    }

    @Override
    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        return false;
    }
}

