/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemBase;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HttpVirtualFileImpl
extends HttpVirtualFile {
    private final HttpFileSystemBase myFileSystem;
    @Nullable
    private final RemoteFileInfoImpl myFileInfo;
    private FileType myInitialFileType;
    private final String myPath;
    private final String myParentPath;
    private final String myName;
    private List<VirtualFile> myChildren;

    HttpVirtualFileImpl(@NotNull HttpFileSystemBase fileSystem, @Nullable HttpVirtualFileImpl parent, String path, @Nullable RemoteFileInfoImpl fileInfo) {
        if (parent != null) {
            if (parent.myChildren == null) {
                parent.myChildren = new SmartList();
            }
            parent.myChildren.add(this);
        }
        this.myFileSystem = fileSystem;
        this.myPath = path;
        this.myFileInfo = fileInfo;
        if (this.myFileInfo != null) {
            this.myFileInfo.addDownloadingListener(new FileDownloadingAdapter(){

                @Override
                public void fileDownloaded(VirtualFile localFile) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        HttpVirtualFileImpl file2 = HttpVirtualFileImpl.this;
                        FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{file2});
                        if (!localFile.getFileType().equals(HttpVirtualFileImpl.this.myInitialFileType)) {
                            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file2});
                        }
                    });
                }
            });
            path = UriUtil.trimTrailingSlashes(UriUtil.trimParameters(path));
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == -1) {
                this.myParentPath = null;
                this.myName = path;
            } else {
                this.myParentPath = path.substring(0, lastSlash);
                this.myName = path.substring(lastSlash + 1);
            }
        } else {
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == path.length() - 1) {
                this.myParentPath = null;
                this.myName = path;
            } else {
                int prevSlash = path.lastIndexOf(47, lastSlash - 1);
                if (prevSlash < 0) {
                    this.myParentPath = path.substring(0, lastSlash + 1);
                    this.myName = path.substring(lastSlash + 1);
                } else {
                    this.myParentPath = path.substring(0, lastSlash);
                    this.myName = path.substring(lastSlash + 1);
                }
            }
        }
    }

    @Override
    @Nullable
    public RemoteFileInfoImpl getFileInfo() {
        return this.myFileInfo;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFileSystem;
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public String toString() {
        return "HttpVirtualFile:" + this.myPath + ", info=" + this.myFileInfo;
    }

    public VirtualFile getParent() {
        return this.myParentPath == null ? null : this.myFileSystem.findFileByPath(this.myParentPath, true);
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isDirectory() {
        return this.myFileInfo == null;
    }

    public VirtualFile[] getChildren() {
        return ContainerUtil.isEmpty(this.myChildren) ? EMPTY_ARRAY : this.myChildren.toArray(new VirtualFile[this.myChildren.size()]);
    }

    @Nullable
    public VirtualFile findChild(@NotNull @NonNls String name) {
        if (!ContainerUtil.isEmpty(this.myChildren)) {
            for (VirtualFile child : this.myChildren) {
                if (!StringUtil.equals((CharSequence)child.getNameSequence(), (CharSequence)name)) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    public FileType getFileType() {
        if (this.myFileInfo == null) {
            return super.getFileType();
        }
        VirtualFile localFile = this.myFileInfo.getLocalFile();
        if (localFile != null) {
            return localFile.getFileType();
        }
        FileType fileType = super.getFileType();
        if (this.myInitialFileType == null) {
            this.myInitialFileType = fileType;
        }
        return fileType;
    }

    public InputStream getInputStream() throws IOException {
        VirtualFile localFile;
        if (this.myFileInfo != null && (localFile = this.myFileInfo.getLocalFile()) != null) {
            return localFile.getInputStream();
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        VirtualFile localFile;
        if (this.myFileInfo != null && (localFile = this.myFileInfo.getLocalFile()) != null) {
            return localFile.getOutputStream(requestor, newModificationStamp, newTimeStamp);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myFileInfo == null) {
            throw new UnsupportedOperationException();
        }
        VirtualFile localFile = this.myFileInfo.getLocalFile();
        if (localFile != null) {
            return localFile.contentsToByteArray();
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getLength() {
        return -1L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (this.myFileInfo != null) {
            this.myFileInfo.refresh(postRunnable);
        } else if (postRunnable != null) {
            postRunnable.run();
        }
    }
}

