/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileManagerImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class RemoteFileInfoImpl
implements RemoteContentProvider.DownloadingCallback,
RemoteFileInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl");
    private final Object myLock = new Object();
    private final Url myUrl;
    private final RemoteFileManagerImpl myManager;
    @Nullable
    private RemoteContentProvider myContentProvider;
    private File myLocalFile;
    private VirtualFile myLocalVirtualFile;
    private VirtualFile myPrevLocalFile;
    private RemoteFileState myState = RemoteFileState.DOWNLOADING_NOT_STARTED;
    private String myErrorMessage;
    private final AtomicBoolean myCancelled = new AtomicBoolean();
    private final List<FileDownloadingListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public RemoteFileInfoImpl(@NotNull Url url, @NotNull RemoteFileManagerImpl manager) {
        this.myUrl = url;
        this.myManager = manager;
    }

    @Override
    public void addDownloadingListener(@NotNull FileDownloadingListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeDownloadingListener(@NotNull FileDownloadingListener listener2) {
        this.myListeners.remove(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartDownloading() {
        Object object = this.myLock;
        synchronized (object) {
            this.myErrorMessage = null;
            this.myPrevLocalFile = this.myLocalVirtualFile;
            this.myLocalVirtualFile = null;
            this.myState = RemoteFileState.DOWNLOADING_NOT_STARTED;
            this.myLocalFile = null;
            this.startDownloading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDownloading() {
        File localFile;
        LOG.debug("Downloading requested");
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            if (this.myState != RemoteFileState.DOWNLOADING_NOT_STARTED) {
                LOG.debug("File already downloaded: file = " + this.myLocalVirtualFile + ", state = " + (Object)((Object)this.myState));
                return;
            }
            this.myState = RemoteFileState.DOWNLOADING_IN_PROGRESS;
            try {
                this.myLocalFile = this.myManager.getStorage().createLocalFile(this.myUrl);
                LOG.debug("Local file created: " + this.myLocalFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.errorOccurred(VfsBundle.message((String)"cannot.create.local.file", (Object[])new Object[]{e.getMessage()}), false);
                return;
            }
            this.myCancelled.set(false);
            localFile = this.myLocalFile;
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.downloadingStarted();
        }
        if (this.myContentProvider == null) {
            this.myContentProvider = this.myManager.findContentProvider(this.myUrl);
        }
        this.myContentProvider.saveContent(this.myUrl, localFile, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(@Nullable FileType fileType) {
        File localIOFile;
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("Downloading finished, size = " + this.myLocalFile.length() + ", file type=" + (fileType != null ? fileType.getName() : "null"));
            if (fileType != null) {
                String fileName = this.myLocalFile.getName();
                int dot = fileName.lastIndexOf(46);
                String extension = fileType.getDefaultExtension();
                if (dot == -1 || !extension.regionMatches(true, 0, fileName, dot + 1, extension.length())) {
                    File newFile = FileUtil.findSequentNonexistentFile((File)this.myLocalFile.getParentFile(), (String)fileName, (String)extension);
                    try {
                        FileUtil.rename((File)this.myLocalFile, (File)newFile);
                        this.myLocalFile = newFile;
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
            localIOFile = this.myLocalFile;
        }
        VirtualFile localFile = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result2) {
                VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(localIOFile);
                if (file2 != null) {
                    file2.refresh(false, false);
                }
                result2.setResult((Object)file2);
            }
        }.execute().getResultObject();
        LOG.assertTrue(localFile != null, (Object)("Virtual local file not found for " + localIOFile.getAbsolutePath()));
        LOG.debug("Virtual local file: " + localFile + ", size = " + localFile.getLength());
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myLocalVirtualFile = localFile;
            this.myPrevLocalFile = null;
            this.myState = RemoteFileState.DOWNLOADED;
            this.myErrorMessage = null;
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.fileDownloaded(localFile);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.myCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getErrorMessage() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myErrorMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorOccurred(@NotNull String errorMessage, boolean cancelled) {
        LOG.debug("Error: " + errorMessage);
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myLocalVirtualFile = null;
            this.myPrevLocalFile = null;
            this.myState = RemoteFileState.ERROR_OCCURRED;
            this.myErrorMessage = errorMessage;
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            if (cancelled) continue;
            listener2.errorOccurred(errorMessage);
        }
    }

    @Override
    public void setProgressFraction(double fraction) {
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.progressFractionChanged(fraction);
        }
    }

    @Override
    public void setProgressText(@NotNull String text, boolean indeterminate) {
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.progressMessageChanged(indeterminate, text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualFile getLocalFile() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myLocalVirtualFile;
        }
    }

    public String toString() {
        String errorMessage = this.getErrorMessage();
        return "state=" + (Object)((Object)this.getState()) + ", local file=" + this.myLocalFile + (errorMessage != null ? ", error=" + errorMessage : "") + (this.isCancelled() ? ", cancelled" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteFileState getState() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDownloading() {
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myCancelled.set(true);
            if (this.myPrevLocalFile != null) {
                this.myLocalVirtualFile = this.myPrevLocalFile;
                this.myLocalFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myLocalVirtualFile);
                this.myState = RemoteFileState.DOWNLOADED;
                this.myErrorMessage = null;
            } else {
                this.myState = RemoteFileState.ERROR_OCCURRED;
            }
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.downloadingCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(@Nullable Runnable postRunnable) {
        VirtualFile localVirtualFile;
        Object object = this.myLock;
        synchronized (object) {
            localVirtualFile = this.myLocalVirtualFile;
        }
        RemoteContentProvider contentProvider = this.myManager.findContentProvider(this.myUrl);
        if (localVirtualFile == null || !contentProvider.equals(this.myContentProvider) || !contentProvider.isUpToDate(this.myUrl, localVirtualFile)) {
            this.myContentProvider = contentProvider;
            this.addDownloadingListener(new MyRefreshingDownloadingListener(postRunnable));
            this.restartDownloading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Promise<VirtualFile> download() {
        Object object = this.myLock;
        synchronized (object) {
            switch (this.getState()) {
                case DOWNLOADING_NOT_STARTED: {
                    this.startDownloading();
                    return RemoteFileInfoImpl.createDownloadedCallback(this);
                }
                case DOWNLOADING_IN_PROGRESS: {
                    return RemoteFileInfoImpl.createDownloadedCallback(this);
                }
                case DOWNLOADED: {
                    return Promise.resolve((Object)this.myLocalVirtualFile);
                }
            }
            return Promises.rejectedPromise((String)"errorOccurred");
        }
    }

    @NotNull
    private static Promise<VirtualFile> createDownloadedCallback(final @NotNull RemoteFileInfo remoteFileInfo) {
        final AsyncPromise promise2 = new AsyncPromise();
        remoteFileInfo.addDownloadingListener(new FileDownloadingAdapter(){

            @Override
            public void fileDownloaded(VirtualFile localFile) {
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise2.setResult((Object)localFile);
                }
            }

            @Override
            public void errorOccurred(@NotNull String errorMessage) {
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise2.setError(errorMessage);
                }
            }

            @Override
            public void downloadingCancelled() {
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise2.setError("Cancelled");
                }
            }
        });
        return promise2;
    }

    private class MyRefreshingDownloadingListener
    extends FileDownloadingAdapter {
        private final Runnable myPostRunnable;

        public MyRefreshingDownloadingListener(Runnable postRunnable) {
            this.myPostRunnable = postRunnable;
        }

        @Override
        public void downloadingCancelled() {
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        @Override
        public void fileDownloaded(VirtualFile localFile) {
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        @Override
        public void errorOccurred(@NotNull String errorMessage) {
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }
    }
}

