/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemBase;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemImpl;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFileImpl;
import com.intellij.openapi.vfs.impl.http.HttpsFileSystem;
import com.intellij.openapi.vfs.impl.http.LocalFileStorage;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Url;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFileManagerImpl
extends RemoteFileManager
implements Disposable {
    private final LocalFileStorage myStorage;
    private final Map<Url, HttpVirtualFileImpl> remoteFiles = new THashMap();
    private final Map<Url, HttpVirtualFileImpl> remoteDirectories = new THashMap();
    private final EventDispatcher<HttpVirtualFileListener> myDispatcher = EventDispatcher.create(HttpVirtualFileListener.class);
    private final List<RemoteContentProvider> myProviders = new ArrayList<RemoteContentProvider>();
    private final DefaultRemoteContentProvider myDefaultRemoteContentProvider;

    public RemoteFileManagerImpl() {
        this.myStorage = new LocalFileStorage();
        this.myDefaultRemoteContentProvider = new DefaultRemoteContentProvider();
    }

    @NotNull
    public RemoteContentProvider findContentProvider(@NotNull Url url) {
        for (RemoteContentProvider provider2 : this.myProviders) {
            if (!provider2.canProvideContent(url)) continue;
            return provider2;
        }
        return this.myDefaultRemoteContentProvider;
    }

    public synchronized HttpVirtualFileImpl getOrCreateFile(@Nullable HttpVirtualFileImpl parent, @NotNull Url url, @NotNull String path, boolean directory) {
        Map<Url, HttpVirtualFileImpl> cache2 = directory ? this.remoteDirectories : this.remoteFiles;
        HttpVirtualFileImpl file2 = cache2.get(url);
        if (file2 == null) {
            if (directory) {
                file2 = new HttpVirtualFileImpl(RemoteFileManagerImpl.getHttpFileSystem(url), parent, path, null);
            } else {
                RemoteFileInfoImpl fileInfo = new RemoteFileInfoImpl(url, this);
                file2 = new HttpVirtualFileImpl(RemoteFileManagerImpl.getHttpFileSystem(url), parent, path, fileInfo);
                fileInfo.addDownloadingListener(new MyDownloadingListener(file2));
            }
            cache2.put(url, file2);
        }
        return file2;
    }

    private static HttpFileSystemBase getHttpFileSystem(@NotNull Url url) {
        return "https".equals(url.getScheme()) ? HttpsFileSystem.getHttpsInstance() : HttpFileSystemImpl.getInstanceImpl();
    }

    @Override
    public void addRemoteContentProvider(final @NotNull RemoteContentProvider provider2, @NotNull Disposable parentDisposable) {
        this.addRemoteContentProvider(provider2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                RemoteFileManagerImpl.this.removeRemoteContentProvider(provider2);
            }
        });
    }

    @Override
    public void addRemoteContentProvider(@NotNull RemoteContentProvider provider2) {
        this.myProviders.add(provider2);
    }

    @Override
    public void removeRemoteContentProvider(@NotNull RemoteContentProvider provider2) {
        this.myProviders.remove(provider2);
    }

    @Override
    public void addFileListener(@NotNull HttpVirtualFileListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void addFileListener(@NotNull HttpVirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeFileListener(@NotNull HttpVirtualFileListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void fireFileDownloaded(@NotNull VirtualFile file2) {
        ((HttpVirtualFileListener)this.myDispatcher.getMulticaster()).fileDownloaded(file2);
    }

    public LocalFileStorage getStorage() {
        return this.myStorage;
    }

    public void dispose() {
        this.myStorage.deleteDownloadedFiles();
    }

    private class MyDownloadingListener
    extends FileDownloadingAdapter {
        private final HttpVirtualFileImpl myFile;

        public MyDownloadingListener(HttpVirtualFileImpl file2) {
            this.myFile = file2;
        }

        @Override
        public void fileDownloaded(VirtualFile localFile) {
            RemoteFileManagerImpl.this.fireFileDownloaded(this.myFile);
        }
    }
}

