/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarFileSystem
extends DeprecatedVirtualFileSystem {
    private final Map<String, CoreJarHandler> myHandlers = new ConcurrentFactoryMap<String, CoreJarHandler>(){

        @Nullable
        protected CoreJarHandler create(String key2) {
            return new CoreJarHandler(CoreJarFileSystem.this, key2);
        }
    };

    @NotNull
    public String getProtocol() {
        return "jar";
    }

    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        Couple<String> pair = this.splitPath(path);
        return this.myHandlers.get(pair.first).findFileByPath((String)pair.second);
    }

    @NotNull
    protected Couple<String> splitPath(@NotNull String path) {
        int separator = path.indexOf("!/");
        if (separator < 0) {
            throw new IllegalArgumentException("Path in JarFileSystem must contain a separator: " + path);
        }
        String localPath = path.substring(0, separator);
        String pathInJar = path.substring(separator + 2);
        return Couple.of((Object)localPath, (Object)pathInJar);
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    public void clearHandlersCache() {
        this.myHandlers.clear();
    }
}

