/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandler;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrtFileSystemImpl
extends JrtFileSystem {
    private final Map<String, ArchiveHandler> myHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private final AtomicBoolean mySubscribed = new AtomicBoolean(false);

    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        int p = path.indexOf("!/");
        return p > 0 ? FileUtil.normalize((String)path.substring(0, p)) + path.substring(p) : super.normalize(path);
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        return StringUtil.trimEnd((String)rootPath, (String)"!/");
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        return localPath + "!/";
    }

    @NotNull
    protected String extractRootPath(@NotNull String entryPath) {
        int separatorIndex = entryPath.indexOf("!/");
        assert (separatorIndex >= 0) : "Path passed to JrtFileSystem must have a separator '!/': " + entryPath;
        return entryPath.substring(0, separatorIndex + "!/".length());
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        this.checkSubscription();
        String homePath = this.extractLocalPath(this.extractRootPath(entryFile.getPath()));
        ArchiveHandler handler2 = this.myHandlers.get(homePath);
        if (handler2 == null) {
            handler2 = new JrtHandler(homePath);
            this.myHandlers.put(homePath, handler2);
            ApplicationManager.getApplication().invokeLater(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(homePath + "/release"), ModalityState.defaultModalityState());
        }
        return handler2;
    }

    private void checkSubscription() {
        if (this.mySubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                HashSet toRefresh = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !(vFileEvent instanceof VFileContentChangeEvent) || (file2 = vFileEvent.getFile()) == null || !"release".equals(file2.getName())) continue;
                    String homePath = file2.getParent().getPath();
                    ArchiveHandler handler2 = (ArchiveHandler)JrtFileSystemImpl.this.myHandlers.remove(homePath);
                    if (handler2 == null) continue;
                    handler2.dispose();
                    VirtualFile root = JrtFileSystemImpl.this.findFileByPath(JrtFileSystemImpl.this.composeRootPath(homePath));
                    if (root == null) continue;
                    ((NewVirtualFile)root).markDirtyRecursively();
                    if (toRefresh == null) {
                        toRefresh = ContainerUtil.newHashSet();
                    }
                    toRefresh.add(root);
                }
                if (toRefresh != null) {
                    boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                    RefreshQueue.getInstance().refresh(async, true, null, toRefresh);
                }
            }
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        return JrtFileSystemImpl.isModularJdk((String)FileUtil.toSystemDependentName((String)local.getPath()));
    }
}

