/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWatcher {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            return new NotificationGroup("File Watcher Messages", NotificationDisplayType.STICKY_BALLOON, true);
        }
    };
    private final ManagingFS myManagingFS;
    private final MyFileWatcherNotificationSink myNotificationSink;
    private final PluggableFileWatcher[] myWatchers;
    private final AtomicBoolean myFailureShown = new AtomicBoolean(false);
    private volatile CanonicalPathMap myPathMap = new CanonicalPathMap();
    private volatile List<Collection<String>> myManualWatchRoots = Collections.emptyList();
    private volatile Consumer<Boolean> myTestNotifier = null;

    FileWatcher(@NotNull ManagingFS managingFS) {
        this.myManagingFS = managingFS;
        this.myNotificationSink = new MyFileWatcherNotificationSink();
        for (PluggableFileWatcher watcher : this.myWatchers = (PluggableFileWatcher[])PluggableFileWatcher.EP_NAME.getExtensions()) {
            watcher.initialize(this.myManagingFS, (FileWatcherNotificationSink)this.myNotificationSink);
        }
    }

    public void dispose() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.dispose();
        }
    }

    public boolean isOperational() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (!watcher.isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean isSettingRoots() {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            if (!watcher.isSettingRoots()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DirtyPaths getDirtyPaths() {
        return this.myNotificationSink.getDirtyPaths();
    }

    @NotNull
    public Collection<String> getManualWatchRoots() {
        List<Collection<String>> manualWatchRoots = this.myManualWatchRoots;
        Collection<String> result2 = null;
        for (Collection<String> roots : manualWatchRoots) {
            if (result2 == null) {
                result2 = ContainerUtil.newHashSet(roots);
                continue;
            }
            result2.retainAll(roots);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        CanonicalPathMap pathMap;
        this.myPathMap = pathMap = new CanonicalPathMap(recursive, flat);
        this.myManualWatchRoots = ContainerUtil.createLockFreeCopyOnWriteList();
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.setWatchRoots(pathMap.getCanonicalRecursiveWatchRoots(), pathMap.getCanonicalFlatWatchRoots());
        }
    }

    public void notifyOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
        LOG.warn(cause);
        if (this.myFailureShown.compareAndSet(false, true)) {
            String title = ApplicationBundle.message((String)"watcher.slow.sync", (Object[])new Object[0]);
            ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification(title, cause, NotificationType.WARNING, listener2)), ModalityState.NON_MODAL);
        }
    }

    private void notifyOnAnyEvent() {
        Consumer<Boolean> notifier = this.myTestNotifier;
        if (notifier != null) {
            notifier.accept(Boolean.FALSE);
        }
    }

    private void notifyOnReset() {
        Consumer<Boolean> notifier = this.myTestNotifier;
        if (notifier != null) {
            notifier.accept(Boolean.TRUE);
        }
    }

    public void startup(@Nullable Consumer<Boolean> notifier) throws IOException {
        this.myTestNotifier = notifier;
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.startup();
        }
    }

    public void shutdown() throws InterruptedException {
        for (PluggableFileWatcher watcher : this.myWatchers) {
            watcher.shutdown();
        }
        this.myTestNotifier = null;
    }

    private class MyFileWatcherNotificationSink
    implements FileWatcherNotificationSink {
        private final Object myLock = new Object();
        private DirtyPaths myDirtyPaths = new DirtyPaths();

        private MyFileWatcherNotificationSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DirtyPaths getDirtyPaths() {
            DirtyPaths dirtyPaths = DirtyPaths.EMPTY;
            PluggableFileWatcher[] pluggableFileWatcherArray = this.myLock;
            synchronized (this.myLock) {
                if (!this.myDirtyPaths.isEmpty()) {
                    dirtyPaths = this.myDirtyPaths;
                    this.myDirtyPaths = new DirtyPaths();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                for (PluggableFileWatcher watcher : FileWatcher.this.myWatchers) {
                    watcher.resetChangedPaths();
                }
                return dirtyPaths;
            }
        }

        public void notifyManualWatchRoots(@NotNull Collection<String> roots) {
            FileWatcher.this.myManualWatchRoots.add(roots.isEmpty() ? Collections.emptySet() : ContainerUtil.newHashSet(roots));
            FileWatcher.this.notifyOnAnyEvent();
        }

        public void notifyMapping(@NotNull Collection<Pair<String, String>> mapping) {
            if (!mapping.isEmpty()) {
                FileWatcher.this.myPathMap.addMapping(mapping);
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPath(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.getWatchedPaths(path, true);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String eachPath : paths) {
                        this.myDirtyPaths.addDirtyPath(eachPath);
                    }
                }
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPathCreatedOrDeleted(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.getWatchedPaths(path, true);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String p : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(p);
                        String parentPath = new File(p).getParent();
                        if (parentPath == null) continue;
                        this.myDirtyPaths.addDirtyPath(parentPath);
                    }
                }
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyDirectory(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.getWatchedPaths(path, false);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.dirtyDirectories.addAll(paths);
                }
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPathRecursive(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.getWatchedPaths(path, false);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String each : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(each);
                    }
                }
            }
            FileWatcher.this.notifyOnAnyEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyReset(@Nullable String path) {
            if (path != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.addDirtyPathRecursive(path);
                }
            }
            VirtualFile[] roots = FileWatcher.this.myManagingFS.getLocalRoots();
            Object object = this.myLock;
            synchronized (object) {
                for (VirtualFile root : roots) {
                    this.myDirtyPaths.addDirtyPathRecursive(root.getPresentableUrl());
                }
            }
            FileWatcher.this.notifyOnReset();
        }

        public void notifyUserOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
            FileWatcher.this.notifyOnFailure(cause, listener2);
        }
    }

    public static class DirtyPaths {
        public final Set<String> dirtyPaths = ContainerUtil.newTroveSet();
        public final Set<String> dirtyPathsRecursive = ContainerUtil.newTroveSet();
        public final Set<String> dirtyDirectories = ContainerUtil.newTroveSet();
        public static final DirtyPaths EMPTY = new DirtyPaths();

        public boolean isEmpty() {
            return this.dirtyPaths.isEmpty() && this.dirtyPathsRecursive.isEmpty() && this.dirtyDirectories.isEmpty();
        }

        private void addDirtyPath(String path) {
            if (!this.dirtyPathsRecursive.contains(path)) {
                this.dirtyPaths.add(path);
            }
        }

        private void addDirtyPathRecursive(String path) {
            this.dirtyPaths.remove(path);
            this.dirtyPathsRecursive.add(path);
        }
    }
}

