/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.keyFMap.KeyFMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileImpl
extends VirtualFileSystemEntry {
    private static final Key<byte[]> ourPreloadedContentKey = Key.create((String)"preloaded.content.key");

    VirtualFileImpl(int id, VfsData.Segment segment, VirtualDirectoryImpl parent) {
        super(id, segment, parent);
    }

    @Nullable
    public NewVirtualFile findChild(@NotNull @NonNls String name) {
        return null;
    }

    @NotNull
    public Collection<VirtualFile> getCachedChildren() {
        return Collections.emptyList();
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        return ContainerUtil.emptyIterable();
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        VirtualDirectoryImpl parent = this.getParent();
        assert (parent != null);
        return parent.getFileSystem();
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        return null;
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public boolean isDirectory() {
        return false;
    }

    public void setPreloadedContentHint(byte[] preloadedContentHint) {
        this.putUserData(ourPreloadedContentKey, preloadedContentHint);
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        byte[] preloadedContent = (byte[])this.getUserData(ourPreloadedContentKey);
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)(preloadedContent == null ? ourPersistence.getInputStream((VirtualFile)this) : new DataInputStream((InputStream)new UnsyncByteArrayInputStream(preloadedContent))), (VirtualFile)this);
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        return this.contentsToByteArray(true);
    }

    @NotNull
    public byte[] contentsToByteArray(boolean cacheContent) throws IOException {
        this.checkNotTooLarge(null);
        byte[] preloadedContent = (byte[])this.getUserData(ourPreloadedContentKey);
        if (preloadedContent != null) {
            return preloadedContent;
        }
        return ourPersistence.contentsToByteArray((VirtualFile)this, cacheContent);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long modStamp, long timeStamp) throws IOException {
        this.checkNotTooLarge(requestor);
        return VfsUtilCore.outputStreamAddingBOM((OutputStream)ourPersistence.getOutputStream((VirtualFile)this, requestor, modStamp, timeStamp), (VirtualFile)this);
    }

    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long newTimeStamp, Object requestor) throws IOException {
        this.checkNotTooLarge(requestor);
        super.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
    }

    public void setBinaryContent(@NotNull byte[] content, long newModificationStamp, long newTimeStamp) throws IOException {
        this.checkNotTooLarge(null);
        super.setBinaryContent(content, newModificationStamp, newTimeStamp);
    }

    public String getDetectedLineSeparator() {
        if (this.getFlagInt(0x8000000)) {
            return LineSeparator.getSystemLineSeparator().getSeparatorString();
        }
        return super.getDetectedLineSeparator();
    }

    public void setDetectedLineSeparator(String separator) {
        boolean hasSystemSeparator = LineSeparator.getSystemLineSeparator().getSeparatorString().equals(separator);
        this.setFlagInt(0x8000000, hasSystemSeparator);
        super.setDetectedLineSeparator(hasSystemSeparator ? null : separator);
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        this.mySegment.setUserMap(this.myId, map2);
    }

    @NotNull
    protected KeyFMap getUserMap() {
        return this.mySegment.getUserMap(this, this.myId);
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.mySegment.changeUserMap(this.myId, oldMap, UserDataInterner.internUserData(newMap));
    }

    private void checkNotTooLarge(@Nullable Object requestor) throws FileTooBigException {
        if (!(requestor instanceof LargeFileWriteRequestor) && this.isTooLarge()) {
            throw new FileTooBigException(this.getPath());
        }
    }

    private boolean isTooLarge() {
        return FileUtilRt.isTooLarge((long)this.getLength());
    }
}

