/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentBTreeEnumerator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ContentHashesUtil {
    public static final ThreadLocalCachedValue<MessageDigest> HASHER_CACHE = new ThreadLocalCachedValue<MessageDigest>(){

        public MessageDigest create() {
            return ContentHashesUtil.createHashDigest();
        }

        protected void init(MessageDigest value2) {
            value2.reset();
        }
    };
    private static final int SIGNATURE_LENGTH = 20;

    @NotNull
    static MessageDigest createHashDigest() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException ex) {
            assert (false) : "Every Java implementation should have SHA1 support";
            return null;
        }
    }

    private static class ContentHashesDescriptor
    implements KeyDescriptor<byte[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private ContentHashesDescriptor() {
        }

        public void save(@NotNull DataOutput out, byte[] value2) throws IOException {
            out.write(value2);
        }

        public byte[] read(@NotNull DataInput in) throws IOException {
            byte[] b = new byte[20];
            in.readFully(b);
            return b;
        }

        public int getHashCode(byte[] value2) {
            int hash = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                hash = (hash << 8) + (value2[i2] & 0xFF);
            }
            return hash;
        }

        public boolean isEqual(byte[] val1, byte[] val2) {
            return Arrays.equals(val1, val2);
        }
    }

    public static class HashEnumerator
    extends PersistentBTreeEnumerator<byte[]> {
        private final ThreadLocal<Boolean> myProcessingKeyAtIndex = new ThreadLocal();

        public HashEnumerator(File contentsHashesFile, PagedFileStorage.StorageLockContext storageLockContext) throws IOException {
            super(contentsHashesFile, (KeyDescriptor)new ContentHashesDescriptor(), 65536, storageLockContext);
        }

        protected int doWriteData(byte[] value2) throws IOException {
            return super.doWriteData((Object)value2) / 20;
        }

        public int getLargestId() {
            return super.getLargestId() / 20;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isKeyAtIndex(byte[] value2, int idx) throws IOException {
            this.myProcessingKeyAtIndex.set(Boolean.TRUE);
            try {
                boolean bl = super.isKeyAtIndex((Object)value2, this.addrToIndex(this.indexToAddr(idx) * 20));
                return bl;
            }
            finally {
                this.myProcessingKeyAtIndex.set(null);
            }
        }

        public byte[] valueOf(int idx) throws IOException {
            if (this.myProcessingKeyAtIndex.get() == Boolean.TRUE) {
                return (byte[])super.valueOf(idx);
            }
            return (byte[])super.valueOf(this.addrToIndex(this.indexToAddr(idx) * 20));
        }
    }
}

