/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.persistent.CompactRecordsTable;
import com.intellij.openapi.vfs.newvfs.persistent.ContentHashesUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.io.storage.RefCountingStorage;
import com.intellij.util.io.storage.Storage;
import gnu.trove.TIntArrayList;
import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FSRecords {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.vfs.persistent.FSRecords");
    public static final boolean weHaveContentHashes = SystemProperties.getBooleanProperty((String)"idea.share.contents", (boolean)true);
    private static final boolean lazyVfsDataCleaning = SystemProperties.getBooleanProperty((String)"idea.lazy.vfs.data.cleaning", (boolean)true);
    static final boolean backgroundVfsFlush = SystemProperties.getBooleanProperty((String)"idea.background.vfs.flush", (boolean)true);
    public static final boolean persistentAttributesList = SystemProperties.getBooleanProperty((String)"idea.persistent.attr.list", (boolean)true);
    private static final boolean inlineAttributes = SystemProperties.getBooleanProperty((String)"idea.inline.vfs.attributes", (boolean)true);
    static final boolean bulkAttrReadSupport = SystemProperties.getBooleanProperty((String)"idea.bulk.attr.read", (boolean)false);
    static final boolean useSnappyForCompression = SystemProperties.getBooleanProperty((String)"idea.use.snappy.for.vfs", (boolean)false);
    private static final boolean useSmallAttrTable = SystemProperties.getBooleanProperty((String)"idea.use.small.attr.table.for.vfs", (boolean)true);
    static final String VFS_FILES_EXTENSION = System.getProperty("idea.vfs.files.extension", ".dat");
    private static final int VERSION = 21 + (weHaveContentHashes ? 16 : 0) + (IOUtil.ourByteBuffersUseNativeByteOrder ? 55 : 0) + (persistentAttributesList ? 31 : 0) + (bulkAttrReadSupport ? 39 : 0) + (inlineAttributes ? 49 : 0) + (useSnappyForCompression ? 127 : 0) + (useSmallAttrTable ? 49 : 0) + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 21 : 0);
    private static final int PARENT_OFFSET = 0;
    private static final int PARENT_SIZE = 4;
    private static final int NAME_OFFSET = 4;
    private static final int NAME_SIZE = 4;
    private static final int FLAGS_OFFSET = 8;
    private static final int FLAGS_SIZE = 4;
    private static final int ATTR_REF_OFFSET = 12;
    private static final int ATTR_REF_SIZE = 4;
    private static final int CONTENT_OFFSET = 16;
    private static final int CONTENT_SIZE = 4;
    private static final int TIMESTAMP_OFFSET = 20;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int MOD_COUNT_OFFSET = 28;
    private static final int MOD_COUNT_SIZE = 4;
    private static final int LENGTH_OFFSET = 32;
    private static final int LENGTH_SIZE = 8;
    private static final int RECORD_SIZE = 40;
    private static final byte[] ZEROES = new byte[40];
    private static final int HEADER_VERSION_OFFSET = 0;
    private static final int HEADER_GLOBAL_MOD_COUNT_OFFSET = 8;
    private static final int HEADER_CONNECTION_STATUS_OFFSET = 12;
    private static final int HEADER_TIMESTAMP_OFFSET = 16;
    private static final int HEADER_SIZE = 24;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private static final int CORRUPTED_MAGIC = -1412464769;
    private static final FileAttribute ourChildrenAttr = new FileAttribute("FsRecords.DIRECTORY_CHILDREN");
    private static final ReentrantReadWriteLock.ReadLock r;
    private static final ReentrantReadWriteLock.WriteLock w;
    private static volatile int ourLocalModificationCount;
    private static volatile boolean ourIsDisposed;
    private static final int FREE_RECORD_FLAG = 256;
    private static final int ALL_VALID_FLAGS = 383;
    private static final int MAX_SMALL_ATTR_SIZE = 64;
    private static final MessageDigest myDigest;
    private static final boolean DO_HARD_CONSISTENCY_CHECK = false;
    private static final boolean DUMP_STATISTICS;
    private static long totalContents;
    private static long totalReuses;
    private static long time;
    private static int contents;
    private static int reuses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeAttributesToRecord(int id, int parentId, @NotNull FileAttributes attributes, @NotNull String name) {
        w.lock();
        try {
            FSRecords.setName(id, name);
            FSRecords.setTimestamp(id, attributes.lastModified);
            FSRecords.setLength(id, attributes.isDirectory() ? -1L : attributes.length);
            FSRecords.setFlags(id, (attributes.isDirectory() ? 2 : 0) | (attributes.isWritable() ? 0 : 4) | (attributes.isSymLink() ? 16 : 0) | (attributes.isSpecial() ? 32 : 0) | (attributes.isHidden() ? 64 : 0), true);
            FSRecords.setParent(id, parentId);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    static void requestVfsRebuild(Throwable e) {
        DbConnection.handleError(e);
    }

    static File basePath() {
        return new File(DbConnection.getCachesDir());
    }

    private FSRecords() {
    }

    public static void connect() {
        DbConnection.connect();
    }

    public static long getCreationTimestamp() {
        r.lock();
        try {
            long l = DbConnection.getTimestamp();
            return l;
        }
        finally {
            r.unlock();
        }
    }

    private static ResizeableMappedFile getRecords() {
        return DbConnection.myRecords;
    }

    private static PersistentBTreeEnumerator<byte[]> getContentHashesEnumerator() {
        return DbConnection.myContentHashesEnumerator;
    }

    private static RefCountingStorage getContentStorage() {
        return DbConnection.myContents;
    }

    private static Storage getAttributesStorage() {
        return DbConnection.myAttributes;
    }

    public static PersistentStringEnumerator getNames() {
        return DbConnection.getNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createRecord() {
        w.lock();
        try {
            DbConnection.markDirty();
            int free = DbConnection.getFreeRecord();
            if (free == 0) {
                int fileLength = FSRecords.length();
                LOG.assertTrue(fileLength % 40 == 0);
                int newRecord = fileLength / 40;
                DbConnection.cleanRecord(newRecord);
                assert (fileLength + 40 == FSRecords.length());
                int n = newRecord;
                return n;
            }
            if (lazyVfsDataCleaning) {
                FSRecords.deleteContentAndAttributes(free);
            }
            DbConnection.cleanRecord(free);
            int n = free;
            return n;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
        return -1;
    }

    private static int length() {
        return (int)FSRecords.getRecords().length();
    }

    public static int getMaxId() {
        r.lock();
        try {
            int n = FSRecords.length() / 40;
            return n;
        }
        finally {
            r.unlock();
        }
    }

    static void deleteRecordRecursively(int id) {
        w.lock();
        try {
            FSRecords.incModCount(id);
            if (lazyVfsDataCleaning) {
                FSRecords.markAsDeletedRecursively(id);
            } else {
                FSRecords.doDeleteRecursively(id);
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    private static void markAsDeletedRecursively(int id) {
        for (int subrecord : FSRecords.list(id)) {
            FSRecords.markAsDeletedRecursively(subrecord);
        }
        FSRecords.markAsDeleted(id);
    }

    private static void markAsDeleted(int id) {
        w.lock();
        try {
            DbConnection.markDirty();
            FSRecords.addToFreeRecordsList(id);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    private static void doDeleteRecursively(int id) {
        for (int subrecord : FSRecords.list(id)) {
            FSRecords.doDeleteRecursively(subrecord);
        }
        FSRecords.deleteRecord(id);
    }

    private static void deleteRecord(int id) {
        w.lock();
        try {
            DbConnection.markDirty();
            FSRecords.deleteContentAndAttributes(id);
            DbConnection.cleanRecord(id);
            FSRecords.addToFreeRecordsList(id);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    private static void deleteContentAndAttributes(int id) throws IOException {
        int att_page;
        int content_page = FSRecords.getContentRecordId(id);
        if (content_page != 0) {
            if (weHaveContentHashes) {
                FSRecords.getContentStorage().releaseRecord(content_page, false);
            } else {
                FSRecords.getContentStorage().releaseRecord(content_page);
            }
        }
        if ((att_page = FSRecords.getAttributeRecordId(id)) != 0) {
            DataInputStream attStream = FSRecords.getAttributesStorage().readStream(att_page);
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(attStream, DbConnection.RESERVED_ATTR_ID, id);
            }
            while (attStream.available() > 0) {
                DataInputOutputUtil.readINT((DataInput)attStream);
                int attAddressOrSize = DataInputOutputUtil.readINT((DataInput)attStream);
                if (inlineAttributes) {
                    if (attAddressOrSize < 64) {
                        attStream.skipBytes(attAddressOrSize);
                        continue;
                    }
                    attAddressOrSize -= 64;
                }
                FSRecords.getAttributesStorage().deleteRecord(attAddressOrSize);
            }
            attStream.close();
            FSRecords.getAttributesStorage().deleteRecord(att_page);
        }
    }

    private static void addToFreeRecordsList(int id) {
        FSRecords.setFlags(id, 256, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    static int[] listRoots() {
        try {
            r.lock();
            try {
                int[] nArray;
                DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);
                if (input == null) {
                    int[] nArray2 = ArrayUtil.EMPTY_INT_ARRAY;
                    return nArray2;
                }
                try {
                    int count = DataInputOutputUtil.readINT((DataInput)input);
                    int[] result2 = ArrayUtil.newIntArray((int)count);
                    int prevId = 0;
                    for (int i = 0; i < count; ++i) {
                        DataInputOutputUtil.readINT((DataInput)input);
                        prevId = result2[i] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                    }
                    nArray = result2;
                }
                catch (Throwable throwable) {
                    input.close();
                    throw throwable;
                }
                input.close();
                return nArray;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return null;
        }
    }

    public static void force() {
        DbConnection.force();
    }

    public static boolean isDirty() {
        return DbConnection.isDirty();
    }

    private static void saveNameIdSequenceWithDeltas(int[] names, int[] ids, DataOutputStream output) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)output, (int)names.length);
        int prevId = 0;
        int prevNameId = 0;
        for (int i = 0; i < names.length; ++i) {
            DataInputOutputUtil.writeINT((DataOutput)output, (int)(names[i] - prevNameId));
            DataInputOutputUtil.writeINT((DataOutput)output, (int)(ids[i] - prevId));
            prevId = ids[i];
            prevNameId = names[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int findRootRecord(@NotNull String rootUrl) {
        w.lock();
        try {
            int id;
            DbConnection.markDirty();
            int root = FSRecords.getNames().enumerate(rootUrl);
            DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);
            int[] names = ArrayUtil.EMPTY_INT_ARRAY;
            int[] ids = ArrayUtil.EMPTY_INT_ARRAY;
            if (input != null) {
                try {
                    int count = DataInputOutputUtil.readINT((DataInput)input);
                    names = ArrayUtil.newIntArray((int)count);
                    ids = ArrayUtil.newIntArray((int)count);
                    int prevId = 0;
                    int prevNameId = 0;
                    for (int i = 0; i < count; ++i) {
                        int name = DataInputOutputUtil.readINT((DataInput)input) + prevNameId;
                        int id2 = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                        if (name == root) {
                            int n = id2;
                            return n;
                        }
                        prevNameId = names[i] = name;
                        prevId = ids[i] = id2;
                    }
                }
                finally {
                    input.close();
                }
            }
            try (DataOutputStream output = FSRecords.writeAttribute(1, ourChildrenAttr);){
                id = FSRecords.createRecord();
                int index = Arrays.binarySearch(ids, id);
                ids = ArrayUtil.insert((int[])ids, (int)(-index - 1), (int)id);
                names = ArrayUtil.insert((int[])names, (int)(-index - 1), (int)root);
                FSRecords.saveNameIdSequenceWithDeltas(names, ids, output);
            }
            int n = id;
            return n;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteRootRecord(int id) {
        w.lock();
        try {
            int[] ids;
            int[] names;
            DbConnection.markDirty();
            DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);
            assert (input != null);
            try {
                int count = DataInputOutputUtil.readINT((DataInput)input);
                names = ArrayUtil.newIntArray((int)count);
                ids = ArrayUtil.newIntArray((int)count);
                int prevId = 0;
                int prevNameId = 0;
                for (int i = 0; i < count; ++i) {
                    names[i] = DataInputOutputUtil.readINT((DataInput)input) + prevNameId;
                    ids[i] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                    prevId = ids[i];
                    prevNameId = names[i];
                }
            }
            finally {
                input.close();
            }
            int index = ArrayUtil.find((int[])ids, (int)id);
            assert (index >= 0);
            names = ArrayUtil.remove((int[])names, (int)index);
            ids = ArrayUtil.remove((int[])ids, (int)index);
            try (DataOutputStream output = FSRecords.writeAttribute(1, ourChildrenAttr);){
                FSRecords.saveNameIdSequenceWithDeltas(names, ids, output);
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static int[] list(int id) {
        try {
            r.lock();
            try {
                DataInputStream input = FSRecords.readAttribute(id, ourChildrenAttr);
                if (input == null) {
                    int[] nArray = ArrayUtil.EMPTY_INT_ARRAY;
                    return nArray;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                int[] result2 = ArrayUtil.newIntArray((int)count);
                int prevId = id;
                for (int i = 0; i < count; ++i) {
                    prevId = result2[i] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                }
                input.close();
                int[] nArray = result2;
                return nArray;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static NameId[] listAll(int parentId) {
        try {
            r.lock();
            try {
                DataInputStream input = FSRecords.readAttribute(parentId, ourChildrenAttr);
                if (input == null) {
                    NameId[] nameIdArray = NameId.EMPTY_ARRAY;
                    return nameIdArray;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                NameId[] result2 = count == 0 ? NameId.EMPTY_ARRAY : new NameId[count];
                int prevId = parentId;
                for (int i = 0; i < count; ++i) {
                    int id;
                    prevId = id = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                    int nameId = FSRecords.getNameId(id);
                    result2[i] = new NameId(id, nameId, FileNameCache.getVFileName(nameId));
                }
                input.close();
                NameId[] nameIdArray = result2;
                return nameIdArray;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return NameId.EMPTY_ARRAY;
        }
    }

    static boolean wereChildrenAccessed(int id) {
        r.lock();
        try {
            boolean bl = FSRecords.findAttributePage(id, ourChildrenAttr, false) != 0;
            r.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                r.unlock();
                throw throwable;
            }
            catch (Throwable e) {
                DbConnection.handleError(e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateList(int id, @NotNull int[] childIds) {
        Arrays.sort(childIds);
        w.lock();
        try {
            DbConnection.markDirty();
            try (DataOutputStream record = FSRecords.writeAttribute(id, ourChildrenAttr);){
                DataInputOutputUtil.writeINT((DataOutput)record, (int)childIds.length);
                int prevId = id;
                for (int childId : childIds) {
                    assert (childId > 0) : childId;
                    if (childId == id) {
                        LOG.error("Cyclic parent child relations");
                        continue;
                    }
                    int delta = childId - prevId;
                    DataInputOutputUtil.writeINT((DataOutput)record, (int)delta);
                    prevId = childId;
                }
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    private static void incModCount(int id) {
        FSRecords.incLocalModCount();
        int count = FSRecords.getModCount() + 1;
        FSRecords.getRecords().putInt(8L, count);
        FSRecords.setModCount(id, count);
    }

    private static void incLocalModCount() {
        DbConnection.markDirty();
        ++ourLocalModificationCount;
    }

    static int getLocalModCount() {
        return ourLocalModificationCount;
    }

    public static int getModCount() {
        r.lock();
        try {
            int n = FSRecords.getRecords().getInt(8L);
            return n;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getParent(int id) {
        try {
            r.lock();
            try {
                int parentId = FSRecords.getRecordInt(id, 0);
                if (parentId == id) {
                    LOG.error("Cyclic parent child relations in the database. id = " + id);
                    int n = 0;
                    return n;
                }
                int n = parentId;
                return n;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static TIntArrayList getParents(int id, @NotNull ConcurrentIntObjectMap<?> idCache) {
        TIntArrayList result2 = new TIntArrayList(10);
        r.lock();
        try {
            int parentId;
            do {
                result2.add(id);
                if (idCache.containsKey(id)) {
                    break;
                }
                parentId = FSRecords.getRecordInt(id, 0);
                if (parentId == id || result2.size() % 128 == 0 && result2.contains(parentId)) {
                    LOG.error("Cyclic parent child relations in the database. id = " + parentId);
                    TIntArrayList tIntArrayList = result2;
                    return tIntArrayList;
                }
                id = parentId;
            } while (parentId != 0);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            r.unlock();
        }
        return result2;
    }

    public static void setParent(int id, int parentId) {
        if (id == parentId) {
            LOG.error("Cyclic parent/child relations");
            return;
        }
        w.lock();
        try {
            FSRecords.incModCount(id);
            FSRecords.putRecordInt(id, 0, parentId);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    public static int getNameId(int id) {
        r.lock();
        try {
            int n = FSRecords.getRecordInt(id, 4);
            r.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                r.unlock();
                throw throwable;
            }
            catch (Throwable e) {
                DbConnection.handleError(e);
                return -1;
            }
        }
    }

    public static int getNameId(String name) {
        r.lock();
        try {
            int n = FSRecords.getNames().enumerate(name);
            r.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                r.unlock();
                throw throwable;
            }
            catch (Throwable e) {
                DbConnection.handleError(e);
                return -1;
            }
        }
    }

    public static String getName(int id) {
        return FSRecords.getNameSequence(id).toString();
    }

    @NotNull
    public static CharSequence getNameSequence(int id) {
        r.lock();
        try {
            int nameId = FSRecords.getRecordInt(id, 4);
            CharSequence charSequence = nameId == 0 ? "" : FileNameCache.getVFileName(nameId);
            r.unlock();
            return charSequence;
        }
        catch (Throwable throwable) {
            try {
                r.unlock();
                throw throwable;
            }
            catch (Throwable e) {
                DbConnection.handleError(e);
                return "";
            }
        }
    }

    public static String getNameByNameId(int nameId) {
        r.lock();
        try {
            String string = nameId != 0 ? FSRecords.getNames().valueOf(nameId) : "";
            r.unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                r.unlock();
                throw throwable;
            }
            catch (Throwable e) {
                DbConnection.handleError(e);
                return null;
            }
        }
    }

    public static void setName(int id, @NotNull String name) {
        w.lock();
        try {
            FSRecords.incModCount(id);
            int nameId = FSRecords.getNames().enumerate(name);
            FSRecords.putRecordInt(id, 4, nameId);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    public static int getFlags(int id) {
        r.lock();
        try {
            int n = FSRecords.getRecordInt(id, 8);
            return n;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFlags(int id, int flags, boolean markAsChange) {
        w.lock();
        try {
            if (markAsChange) {
                FSRecords.incModCount(id);
            }
            FSRecords.putRecordInt(id, 8, flags);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    public static long getLength(int id) {
        r.lock();
        try {
            long l = FSRecords.getRecords().getLong((long)FSRecords.getOffset(id, 32));
            return l;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLength(int id, long len) {
        w.lock();
        try {
            ResizeableMappedFile records = FSRecords.getRecords();
            int lengthOffset = FSRecords.getOffset(id, 32);
            if (records.getLong((long)lengthOffset) != len) {
                FSRecords.incModCount(id);
                records.putLong((long)lengthOffset, len);
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    public static long getTimestamp(int id) {
        r.lock();
        try {
            long l = FSRecords.getRecords().getLong((long)FSRecords.getOffset(id, 20));
            return l;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimestamp(int id, long value2) {
        w.lock();
        try {
            int timeStampOffset = FSRecords.getOffset(id, 20);
            ResizeableMappedFile records = FSRecords.getRecords();
            if (records.getLong((long)timeStampOffset) != value2) {
                FSRecords.incModCount(id);
                records.putLong((long)timeStampOffset, value2);
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    static int getModCount(int id) {
        r.lock();
        try {
            int n = FSRecords.getRecordInt(id, 28);
            return n;
        }
        finally {
            r.unlock();
        }
    }

    private static void setModCount(int id, int value2) {
        FSRecords.putRecordInt(id, 28, value2);
    }

    private static int getContentRecordId(int fileId) {
        return FSRecords.getRecordInt(fileId, 16);
    }

    private static void setContentRecordId(int id, int value2) {
        FSRecords.putRecordInt(id, 16, value2);
    }

    private static int getAttributeRecordId(int id) {
        return FSRecords.getRecordInt(id, 12);
    }

    private static void setAttributeRecordId(int id, int value2) {
        FSRecords.putRecordInt(id, 12, value2);
    }

    private static int getRecordInt(int id, int offset) {
        return FSRecords.getRecords().getInt((long)FSRecords.getOffset(id, offset));
    }

    private static void putRecordInt(int id, int offset, int value2) {
        FSRecords.getRecords().putInt((long)FSRecords.getOffset(id, offset), value2);
    }

    private static int getOffset(int id, int offset) {
        return id * 40 + offset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static DataInputStream readContent(int fileId) {
        try {
            r.lock();
            try {
                FSRecords.checkFileIsValid(fileId);
                int page = FSRecords.getContentRecordId(fileId);
                if (page != 0) return FSRecords.doReadContentById(page);
                DataInputStream dataInputStream = null;
                return dataInputStream;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return null;
        }
    }

    @Nullable
    static DataInputStream readContentById(int contentId) {
        try {
            return FSRecords.doReadContentById(contentId);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return null;
        }
    }

    private static DataInputStream doReadContentById(int contentId) throws IOException {
        DataInputStream stream = FSRecords.getContentStorage().readStream(contentId);
        if (useSnappyForCompression) {
            byte[] bytes = CompressionUtil.readCompressed((DataInput)stream);
            stream = new DataInputStream(new ByteArrayInputStream(bytes));
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static DataInputStream readAttributeWithLock(int fileId, FileAttribute att) {
        try {
            r.lock();
            try {
                DataInputStream stream = FSRecords.readAttribute(fileId, att);
                if (stream != null && att.isVersioned()) {
                    try {
                        int actualVersion = DataInputOutputUtil.readINT((DataInput)stream);
                        if (actualVersion != att.getVersion()) {
                            stream.close();
                            DataInputStream dataInputStream = null;
                            return dataInputStream;
                        }
                    }
                    catch (IOException e) {
                        stream.close();
                        DataInputStream dataInputStream = null;
                        return dataInputStream;
                    }
                }
                DataInputStream dataInputStream = stream;
                return dataInputStream;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return null;
        }
    }

    @Nullable
    private static DataInputStream readAttribute(int fileId, FileAttribute attribute) throws IOException {
        FSRecords.checkFileIsValid(fileId);
        int recordId = FSRecords.getAttributeRecordId(fileId);
        if (recordId == 0) {
            return null;
        }
        int encodedAttrId = DbConnection.getAttributeId(attribute.getId());
        Storage storage2 = FSRecords.getAttributesStorage();
        int page = 0;
        try (DataInputStream attrRefs = storage2.readStream(recordId);){
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(attrRefs, DbConnection.RESERVED_ATTR_ID, fileId);
            }
            while (attrRefs.available() > 0) {
                int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                if (attIdOnPage != encodedAttrId) {
                    if (!inlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                    continue;
                }
                if (inlineAttributes && attrAddressOrSize < 64) {
                    byte[] b = new byte[attrAddressOrSize];
                    attrRefs.readFully(b);
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(b));
                    return dataInputStream;
                }
                page = inlineAttributes ? attrAddressOrSize - 64 : attrAddressOrSize;
                break;
            }
        }
        if (page == 0) {
            return null;
        }
        DataInputStream stream = FSRecords.getAttributesStorage().readStream(page);
        if (bulkAttrReadSupport) {
            FSRecords.skipRecordHeader(stream, encodedAttrId, fileId);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findAttributePage(int fileId, FileAttribute attr, boolean toWrite) throws IOException {
        FSRecords.checkFileIsValid(fileId);
        int recordId = FSRecords.getAttributeRecordId(fileId);
        int encodedAttrId = DbConnection.getAttributeId(attr.getId());
        boolean directoryRecord = false;
        Storage storage2 = FSRecords.getAttributesStorage();
        if (recordId == 0) {
            if (!toWrite) {
                return 0;
            }
            recordId = storage2.createNewRecord();
            FSRecords.setAttributeRecordId(fileId, recordId);
            directoryRecord = true;
        } else {
            try (DataInputStream attrRefs = storage2.readStream(recordId);){
                if (bulkAttrReadSupport) {
                    FSRecords.skipRecordHeader(attrRefs, DbConnection.RESERVED_ATTR_ID, fileId);
                }
                while (attrRefs.available() > 0) {
                    int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                    int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                    if (attIdOnPage == encodedAttrId) {
                        if (inlineAttributes) {
                            int n = attrAddressOrSize < 64 ? -recordId : attrAddressOrSize - 64;
                            return n;
                        }
                        int n = attrAddressOrSize;
                        return n;
                    }
                    if (!inlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                }
            }
        }
        if (toWrite) {
            AbstractStorage.AppenderStream appender = storage2.appendStream(recordId);
            if (bulkAttrReadSupport && directoryRecord) {
                DataInputOutputUtil.writeINT((DataOutput)appender, (int)DbConnection.RESERVED_ATTR_ID);
                DataInputOutputUtil.writeINT((DataOutput)appender, (int)fileId);
            }
            DataInputOutputUtil.writeINT((DataOutput)appender, (int)encodedAttrId);
            int attrAddress = storage2.createNewRecord();
            DataInputOutputUtil.writeINT((DataOutput)appender, (int)(inlineAttributes ? attrAddress + 64 : attrAddress));
            DbConnection.REASONABLY_SMALL.myAttrPageRequested = true;
            try {
                appender.close();
            }
            finally {
                DbConnection.REASONABLY_SMALL.myAttrPageRequested = false;
            }
            return attrAddress;
        }
        return 0;
    }

    private static void skipRecordHeader(DataInputStream refs, int expectedRecordTag, int expectedFileId) throws IOException {
        int attId = DataInputOutputUtil.readINT((DataInput)refs);
        assert (attId == expectedRecordTag || expectedRecordTag == 0);
        int fileId = DataInputOutputUtil.readINT((DataInput)refs);
        assert (expectedFileId == fileId || expectedFileId == 0);
    }

    private static void writeRecordHeader(int recordTag, int fileId, DataOutputStream appender) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)appender, (int)recordTag);
        DataInputOutputUtil.writeINT((DataOutput)appender, (int)fileId);
    }

    private static void checkFileIsValid(int fileId) {
        assert (fileId > 0) : fileId;
        if (!lazyVfsDataCleaning) assert (!BitUtil.isSet((int)FSRecords.getFlags(fileId), (int)256)) : "Accessing attribute of a deleted page: " + fileId + ":" + FSRecords.getName(fileId);
    }

    static int acquireFileContent(int fileId) {
        w.lock();
        try {
            int record = FSRecords.getContentRecordId(fileId);
            if (record > 0) {
                FSRecords.getContentStorage().acquireRecord(record);
            }
            int n = record;
            return n;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
        return -1;
    }

    static void releaseContent(int contentId) {
        w.lock();
        try {
            RefCountingStorage contentStorage = FSRecords.getContentStorage();
            if (weHaveContentHashes) {
                contentStorage.releaseRecord(contentId, false);
            } else {
                contentStorage.releaseRecord(contentId);
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
    }

    public static int getContentId(int fileId) {
        r.lock();
        try {
            int n = FSRecords.getContentRecordId(fileId);
            r.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                r.unlock();
                throw throwable;
            }
            catch (Throwable e) {
                DbConnection.handleError(e);
                return -1;
            }
        }
    }

    @NotNull
    static DataOutputStream writeContent(int fileId, boolean readOnly) {
        return new ContentOutputStream(fileId, readOnly);
    }

    static void writeContent(int fileId, ByteSequence bytes, boolean readOnly) {
        try {
            new ContentOutputStream(fileId, readOnly).writeBytes(bytes);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int storeUnlinkedContent(byte[] bytes) {
        w.lock();
        try {
            int recordId;
            if (weHaveContentHashes) {
                recordId = FSRecords.findOrCreateContentRecord(bytes, 0, bytes.length);
                if (recordId > 0) {
                    int n = recordId;
                    return n;
                }
                recordId = -recordId;
            } else {
                recordId = FSRecords.getContentStorage().acquireNewRecord();
            }
            AbstractStorage.StorageDataOutput output = FSRecords.getContentStorage().writeStream(recordId, true);
            output.write(bytes);
            output.close();
            int n = recordId;
            return n;
        }
        catch (IOException e) {
            DbConnection.handleError(e);
        }
        finally {
            w.unlock();
        }
        return -1;
    }

    @NotNull
    public static DataOutputStream writeAttribute(int fileId, @NotNull FileAttribute att) {
        AttributeOutputStream stream = new AttributeOutputStream(fileId, att);
        if (att.isVersioned()) {
            try {
                DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)att.getVersion());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return stream;
    }

    private static int findOrCreateContentRecord(byte[] bytes, int offset, int length) throws IOException {
        assert (weHaveContentHashes);
        long started = DUMP_STATISTICS ? System.nanoTime() : 0L;
        myDigest.reset();
        myDigest.update(String.valueOf(length - offset).getBytes(Charset.defaultCharset()));
        myDigest.update("\u0000".getBytes(Charset.defaultCharset()));
        myDigest.update(bytes, offset, length);
        byte[] digest = myDigest.digest();
        long done2 = DUMP_STATISTICS ? System.nanoTime() - started : 0L;
        time += done2;
        totalContents += (long)length;
        if (DUMP_STATISTICS && (++contents & 0x3FFF) == 0) {
            LOG.info("Contents:" + contents + " of " + totalContents + ", reuses:" + reuses + " of " + totalReuses + " for " + time / 1000000L);
        }
        PersistentBTreeEnumerator<byte[]> hashesEnumerator = FSRecords.getContentHashesEnumerator();
        int largestId = hashesEnumerator.getLargestId();
        int page = hashesEnumerator.enumerate((Object)digest);
        if (page <= largestId) {
            ++reuses;
            FSRecords.getContentStorage().acquireRecord(page);
            totalReuses += (long)length;
            return page;
        }
        int newRecord = FSRecords.getContentStorage().acquireNewRecord();
        if (page != newRecord) assert (false) : "Unexpected content storage modification";
        return -page;
    }

    public static void dispose() {
        w.lock();
        try {
            DbConnection.force();
            DbConnection.closeFiles();
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
        }
        finally {
            ourIsDisposed = true;
            w.unlock();
        }
    }

    public static void invalidateCaches() {
        DbConnection.createBrokenMarkerFile(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkSanity() {
        long t = System.currentTimeMillis();
        r.lock();
        try {
            int fileLength = FSRecords.length();
            assert (fileLength % 40 == 0);
            int recordCount = fileLength / 40;
            IntArrayList usedAttributeRecordIds = new IntArrayList();
            IntArrayList validAttributeIds = new IntArrayList();
            for (int id = 2; id < recordCount; ++id) {
                int flags = FSRecords.getFlags(id);
                LOG.assertTrue((flags & 0xFFFFFE80) == 0, (Object)("Invalid flags: 0x" + Integer.toHexString(flags) + ", id: " + id));
                if (BitUtil.isSet((int)flags, (int)256)) {
                    LOG.assertTrue(DbConnection.myFreeRecords.contains(id), (Object)("Record, marked free, not in free list: " + id));
                    continue;
                }
                LOG.assertTrue(!DbConnection.myFreeRecords.contains(id), (Object)("Record, not marked free, in free list: " + id));
                FSRecords.checkRecordSanity(id, recordCount, usedAttributeRecordIds, validAttributeIds);
            }
        }
        finally {
            r.unlock();
        }
        t = System.currentTimeMillis() - t;
        LOG.info("Sanity check took " + t + " ms");
    }

    private static void checkRecordSanity(int id, int recordCount, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) {
        int parentId = FSRecords.getParent(id);
        assert (parentId >= 0 && parentId < recordCount);
        if (parentId > 0 && FSRecords.getParent(parentId) > 0) {
            int parentFlags = FSRecords.getFlags(parentId);
            assert (!BitUtil.isSet((int)parentFlags, (int)256)) : parentId + ": " + Integer.toHexString(parentFlags);
            assert (BitUtil.isSet((int)parentFlags, (int)2)) : parentId + ": " + Integer.toHexString(parentFlags);
        }
        String name = FSRecords.getName(id);
        LOG.assertTrue(parentId == 0 || !name.isEmpty(), (Object)("File with empty name found under " + FSRecords.getName(parentId) + ", id=" + id));
        FSRecords.checkContentsStorageSanity(id);
        FSRecords.checkAttributesStorageSanity(id, usedAttributeRecordIds, validAttributeIds);
        long length = FSRecords.getLength(id);
        assert (length >= -1L) : "Invalid file length found for " + name + ": " + length;
    }

    private static void checkContentsStorageSanity(int id) {
        int recordId = FSRecords.getContentRecordId(id);
        assert (recordId >= 0);
        if (recordId > 0) {
            FSRecords.getContentStorage().checkSanity(recordId);
        }
    }

    private static void checkAttributesStorageSanity(int id, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) {
        int attributeRecordId = FSRecords.getAttributeRecordId(id);
        assert (attributeRecordId >= 0);
        if (attributeRecordId > 0) {
            try {
                FSRecords.checkAttributesSanity(attributeRecordId, usedAttributeRecordIds, validAttributeIds);
            }
            catch (IOException ex) {
                DbConnection.handleError(ex);
            }
        }
    }

    private static void checkAttributesSanity(int attributeRecordId, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) throws IOException {
        assert (!usedAttributeRecordIds.contains(attributeRecordId));
        usedAttributeRecordIds.add(attributeRecordId);
        try (DataInputStream dataInputStream = FSRecords.getAttributesStorage().readStream(attributeRecordId);){
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(dataInputStream, 0, 0);
            }
            while (dataInputStream.available() > 0) {
                int attId = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (!validAttributeIds.contains(attId)) {
                    assert (persistentAttributesList || !FSRecords.getNames().valueOf(attId).isEmpty());
                    validAttributeIds.add(attId);
                }
                int attDataRecordIdOrSize = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (inlineAttributes) {
                    if (attDataRecordIdOrSize < 64) {
                        dataInputStream.skipBytes(attDataRecordIdOrSize);
                        continue;
                    }
                    attDataRecordIdOrSize -= 64;
                }
                assert (!usedAttributeRecordIds.contains(attDataRecordIdOrSize));
                usedAttributeRecordIds.add(attDataRecordIdOrSize);
                FSRecords.getAttributesStorage().checkSanity(attDataRecordIdOrSize);
            }
        }
    }

    public static void handleError(Throwable e) throws RuntimeException, Error {
        DbConnection.handleError(e);
    }

    static {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        r = lock.readLock();
        w = lock.writeLock();
        myDigest = ContentHashesUtil.createHashDigest();
        DUMP_STATISTICS = weHaveContentHashes;
    }

    private static class AttributeOutputStream
    extends DataOutputStream {
        private final FileAttribute myAttribute;
        private final int myFileId;

        private AttributeOutputStream(int fileId, @NotNull FileAttribute attribute) {
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myAttribute = attribute;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            block12: {
                super.close();
                try {
                    BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
                    if (inlineAttributes && _out.size() < 64) {
                        w.lock();
                        try {
                            this.rewriteDirectoryRecordWithAttrContent(_out);
                            FSRecords.incLocalModCount();
                            break block12;
                        }
                        finally {
                            w.unlock();
                        }
                    }
                    w.lock();
                    try {
                        FSRecords.incLocalModCount();
                        int page = FSRecords.findAttributePage(this.myFileId, this.myAttribute, true);
                        if (inlineAttributes && page < 0) {
                            this.rewriteDirectoryRecordWithAttrContent(new BufferExposingByteArrayOutputStream());
                            page = FSRecords.findAttributePage(this.myFileId, this.myAttribute, true);
                        }
                        if (bulkAttrReadSupport) {
                            BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
                            this.out = stream;
                            FSRecords.writeRecordHeader(DbConnection.getAttributeId(this.myAttribute.getId()), this.myFileId, this);
                            this.write(_out.getInternalBuffer(), 0, _out.size());
                            FSRecords.getAttributesStorage().writeBytes(page, new ByteSequence(stream.getInternalBuffer(), 0, stream.size()), this.myAttribute.isFixedSize());
                        } else {
                            FSRecords.getAttributesStorage().writeBytes(page, new ByteSequence(_out.getInternalBuffer(), 0, _out.size()), this.myAttribute.isFixedSize());
                        }
                    }
                    finally {
                        w.unlock();
                    }
                }
                catch (Throwable e) {
                    DbConnection.handleError(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rewriteDirectoryRecordWithAttrContent(BufferExposingByteArrayOutputStream _out) throws IOException {
            int recordId = FSRecords.getAttributeRecordId(this.myFileId);
            assert (inlineAttributes);
            int encodedAttrId = DbConnection.getAttributeId(this.myAttribute.getId());
            Storage storage2 = FSRecords.getAttributesStorage();
            BufferExposingByteArrayOutputStream unchangedPreviousDirectoryStream = null;
            boolean directoryRecord = false;
            if (recordId == 0) {
                recordId = storage2.createNewRecord();
                FSRecords.setAttributeRecordId(this.myFileId, recordId);
                directoryRecord = true;
            } else {
                DataInputStream attrRefs = storage2.readStream(recordId);
                DataOutputStream dataStream = null;
                try {
                    int remainingAtStart = attrRefs.available();
                    if (bulkAttrReadSupport) {
                        unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                        dataStream = new DataOutputStream((OutputStream)unchangedPreviousDirectoryStream);
                        int attId = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        assert (attId == DbConnection.RESERVED_ATTR_ID);
                        int fileId = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        assert (this.myFileId == fileId);
                        FSRecords.writeRecordHeader(attId, fileId, dataStream);
                    }
                    while (attrRefs.available() > 0) {
                        int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        if (attIdOnPage != encodedAttrId) {
                            if (dataStream == null) {
                                unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                                dataStream = new DataOutputStream((OutputStream)unchangedPreviousDirectoryStream);
                            }
                            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)attIdOnPage);
                            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)attrAddressOrSize);
                            if (attrAddressOrSize >= 64) continue;
                            byte[] b = new byte[attrAddressOrSize];
                            attrRefs.readFully(b);
                            dataStream.write(b);
                            continue;
                        }
                        if (attrAddressOrSize >= 64) continue;
                        if (_out.size() == attrAddressOrSize) {
                            int remaining = attrRefs.available();
                            storage2.replaceBytes(recordId, remainingAtStart - remaining, new ByteSequence(_out.getInternalBuffer(), 0, _out.size()));
                            return;
                        }
                        attrRefs.skipBytes(attrAddressOrSize);
                    }
                }
                finally {
                    attrRefs.close();
                    if (dataStream != null) {
                        dataStream.close();
                    }
                }
            }
            AbstractStorage.StorageDataOutput directoryStream = storage2.writeStream(recordId);
            if (directoryRecord && bulkAttrReadSupport) {
                FSRecords.writeRecordHeader(DbConnection.RESERVED_ATTR_ID, this.myFileId, (DataOutputStream)directoryStream);
            }
            if (unchangedPreviousDirectoryStream != null) {
                directoryStream.write(unchangedPreviousDirectoryStream.getInternalBuffer(), 0, unchangedPreviousDirectoryStream.size());
            }
            if (_out.size() > 0) {
                DataInputOutputUtil.writeINT((DataOutput)directoryStream, (int)encodedAttrId);
                DataInputOutputUtil.writeINT((DataOutput)directoryStream, (int)_out.size());
                directoryStream.write(_out.getInternalBuffer(), 0, _out.size());
            }
            directoryStream.close();
        }
    }

    private static class ContentOutputStream
    extends DataOutputStream {
        final int myFileId;
        final boolean myFixedSize;

        private ContentOutputStream(int fileId, boolean readOnly) {
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myFixedSize = readOnly;
        }

        public void close() throws IOException {
            super.close();
            try {
                BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
                this.writeBytes(new ByteSequence(_out.getInternalBuffer(), 0, _out.size()));
            }
            catch (Throwable e) {
                DbConnection.handleError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeBytes(ByteSequence bytes) throws IOException {
            RefCountingStorage contentStorage = FSRecords.getContentStorage();
            w.lock();
            try {
                boolean fixedSize;
                int page;
                FSRecords.checkFileIsValid(this.myFileId);
                if (weHaveContentHashes) {
                    page = FSRecords.findOrCreateContentRecord(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
                    if (page < 0 || FSRecords.getContentId(this.myFileId) != page) {
                        FSRecords.incModCount(this.myFileId);
                        FSRecords.setContentRecordId(this.myFileId, page > 0 ? page : -page);
                    }
                    FSRecords.setContentRecordId(this.myFileId, page > 0 ? page : -page);
                    if (page > 0) {
                        return;
                    }
                    page = -page;
                    fixedSize = true;
                } else {
                    FSRecords.incModCount(this.myFileId);
                    page = FSRecords.getContentRecordId(this.myFileId);
                    if (page == 0 || contentStorage.getRefCount(page) > 1) {
                        page = contentStorage.acquireNewRecord();
                        FSRecords.setContentRecordId(this.myFileId, page);
                    }
                    fixedSize = this.myFixedSize;
                }
                if (useSnappyForCompression) {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    DataOutputStream outputStream = new DataOutputStream((OutputStream)out);
                    byte[] rawBytes = bytes.getBytes();
                    if (bytes.getOffset() != 0) {
                        rawBytes = new byte[bytes.getLength()];
                        System.arraycopy(bytes.getBytes(), bytes.getOffset(), rawBytes, 0, bytes.getLength());
                    }
                    CompressionUtil.writeCompressed((DataOutput)outputStream, (byte[])rawBytes, (int)bytes.getLength());
                    outputStream.close();
                    bytes = new ByteSequence(out.getInternalBuffer(), 0, out.size());
                }
                contentStorage.writeBytes(page, bytes, fixedSize);
            }
            finally {
                w.unlock();
            }
        }
    }

    public static class NameId {
        @NotNull
        public static final NameId[] EMPTY_ARRAY = new NameId[0];
        public final int id;
        public final CharSequence name;
        public final int nameId;

        public NameId(int id, int nameId, @NotNull CharSequence name) {
            this.id = id;
            this.nameId = nameId;
            this.name = name;
        }

        public String toString() {
            return this.name + " (" + this.id + ")";
        }
    }

    public static class DbConnection {
        private static boolean ourInitialized;
        private static final ConcurrentMap<String, Integer> myAttributeIds;
        private static PersistentStringEnumerator myNames;
        private static Storage myAttributes;
        private static RefCountingStorage myContents;
        private static ResizeableMappedFile myRecords;
        private static PersistentBTreeEnumerator<byte[]> myContentHashesEnumerator;
        private static final VfsDependentEnum<String> myAttributesList;
        private static final TIntArrayList myFreeRecords;
        private static boolean myDirty;
        private static ScheduledFuture<?> myFlushingFuture;
        private static boolean myCorrupted;
        private static final AttrPageAwareCapacityAllocationPolicy REASONABLY_SMALL;
        private static final int RESERVED_ATTR_ID;
        private static final int FIRST_ATTR_ID_OFFSET;

        public static void connect() {
            w.lock();
            try {
                if (!ourInitialized) {
                    DbConnection.init();
                    DbConnection.setupFlushing();
                    ourInitialized = true;
                }
            }
            finally {
                w.unlock();
            }
        }

        private static void scanFreeRecords() {
            int filelength = (int)myRecords.length();
            LOG.assertTrue(filelength % 40 == 0, (Object)("invalid file size: " + filelength));
            int count = filelength / 40;
            for (int n = 2; n < count; ++n) {
                if (!BitUtil.isSet((int)FSRecords.getFlags(n), (int)256)) continue;
                myFreeRecords.add(n);
            }
        }

        static int getFreeRecord() {
            if (myFreeRecords.isEmpty()) {
                return 0;
            }
            return myFreeRecords.remove(myFreeRecords.size() - 1);
        }

        private static void createBrokenMarkerFile(@Nullable Throwable reason) {
            File brokenMarker = DbConnection.getCorruptionMarkerFile();
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (PrintStream stream = new PrintStream(out);){
                    new Exception().printStackTrace(stream);
                    if (reason != null) {
                        stream.print("\nReason:\n");
                        reason.printStackTrace(stream);
                    }
                }
                LOG.info("Creating VFS corruption marker; Trace=\n" + out);
                var4_5 = null;
                try (FileWriter writer = new FileWriter(brokenMarker);){
                    writer.write("These files are corrupted and must be rebuilt from the scratch on next startup");
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static File getCorruptionMarkerFile() {
            return new File(FSRecords.basePath(), "corruption.marker");
        }

        private static void init() {
            File basePath = FSRecords.basePath().getAbsoluteFile();
            basePath.mkdirs();
            File namesFile = new File(basePath, "names" + VFS_FILES_EXTENSION);
            File attributesFile = new File(basePath, "attrib" + VFS_FILES_EXTENSION);
            File contentsFile = new File(basePath, "content" + VFS_FILES_EXTENSION);
            File contentsHashesFile = new File(basePath, "contentHashes" + VFS_FILES_EXTENSION);
            File recordsFile = new File(basePath, "records" + VFS_FILES_EXTENSION);
            File vfsDependentEnumBaseFile = VfsDependentEnum.getBaseFile();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                for (File f : new File[]{namesFile, attributesFile, contentsFile, contentsHashesFile, recordsFile, vfsDependentEnumBaseFile}) {
                    if (f.exists()) {
                        System.out.println(String.format("Cache file: %s from: %s", f, new Date(f.lastModified())));
                        continue;
                    }
                    for (File other : f.getParentFile().listFiles()) {
                        if (!other.getName().startsWith(f.getName())) continue;
                        System.out.println(String.format("Cache file: %s ts: %s", other, new Date(other.lastModified())));
                    }
                }
            }
            if (!namesFile.exists()) {
                DbConnection.invalidateIndex("'" + namesFile.getPath() + "' does not exist");
            }
            try {
                boolean aligned;
                if (DbConnection.getCorruptionMarkerFile().exists()) {
                    DbConnection.invalidateIndex("corruption marker found");
                    throw new IOException("Corruption marker file found");
                }
                PagedFileStorage.StorageLockContext storageLockContext = new PagedFileStorage.StorageLockContext(false);
                myNames = new PersistentStringEnumerator(namesFile, storageLockContext);
                myAttributes = new Storage(attributesFile.getPath(), REASONABLY_SMALL){

                    protected AbstractRecordsTable createRecordsTable(PagePool pool, File recordsFile) throws IOException {
                        return inlineAttributes && useSmallAttrTable ? new CompactRecordsTable(recordsFile, pool, false) : super.createRecordsTable(pool, recordsFile);
                    }
                };
                myContents = new RefCountingStorage(contentsFile.getPath(), CapacityAllocationPolicy.FIVE_PERCENT_FOR_GROWTH, useSnappyForCompression){

                    @NotNull
                    protected ExecutorService createExecutor() {
                        return AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FSRecords pool", (int)1);
                    }
                };
                myContentHashesEnumerator = weHaveContentHashes ? new ContentHashesUtil.HashEnumerator(contentsHashesFile, storageLockContext) : null;
                boolean bl = aligned = PagedFileStorage.BUFFER_SIZE % 40 == 0;
                assert (aligned);
                myRecords = new ResizeableMappedFile(recordsFile, 20480, storageLockContext, PagedFileStorage.BUFFER_SIZE, aligned, IOUtil.ourByteBuffersUseNativeByteOrder);
                if (myRecords.length() == 0L) {
                    DbConnection.cleanRecord(0);
                    DbConnection.cleanRecord(1);
                    DbConnection.setCurrentVersion();
                }
                if (DbConnection.getVersion() != VERSION) {
                    throw new IOException("FS repository version mismatch");
                }
                if (myRecords.getInt(12L) != 523190095) {
                    throw new IOException("FS repository wasn't safely shut down");
                }
                DbConnection.markDirty();
                DbConnection.scanFreeRecords();
            }
            catch (Exception e) {
                LOG.info("Filesystem storage is corrupted or does not exist. [Re]Building. Reason: " + e.getMessage());
                try {
                    DbConnection.closeFiles();
                    boolean deleted = FileUtil.delete((File)DbConnection.getCorruptionMarkerFile());
                    deleted &= IOUtil.deleteAllFilesStartingWith((File)namesFile);
                    deleted &= AbstractStorage.deleteFiles((String)attributesFile.getPath());
                    deleted &= AbstractStorage.deleteFiles((String)contentsFile.getPath());
                    deleted &= IOUtil.deleteAllFilesStartingWith((File)contentsHashesFile);
                    deleted &= IOUtil.deleteAllFilesStartingWith((File)recordsFile);
                    if (!(deleted &= IOUtil.deleteAllFilesStartingWith((File)vfsDependentEnumBaseFile))) {
                        throw new IOException("Cannot delete filesystem storage files");
                    }
                }
                catch (IOException e1) {
                    Runnable warnAndShutdown = () -> {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            e1.printStackTrace();
                        } else {
                            String message2 = "Files in " + basePath.getPath() + " are locked.\n" + ApplicationNamesInfo.getInstance().getProductName() + " will not be able to start up.";
                            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message2, "Fatal Error", 0);
                            } else {
                                System.err.println(message2);
                            }
                        }
                        Runtime.getRuntime().halt(1);
                    };
                    if (EventQueue.isDispatchThread()) {
                        warnAndShutdown.run();
                    } else {
                        SwingUtilities.invokeLater(warnAndShutdown);
                    }
                    throw new RuntimeException("Can't rebuild filesystem storage ", e1);
                }
                DbConnection.init();
            }
        }

        private static void invalidateIndex(String reason) {
            String[] children2;
            LOG.info("Marking VFS as corrupted: " + reason);
            File indexRoot = PathManager.getIndexRoot();
            if (indexRoot.exists() && (children2 = indexRoot.list()) != null && children2.length > 0) {
                FileUtil.createIfDoesntExist((File)new File(PathManager.getIndexRoot(), "corruption.marker"));
            }
        }

        private static String getCachesDir() {
            String dir = System.getProperty("caches_dir");
            return dir == null ? PathManager.getSystemPath() + "/caches/" : dir;
        }

        private static void markDirty() {
            if (!myDirty) {
                myDirty = true;
                myRecords.putInt(12L, 313341156);
            }
        }

        private static void setupFlushing() {
            if (!backgroundVfsFlush) {
                return;
            }
            myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                private int lastModCount;

                @Override
                public void run() {
                    if (this.lastModCount == ourLocalModificationCount) {
                        DbConnection.flush();
                    }
                    this.lastModCount = ourLocalModificationCount;
                }
            });
        }

        public static void force() {
            w.lock();
            try {
                DbConnection.doForce();
            }
            finally {
                w.unlock();
            }
        }

        private static void doForce() {
            if (myNames != null) {
                myNames.force();
                myAttributes.force();
                myContents.force();
                if (myContentHashesEnumerator != null) {
                    myContentHashesEnumerator.force();
                }
                DbConnection.markClean();
                myRecords.force();
            }
        }

        private static void flush() {
            if (!DbConnection.isDirty() || HeavyProcessLatch.INSTANCE.isRunning()) {
                return;
            }
            r.lock();
            try {
                if (myFlushingFuture == null) {
                    return;
                }
                DbConnection.doForce();
            }
            finally {
                r.unlock();
            }
        }

        public static boolean isDirty() {
            return myDirty || myNames.isDirty() || myAttributes.isDirty() || myContents.isDirty() || myRecords.isDirty() || myContentHashesEnumerator != null && myContentHashesEnumerator.isDirty();
        }

        private static int getVersion() {
            int recordsVersion = myRecords.getInt(0L);
            if (myAttributes.getVersion() != recordsVersion || myContents.getVersion() != recordsVersion) {
                return -1;
            }
            return recordsVersion;
        }

        public static long getTimestamp() {
            return myRecords.getLong(16L);
        }

        private static void setCurrentVersion() {
            myRecords.putInt(0L, VERSION);
            myRecords.putLong(16L, System.currentTimeMillis());
            myAttributes.setVersion(VERSION);
            myContents.setVersion(VERSION);
            myRecords.putInt(12L, 523190095);
        }

        static void cleanRecord(int id) {
            myRecords.put((long)(id * 40), ZEROES, 0, 40);
        }

        public static PersistentStringEnumerator getNames() {
            return myNames;
        }

        private static void closeFiles() throws IOException {
            if (myFlushingFuture != null) {
                myFlushingFuture.cancel(false);
                myFlushingFuture = null;
            }
            if (myNames != null) {
                myNames.close();
                myNames = null;
            }
            if (myAttributes != null) {
                Disposer.dispose((Disposable)myAttributes);
                myAttributes = null;
            }
            if (myContents != null) {
                Disposer.dispose((Disposable)myContents);
                myContents = null;
            }
            if (myContentHashesEnumerator != null) {
                myContentHashesEnumerator.close();
                myContentHashesEnumerator = null;
            }
            if (myRecords != null) {
                DbConnection.markClean();
                myRecords.close();
                myRecords = null;
            }
            ourInitialized = false;
        }

        private static void markClean() {
            if (myDirty) {
                myDirty = false;
                myRecords.putInt(12L, myCorrupted ? -1412464769 : 523190095);
            }
        }

        private static int getAttributeId(@NotNull String attId) throws IOException {
            if (persistentAttributesList) {
                return myAttributesList.getId(attId) + FIRST_ATTR_ID_OFFSET;
            }
            Integer integer = (Integer)myAttributeIds.get(attId);
            if (integer != null) {
                return integer;
            }
            int enumeratedId = myNames.enumerate(attId);
            integer = myAttributeIds.putIfAbsent(attId, enumeratedId);
            return integer == null ? enumeratedId : integer;
        }

        private static void handleError(@NotNull Throwable e) throws RuntimeException, Error {
            if (!ourIsDisposed && !myCorrupted && w.tryLock()) {
                w.unlock();
                DbConnection.createBrokenMarkerFile(e);
                myCorrupted = true;
                DbConnection.force();
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }

        static {
            myAttributeIds = ContainerUtil.newConcurrentMap();
            myAttributesList = new VfsDependentEnum("attrib", EnumeratorStringDescriptor.INSTANCE, 1);
            myFreeRecords = new TIntArrayList();
            REASONABLY_SMALL = new AttrPageAwareCapacityAllocationPolicy();
            RESERVED_ATTR_ID = bulkAttrReadSupport ? 1 : 0;
            FIRST_ATTR_ID_OFFSET = bulkAttrReadSupport ? RESERVED_ATTR_ID : 0;
        }

        private static class AttrPageAwareCapacityAllocationPolicy
        extends CapacityAllocationPolicy {
            boolean myAttrPageRequested;

            private AttrPageAwareCapacityAllocationPolicy() {
            }

            public int calculateCapacity(int requiredLength) {
                return Math.max(this.myAttrPageRequested ? 8 : 32, Math.min((int)((double)requiredLength * 1.2), (requiredLength / 1024 + 1) * 1024));
            }
        }
    }
}

