/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.io.ReplicatorInputStream;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentFSImpl
extends PersistentFS
implements ApplicationComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.PersistentFS");
    private final MessageBus myEventBus;
    private final Map<String, VirtualFileSystemEntry> myRoots = ContainerUtil.newConcurrentMap((int)10, (float)0.4f, (int)JobSchedulerImpl.CORES_COUNT, (TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myRootsById = ContainerUtil.createConcurrentIntObjectMap((int)10, (float)0.4f, (int)JobSchedulerImpl.CORES_COUNT);
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myIdToDirCache = ContainerUtil.createConcurrentIntObjectMap();
    private final Object myInputLock = new Object();
    private final AtomicBoolean myShutDown = new AtomicBoolean(false);
    private volatile int myStructureModificationCount;
    @NotNull
    private static final Comparator<EventWrapper> DEPTH_COMPARATOR = Comparator.comparingInt(o -> ((EventWrapper)o).event.getFileDepth());

    public PersistentFSImpl(@NotNull MessageBus bus) {
        this.myEventBus = bus;
        ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown);
        LowMemoryWatcher.register(this::clearIdCache, (Disposable)this);
    }

    public void initComponent() {
        FSRecords.connect();
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    public void dispose() {
    }

    private void performShutdown() {
        if (this.myShutDown.compareAndSet(false, true)) {
            LOG.info("VFS dispose started");
            FSRecords.dispose();
            LOG.info("VFS dispose completed");
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "app.component.PersistentFS";
    }

    public boolean areChildrenLoaded(@NotNull VirtualFile dir) {
        return PersistentFSImpl.areChildrenLoaded(PersistentFSImpl.getFileId(dir));
    }

    public long getCreationTimestamp() {
        return FSRecords.getCreationTimestamp();
    }

    @NotNull
    private static NewVirtualFileSystem getDelegate(@NotNull VirtualFile file2) {
        return (NewVirtualFileSystem)file2.getFileSystem();
    }

    public boolean wereChildrenAccessed(@NotNull VirtualFile dir) {
        return FSRecords.wereChildrenAccessed(PersistentFSImpl.getFileId(dir));
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        int id = PersistentFSImpl.getFileId(file2);
        Object[] nameIds = FSRecords.listAll(id);
        if (!PersistentFSImpl.areChildrenLoaded(id)) {
            nameIds = PersistentFSImpl.persistAllChildren(file2, id, (FSRecords.NameId[])nameIds);
        }
        return (String[])ContainerUtil.map2Array((Object[])nameIds, String.class, id1 -> id1.name.toString());
    }

    @Override
    @NotNull
    public String[] listPersisted(@NotNull VirtualFile parent) {
        return PersistentFSImpl.listPersisted(FSRecords.list(PersistentFSImpl.getFileId(parent)));
    }

    @NotNull
    private static String[] listPersisted(@NotNull int[] childrenIds) {
        String[] names = ArrayUtil.newStringArray((int)childrenIds.length);
        for (int i2 = 0; i2 < childrenIds.length; ++i2) {
            names[i2] = FSRecords.getName(childrenIds[i2]);
        }
        return names;
    }

    @NotNull
    private static FSRecords.NameId[] persistAllChildren(@NotNull VirtualFile file2, int id, @NotNull FSRecords.NameId[] current) {
        NewVirtualFileSystem fs = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate(file2));
        Object[] delegateNames = VfsUtil.filterNames((String[])fs.list(file2));
        if (delegateNames.length == 0 && current.length > 0) {
            return current;
        }
        HashSet toAdd = ContainerUtil.newHashSet((Object[])delegateNames);
        for (FSRecords.NameId nameId : current) {
            toAdd.remove(nameId.name.toString());
        }
        TIntArrayList childrenIds = new TIntArrayList(current.length + toAdd.size());
        ArrayList nameIds = ContainerUtil.newArrayListWithCapacity((int)(current.length + toAdd.size()));
        for (FSRecords.NameId nameId : current) {
            childrenIds.add(nameId.id);
            nameIds.add(nameId);
        }
        for (String newName : toAdd) {
            FakeVirtualFile child = new FakeVirtualFile(file2, newName);
            FileAttributes attributes = fs.getAttributes((VirtualFile)child);
            if (attributes == null) continue;
            int childId = PersistentFSImpl.createAndFillRecord(fs, (VirtualFile)child, id, attributes);
            childrenIds.add(childId);
            nameIds.add(new FSRecords.NameId(childId, FileNameCache.storeName(newName), newName));
        }
        FSRecords.updateList(id, childrenIds.toNativeArray());
        PersistentFSImpl.setChildrenCached(id);
        return nameIds.toArray(new FSRecords.NameId[nameIds.size()]);
    }

    private static void setChildrenCached(int id) {
        int flags = FSRecords.getFlags(id);
        FSRecords.setFlags(id, flags | 1, true);
    }

    @Override
    @NotNull
    public FSRecords.NameId[] listAll(@NotNull VirtualFile parent) {
        int parentId = PersistentFSImpl.getFileId(parent);
        FSRecords.NameId[] nameIds = FSRecords.listAll(parentId);
        if (!PersistentFSImpl.areChildrenLoaded(parentId)) {
            return PersistentFSImpl.persistAllChildren(parent, parentId, nameIds);
        }
        return nameIds;
    }

    private static boolean areChildrenLoaded(int parentId) {
        return BitUtil.isSet((int)FSRecords.getFlags(parentId), (int)1);
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        return FSRecords.readAttributeWithLock(PersistentFSImpl.getFileId(file2), att);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        return FSRecords.writeAttribute(PersistentFSImpl.getFileId(file2), att);
    }

    @Nullable
    private static DataInputStream readContent(@NotNull VirtualFile file2) {
        return FSRecords.readContent(PersistentFSImpl.getFileId(file2));
    }

    @Nullable
    private static DataInputStream readContentById(int contentId) {
        return FSRecords.readContentById(contentId);
    }

    @NotNull
    private static DataOutputStream writeContent(@NotNull VirtualFile file2, boolean readOnly) {
        return FSRecords.writeContent(PersistentFSImpl.getFileId(file2), readOnly);
    }

    private static void writeContent(@NotNull VirtualFile file2, ByteSequence content, boolean readOnly) {
        FSRecords.writeContent(PersistentFSImpl.getFileId(file2), content, readOnly);
    }

    @Override
    public int storeUnlinkedContent(@NotNull byte[] bytes) {
        return FSRecords.storeUnlinkedContent(bytes);
    }

    public int getModificationCount(@NotNull VirtualFile file2) {
        return FSRecords.getModCount(PersistentFSImpl.getFileId(file2));
    }

    public int getModificationCount() {
        return FSRecords.getLocalModCount();
    }

    public int getStructureModificationCount() {
        return this.myStructureModificationCount;
    }

    public void incStructuralModificationCount() {
        ++this.myStructureModificationCount;
    }

    public int getFilesystemModificationCount() {
        return FSRecords.getModCount();
    }

    private static boolean writeAttributesToRecord(int id, int parentId, @NotNull VirtualFile file2, @NotNull NewVirtualFileSystem fs, @NotNull FileAttributes attributes) {
        assert (id > 0) : id;
        String name = file2.getName();
        if (!name.isEmpty() ? PersistentFSImpl.namesEqual((VirtualFileSystem)fs, name, FSRecords.getNameSequence(id)) : PersistentFSImpl.areChildrenLoaded(id)) {
            return false;
        }
        FSRecords.writeAttributesToRecord(id, parentId, attributes, name);
        return true;
    }

    @Override
    public int getFileAttributes(int id) {
        assert (id > 0);
        return FSRecords.getFlags(id);
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        return PersistentFSImpl.isDirectory(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    private static boolean namesEqual(@NotNull VirtualFileSystem fs, @NotNull CharSequence n1, CharSequence n2) {
        return Comparing.equal((CharSequence)n1, (CharSequence)n2, (boolean)fs.isCaseSensitive());
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        return ((VirtualFileWithId)fileOrDirectory).getId() > 0;
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        return FSRecords.getTimestamp(PersistentFSImpl.getFileId(file2));
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long modStamp) throws IOException {
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.setTimestamp(id, modStamp);
        PersistentFSImpl.getDelegate(file2).setTimeStamp(file2, modStamp);
    }

    private static int getFileId(@NotNull VirtualFile file2) {
        int id = ((VirtualFileWithId)file2).getId();
        if (id <= 0) {
            throw new InvalidVirtualFileAccessException(file2);
        }
        return id;
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        return PersistentFSImpl.isSymLink(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        return !BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)4);
    }

    @Override
    public boolean isHidden(@NotNull VirtualFile file2) {
        return BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)64);
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        PersistentFSImpl.getDelegate(file2).setWritable(file2, writableFlag);
        boolean oldWritable = this.isWritable(file2);
        if (oldWritable != writableFlag) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, file2, "writable", (Object)oldWritable, (Object)writableFlag, false));
        }
    }

    @Override
    public int getId(@NotNull VirtualFile parent, @NotNull String childName, @NotNull NewVirtualFileSystem fs) {
        int parentId = PersistentFSImpl.getFileId(parent);
        int[] children2 = FSRecords.list(parentId);
        if (children2.length > 0) {
            int nameId = FSRecords.getNameId(childName);
            int[] nArray = children2;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int childId = nArray[j];
                if (nameId != FSRecords.getNameId(childId)) continue;
                return childId;
            }
        }
        for (int childId : children2) {
            if (!PersistentFSImpl.namesEqual((VirtualFileSystem)fs, childName, FSRecords.getNameSequence(childId))) continue;
            return childId;
        }
        FakeVirtualFile fake = new FakeVirtualFile(parent, childName);
        FileAttributes attributes = fs.getAttributes((VirtualFile)fake);
        if (attributes != null) {
            int child = PersistentFSImpl.createAndFillRecord(fs, (VirtualFile)fake, parentId, attributes);
            FSRecords.updateList(parentId, ArrayUtil.append((int[])children2, (int)child));
            return child;
        }
        return 0;
    }

    public long getLength(@NotNull VirtualFile file2) {
        long len = PersistentFSImpl.mustReloadContent(file2) ? PersistentFSImpl.reloadLengthFromDelegate(file2, PersistentFSImpl.getDelegate(file2)) : this.getLastRecordedLength(file2);
        return len;
    }

    @Override
    public long getLastRecordedLength(@NotNull VirtualFile file2) {
        int id = PersistentFSImpl.getFileId(file2);
        return FSRecords.getLength(id);
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile parent, @NotNull String name) throws IOException {
        PersistentFSImpl.getDelegate(file2).copyFile(requestor, file2, parent, name);
        this.processEvent((VFileEvent)new VFileCopyEvent(requestor, file2, parent, name));
        VirtualFile child = parent.findChild(name);
        if (child == null) {
            throw new IOException("Cannot create child");
        }
        return child;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        PersistentFSImpl.getDelegate(parent).createChildDirectory(requestor, parent, dir);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, dir, true, false));
        VirtualFile child = parent.findChild(dir);
        if (child == null) {
            throw new IOException("Cannot create child directory '" + dir + "' at " + parent.getPath());
        }
        return child;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        PersistentFSImpl.getDelegate(parent).createChildFile(requestor, parent, file2);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, file2, false, false));
        VirtualFile child = parent.findChild(file2);
        if (child == null) {
            throw new IOException("Cannot create child file '" + file2 + "' at " + parent.getPath());
        }
        return child;
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        delegate.deleteFile(requestor, file2);
        if (!delegate.exists(file2)) {
            this.processEvent((VFileEvent)new VFileDeleteEvent(requestor, file2, false));
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        PersistentFSImpl.getDelegate(file2).renameFile(requestor, file2, newName);
        String oldName = file2.getName();
        if (!newName.equals(oldName)) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent(requestor, file2, "name", (Object)oldName, (Object)newName, false));
        }
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        return this.contentsToByteArray(file2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2, boolean cacheContent) throws IOException {
        boolean reloadFromDelegate;
        boolean outdated;
        int fileId;
        DataInputStream contentStream = null;
        long length = -1L;
        Object object = this.myInputLock;
        synchronized (object) {
            fileId = PersistentFSImpl.getFileId(file2);
            outdated = PersistentFSImpl.checkFlag(fileId, 8) || (length = FSRecords.getLength(fileId)) == -1L;
            reloadFromDelegate = outdated || (contentStream = PersistentFSImpl.readContent(file2)) == null;
        }
        if (reloadFromDelegate) {
            byte[] content;
            NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
            if (outdated) {
                FSRecords.setLength(fileId, delegate.getLength(file2));
                content = delegate.contentsToByteArray(file2);
            } else {
                content = delegate.contentsToByteArray(file2);
                FSRecords.setLength(fileId, content.length);
            }
            Application application = ApplicationManager.getApplication();
            if ((!delegate.isReadOnly() || cacheContent && !application.isInternal() && !application.isUnitTestMode()) && (long)content.length <= PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
                Object object2 = this.myInputLock;
                synchronized (object2) {
                    PersistentFSImpl.writeContent(file2, new ByteSequence(content), delegate.isReadOnly());
                    PersistentFSImpl.setFlag(file2, 8, false);
                }
            }
            return content;
        }
        try {
            assert (length >= 0L) : file2;
            return FileUtil.loadBytes((InputStream)contentStream, (int)((int)length));
        }
        catch (IOException e) {
            FSRecords.handleError(e);
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(int contentId) throws IOException {
        DataInputStream stream = PersistentFSImpl.readContentById(contentId);
        assert (stream != null) : contentId;
        return FileUtil.loadBytes((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        Object object = this.myInputLock;
        synchronized (object) {
            DataInputStream contentStream;
            if (PersistentFSImpl.mustReloadContent(file2) || FileUtilRt.isTooLarge((long)file2.getLength()) || (contentStream = PersistentFSImpl.readContent(file2)) == null) {
                NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                long len = PersistentFSImpl.reloadLengthFromDelegate(file2, delegate);
                InputStream nativeStream = delegate.getInputStream(file2);
                if (len > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
                    return nativeStream;
                }
                return this.createReplicator(file2, nativeStream, len, delegate.isReadOnly());
            }
            return contentStream;
        }
    }

    private static long reloadLengthFromDelegate(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem delegate) {
        long len = delegate.getLength(file2);
        FSRecords.setLength(PersistentFSImpl.getFileId(file2), len);
        return len;
    }

    private InputStream createReplicator(final @NotNull VirtualFile file2, InputStream nativeStream, final long fileLength, final boolean readOnly) {
        if (nativeStream instanceof BufferExposingByteArrayInputStream) {
            BufferExposingByteArrayInputStream byteStream = (BufferExposingByteArrayInputStream)nativeStream;
            byte[] bytes = byteStream.getInternalBuffer();
            this.storeContentToStorage(fileLength, file2, readOnly, bytes, bytes.length);
            return nativeStream;
        }
        final BufferExposingByteArrayOutputStream cache2 = new BufferExposingByteArrayOutputStream((int)fileLength);
        return new ReplicatorInputStream(nativeStream, cache2){

            public void close() throws IOException {
                super.close();
                PersistentFSImpl.this.storeContentToStorage(fileLength, file2, readOnly, cache2.getInternalBuffer(), cache2.size());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeContentToStorage(long fileLength, @NotNull VirtualFile file2, boolean readOnly, @NotNull byte[] bytes, int bytesLength) {
        Object object = this.myInputLock;
        synchronized (object) {
            if ((long)bytesLength == fileLength) {
                PersistentFSImpl.writeContent(file2, new ByteSequence(bytes, 0, bytesLength), readOnly);
                PersistentFSImpl.setFlag(file2, 8, false);
            } else {
                PersistentFSImpl.setFlag(file2, 8, true);
            }
        }
    }

    private static boolean mustReloadContent(@NotNull VirtualFile file2) {
        int fileId = PersistentFSImpl.getFileId(file2);
        return PersistentFSImpl.checkFlag(fileId, 8) || FSRecords.getLength(fileId) == -1L;
    }

    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, final Object requestor, final long modStamp, final long timeStamp) throws IOException {
        return new ByteArrayOutputStream(){
            private boolean closed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                super.close();
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file2, file2.getModificationStamp(), modStamp, false);
                List<VFileContentChangeEvent> events = Collections.singletonList(event);
                BulkFileListener publisher = (BulkFileListener)PersistentFSImpl.this.myEventBus.syncPublisher(VirtualFileManager.VFS_CHANGES);
                publisher.before(events);
                NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                OutputStream ioFileStream = delegate.getOutputStream(file2, requestor, modStamp, timeStamp);
                DataOutputStream persistenceStream = PersistentFSImpl.writeContent(file2, delegate.isReadOnly());
                try {
                    ((OutputStream)persistenceStream).write(this.buf, 0, this.count);
                }
                finally {
                    try {
                        ioFileStream.write(this.buf, 0, this.count);
                    }
                    finally {
                        this.closed = true;
                        ((OutputStream)persistenceStream).close();
                        ioFileStream.close();
                        PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp());
                        publisher.after(events);
                    }
                }
            }
        };
    }

    @Override
    public int acquireContent(@NotNull VirtualFile file2) {
        return FSRecords.acquireFileContent(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public void releaseContent(int contentId) {
        FSRecords.releaseContent(contentId);
    }

    @Override
    public int getCurrentContentId(@NotNull VirtualFile file2) {
        return FSRecords.getContentId(PersistentFSImpl.getFileId(file2));
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        PersistentFSImpl.getDelegate(file2).moveFile(requestor, file2, newParent);
        this.processEvent((VFileEvent)new VFileMoveEvent(requestor, file2, newParent));
    }

    private void processEvent(@NotNull VFileEvent event) {
        this.processEvents(Collections.singletonList(event));
    }

    @NotNull
    private static List<VFileEvent> validateEvents(@NotNull List<VFileEvent> events) {
        TIntHashSet invalidIDs;
        ArrayList deletionEvents = ContainerUtil.newArrayList();
        int size = events.size();
        for (int i2 = 0; i2 < size; ++i2) {
            VFileEvent event = events.get(i2);
            if (!(event instanceof VFileDeleteEvent) || !event.isValid()) continue;
            deletionEvents.add(new EventWrapper((VFileDeleteEvent)event, i2));
        }
        if (deletionEvents.isEmpty()) {
            invalidIDs = EmptyIntHashSet.INSTANCE;
        } else {
            ContainerUtil.quickSort((List)deletionEvents, DEPTH_COMPARATOR);
            invalidIDs = new TIntHashSet(deletionEvents.size());
            THashSet dirsToBeDeleted = new THashSet(deletionEvents.size());
            block1: for (EventWrapper wrapper : deletionEvents) {
                VirtualFile candidate;
                for (VirtualFile parent = candidate = wrapper.event.getFile(); parent != null; parent = parent.getParent()) {
                    if (!dirsToBeDeleted.contains(parent)) continue;
                    invalidIDs.add(wrapper.id);
                    continue block1;
                }
                if (!candidate.isDirectory()) continue;
                dirsToBeDeleted.add(candidate);
            }
        }
        ArrayList<VFileEvent> filtered = new ArrayList<VFileEvent>(events.size() - invalidIDs.size());
        int size2 = events.size();
        for (int i3 = 0; i3 < size2; ++i3) {
            VFileEvent event = events.get(i3);
            if (!event.isValid() || event instanceof VFileDeleteEvent && invalidIDs.contains(i3)) continue;
            filtered.add(event);
        }
        return filtered;
    }

    @Override
    public void processEvents(@NotNull List<VFileEvent> events) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<VFileEvent> validated = PersistentFSImpl.validateEvents(events);
        BulkFileListener publisher = (BulkFileListener)this.myEventBus.syncPublisher(VirtualFileManager.VFS_CHANGES);
        publisher.before(validated);
        THashMap parentToChildrenEventsChanges = null;
        for (VFileEvent event : validated) {
            VirtualFile changedParent = null;
            if (event instanceof VFileCreateEvent) {
                changedParent = ((VFileCreateEvent)event).getParent();
                ((VFileCreateEvent)event).resetCache();
            } else if (event instanceof VFileDeleteEvent) {
                changedParent = ((VFileDeleteEvent)event).getFile().getParent();
            }
            if (changedParent != null) {
                List parentChildrenChanges;
                if (parentToChildrenEventsChanges == null) {
                    parentToChildrenEventsChanges = new THashMap();
                }
                if ((parentChildrenChanges = (List)parentToChildrenEventsChanges.get((Object)changedParent)) == null) {
                    parentChildrenChanges = new SmartList();
                    parentToChildrenEventsChanges.put((Object)changedParent, (Object)parentChildrenChanges);
                }
                parentChildrenChanges.add(event);
                continue;
            }
            this.applyEvent(event);
        }
        if (parentToChildrenEventsChanges != null) {
            parentToChildrenEventsChanges.forEachEntry((parent, childrenEvents) -> {
                this.applyChildrenChangeEvents((VirtualFile)parent, (List<VFileEvent>)childrenEvents);
                return true;
            });
            parentToChildrenEventsChanges.clear();
        }
        publisher.after(validated);
    }

    private void applyChildrenChangeEvents(@NotNull VirtualFile parent, @NotNull List<VFileEvent> events) {
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(parent);
        TIntArrayList childrenIdsUpdated = new TIntArrayList();
        int parentId = PersistentFSImpl.getFileId(parent);
        assert (parentId != 0);
        TIntHashSet parentChildrenIds = new TIntHashSet(FSRecords.list(parentId));
        boolean hasRemovedChildren = false;
        SmartList childrenToBeUpdated = new SmartList();
        for (VFileEvent event : events) {
            if (event instanceof VFileCreateEvent) {
                String name = ((VFileCreateEvent)event).getChildName();
                FakeVirtualFile fake = new FakeVirtualFile(parent, name);
                FileAttributes attributes = delegate.getAttributes((VirtualFile)fake);
                if (attributes == null) continue;
                int childId = PersistentFSImpl.createAndFillRecord(delegate, (VirtualFile)fake, parentId, attributes);
                assert (parent instanceof VirtualDirectoryImpl) : parent;
                VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
                VirtualFileSystemEntry child = dir.createChild(name, childId, dir.getFileSystem());
                childrenToBeUpdated.add(child);
                childrenIdsUpdated.add(childId);
                parentChildrenIds.add(childId);
                continue;
            }
            if (!(event instanceof VFileDeleteEvent)) continue;
            VirtualFile file2 = ((VFileDeleteEvent)event).getFile();
            if (!file2.exists()) {
                LOG.error("Deleting a file, which does not exist: " + file2.getPath());
                continue;
            }
            hasRemovedChildren = true;
            int id = PersistentFSImpl.getFileId(file2);
            childrenToBeUpdated.add(file2);
            childrenIdsUpdated.add(-id);
            parentChildrenIds.remove(id);
        }
        FSRecords.updateList(parentId, parentChildrenIds.toArray());
        if (hasRemovedChildren) {
            this.clearIdCache();
        }
        VirtualDirectoryImpl parentImpl = (VirtualDirectoryImpl)parent;
        int len = childrenIdsUpdated.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int childId = childrenIdsUpdated.get(i2);
            VirtualFile childFile = (VirtualFile)childrenToBeUpdated.get(i2);
            if (childId > 0) {
                parentImpl.addChild((VirtualFileSystemEntry)childFile);
                continue;
            }
            FSRecords.deleteRecordRecursively(-childId);
            parentImpl.removeChild(childFile);
            PersistentFSImpl.invalidateSubtree(childFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFileSystemEntry findRoot(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        boolean mark;
        String rootPath;
        String rootName;
        if (path.isEmpty()) {
            LOG.error("Invalid root, fs=" + fs);
            return null;
        }
        String rootUrl = PersistentFSImpl.normalizeRootUrl(path, fs);
        VirtualFileSystemEntry root = this.myRoots.get(rootUrl);
        if (root != null) {
            return root;
        }
        if (fs instanceof ArchiveFileSystem) {
            ArchiveFileSystem afs = (ArchiveFileSystem)fs;
            VirtualFile localFile = afs.findLocalByRootPath(path);
            if (localFile == null) {
                return null;
            }
            rootName = localFile.getName();
            rootPath = afs.getRootPathByLocal(localFile);
        } else {
            rootName = rootPath = path;
        }
        FileAttributes attributes = fs.getAttributes((VirtualFile)new StubVirtualFile(){

            @NotNull
            public String getPath() {
                return rootPath;
            }

            @Nullable
            public VirtualFile getParent() {
                return null;
            }
        });
        if (attributes == null || !attributes.isDirectory()) {
            return null;
        }
        int rootId = FSRecords.findRootRecord(rootUrl);
        VfsData.Segment segment = VfsData.getSegment(rootId, true);
        VfsData.DirectoryData directoryData = new VfsData.DirectoryData();
        FsRoot newRoot = new FsRoot(rootId, segment, directoryData, fs, rootName, StringUtil.trimEnd((String)rootPath, (char)'/'));
        Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
        synchronized (map2) {
            root = this.myRoots.get(rootUrl);
            if (root != null) {
                return root;
            }
            try {
                VfsData.initFile(rootId, segment, -1, directoryData);
            }
            catch (VfsData.FileAlreadyCreatedException e) {
                for (Map.Entry<String, VirtualFileSystemEntry> entry : this.myRoots.entrySet()) {
                    VirtualFileSystemEntry existingRoot = entry.getValue();
                    if (Math.abs(existingRoot.getId()) != rootId) continue;
                    throw new RuntimeException("Duplicate FS roots: " + rootUrl + " and " + entry.getKey() + ", id=" + rootId + ", valid=" + existingRoot.isValid(), e);
                }
                throw new RuntimeException("No root duplication, roots=" + Arrays.toString(FSRecords.listAll(1)), e);
            }
            this.incStructuralModificationCount();
            mark = PersistentFSImpl.writeAttributesToRecord(rootId, 0, (VirtualFile)newRoot, fs, attributes);
            this.myRoots.put(rootUrl, newRoot);
            this.myRootsById.put(rootId, (Object)newRoot);
            this.myIdToDirCache.put(rootId, (Object)newRoot);
        }
        if (!mark && attributes.lastModified != FSRecords.getTimestamp(rootId)) {
            ((VirtualFileSystemEntry)newRoot).markDirtyRecursively();
        }
        LOG.assertTrue(rootId == newRoot.getId(), (Object)("root=" + (Object)((Object)newRoot) + " expected=" + rootId + " actual=" + newRoot.getId()));
        return newRoot;
    }

    @NotNull
    private static String normalizeRootUrl(@NotNull String basePath, @NotNull NewVirtualFileSystem fs) {
        String normalized = VfsImplUtil.normalize(fs, FileUtil.toCanonicalPath((String)basePath));
        String protocol = fs.getProtocol();
        StringBuilder result2 = new StringBuilder(protocol.length() + "://".length() + normalized.length());
        result2.append(protocol).append("://").append(normalized);
        return StringUtil.endsWithChar((CharSequence)result2, (char)'/') ? UriUtil.trimTrailingSlashes(result2.toString()) : result2.toString();
    }

    @Override
    public void clearIdCache() {
        Iterator iterator = this.myIdToDirCache.entries().iterator();
        while (iterator.hasNext()) {
            ConcurrentIntObjectMap.IntEntry entry = (ConcurrentIntObjectMap.IntEntry)iterator.next();
            int id = entry.getKey();
            if (this.myRootsById.containsKey(id)) continue;
            iterator.remove();
        }
    }

    @Nullable
    public NewVirtualFile findFileById(int id) {
        return this.findFileById(id, false);
    }

    @Override
    public NewVirtualFile findFileByIdIfCached(int id) {
        return this.findFileById(id, true);
    }

    @Nullable
    private VirtualFileSystemEntry findFileById(int id, boolean cachedOnly) {
        VirtualFileSystemEntry cached = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
        if (cached != null) {
            return cached;
        }
        TIntArrayList parents = FSRecords.getParents(id, this.myIdToDirCache);
        int parentId = parents.get(parents.size() - 1);
        VirtualFileSystemEntry result2 = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(parentId));
        for (int i2 = parents.size() - 2; i2 >= 0; --i2) {
            VirtualFileSystemEntry old;
            if (!(result2 instanceof VirtualDirectoryImpl)) {
                return null;
            }
            parentId = parents.get(i2);
            if (!((result2 = ((VirtualDirectoryImpl)result2).findChildById(parentId, cachedOnly)) instanceof VirtualDirectoryImpl) || (old = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.putIfAbsent(parentId, (Object)result2))) == null) continue;
            result2 = old;
        }
        return result2;
    }

    @NotNull
    public VirtualFile[] getRoots() {
        Collection<VirtualFileSystemEntry> roots = this.myRoots.values();
        return (VirtualFile[])ArrayUtil.stripTrailingNulls((Object[])VfsUtilCore.toVirtualFileArray(roots));
    }

    @NotNull
    public VirtualFile[] getRoots(@NotNull NewVirtualFileSystem fs) {
        ArrayList<NewVirtualFile> roots = new ArrayList<NewVirtualFile>();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (newVirtualFile.getFileSystem() != fs) continue;
            roots.add(newVirtualFile);
        }
        return VfsUtilCore.toVirtualFileArray(roots);
    }

    @NotNull
    public VirtualFile[] getLocalRoots() {
        List roots = ContainerUtil.newSmartList();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (!newVirtualFile.isInLocalFileSystem() || newVirtualFile.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(newVirtualFile);
        }
        return VfsUtilCore.toVirtualFileArray((Collection)roots);
    }

    private VirtualFileSystemEntry applyEvent(@NotNull VFileEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Applying " + event);
        }
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)event;
                return PersistentFSImpl.executeCreateChild(createEvent.getParent(), createEvent.getChildName());
            }
            if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent.getFile());
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                PersistentFSImpl.executeTouch(contentUpdateEvent.getFile(), contentUpdateEvent.isFromRefresh(), contentUpdateEvent.getModificationStamp());
            } else {
                if (event instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)event;
                    return PersistentFSImpl.executeCreateChild(copyEvent.getNewParent(), copyEvent.getNewChildName());
                }
                if (event instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                    this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
                } else if (event instanceof VFilePropertyChangeEvent) {
                    VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                    VirtualFile file2 = propertyChangeEvent.getFile();
                    Object newValue = propertyChangeEvent.getNewValue();
                    if ("name".equals(propertyChangeEvent.getPropertyName())) {
                        PersistentFSImpl.executeRename(file2, (String)newValue);
                    } else if ("writable".equals(propertyChangeEvent.getPropertyName())) {
                        PersistentFSImpl.executeSetWritable(file2, (Boolean)newValue);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("File " + file2 + " writable=" + file2.isWritable() + " id=" + PersistentFSImpl.getFileId(file2));
                        }
                    } else if (VirtualFile.PROP_HIDDEN.equals(propertyChangeEvent.getPropertyName())) {
                        PersistentFSImpl.executeSetHidden(file2, (Boolean)newValue);
                    } else if ("symlink".equals(propertyChangeEvent.getPropertyName())) {
                        PersistentFSImpl.executeSetTarget(file2, (String)newValue);
                        this.markForContentReloadRecursively(PersistentFSImpl.getFileId(file2));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    @NonNls
    public String toString() {
        return "PersistentFS";
    }

    private static VirtualFileSystemEntry executeCreateChild(@NotNull VirtualFile parent, @NotNull String name) {
        FakeVirtualFile fake;
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(parent);
        FileAttributes attributes = delegate.getAttributes((VirtualFile)(fake = new FakeVirtualFile(parent, name)));
        if (attributes != null) {
            int parentId = PersistentFSImpl.getFileId(parent);
            int childId = PersistentFSImpl.createAndFillRecord(delegate, (VirtualFile)fake, parentId, attributes);
            PersistentFSImpl.appendIdToParentList(parentId, childId);
            assert (parent instanceof VirtualDirectoryImpl) : parent;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
            VirtualFileSystemEntry child = dir.createChild(name, childId, dir.getFileSystem());
            dir.addChild(child);
            return child;
        }
        return null;
    }

    private static int createAndFillRecord(@NotNull NewVirtualFileSystem delegateSystem, @NotNull VirtualFile delegateFile, int parentId, @NotNull FileAttributes attributes) {
        int childId = FSRecords.createRecord();
        PersistentFSImpl.writeAttributesToRecord(childId, parentId, delegateFile, delegateSystem, attributes);
        return childId;
    }

    private static void appendIdToParentList(int parentId, int childId) {
        int[] childrenList = FSRecords.list(parentId);
        childrenList = ArrayUtil.append((int[])childrenList, (int)childId);
        FSRecords.updateList(parentId, childrenList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(@NotNull VirtualFile file2) {
        int parentId;
        if (!file2.exists()) {
            LOG.error("Deleting a file, which does not exist: " + file2.getPath());
            return;
        }
        this.clearIdCache();
        int id = PersistentFSImpl.getFileId(file2);
        VirtualFile parent = file2.getParent();
        int n = parentId = parent == null ? 0 : PersistentFSImpl.getFileId(parent);
        if (parentId == 0) {
            String rootUrl = PersistentFSImpl.normalizeRootUrl(file2.getPath(), (NewVirtualFileSystem)file2.getFileSystem());
            Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
            synchronized (map2) {
                this.myRoots.remove(rootUrl);
                this.myRootsById.remove(id);
                this.myIdToDirCache.remove(id);
                FSRecords.deleteRootRecord(id);
            }
        } else {
            PersistentFSImpl.removeIdFromParentList(parentId, id, parent, file2);
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file2.getParent();
            assert (directory != null) : file2;
            directory.removeChild(file2);
        }
        FSRecords.deleteRecordRecursively(id);
        PersistentFSImpl.invalidateSubtree(file2);
        this.incStructuralModificationCount();
    }

    private static void invalidateSubtree(@NotNull VirtualFile file2) {
        VirtualFileSystemEntry impl = (VirtualFileSystemEntry)file2;
        impl.invalidate();
        for (VirtualFile child : impl.getCachedChildren()) {
            PersistentFSImpl.invalidateSubtree(child);
        }
    }

    private static void removeIdFromParentList(int parentId, int id, @NotNull VirtualFile parent, VirtualFile file2) {
        int[] childList = FSRecords.list(parentId);
        int index = ArrayUtil.indexOf((int[])childList, (int)id);
        if (index == -1) {
            throw new RuntimeException("Cannot find child (" + id + ")" + file2 + "\n\tin (" + parentId + ")" + parent + "\n\tactual children:" + Arrays.toString(childList));
        }
        childList = ArrayUtil.remove((int[])childList, (int)index);
        FSRecords.updateList(parentId, childList);
    }

    private static void executeRename(@NotNull VirtualFile file2, @NotNull String newName) {
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.setName(id, newName);
        ((VirtualFileSystemEntry)file2).setNewName(newName);
    }

    private static void executeSetWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        PersistentFSImpl.setFlag(file2, 4, !writableFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("writable", writableFlag);
    }

    private static void executeSetHidden(@NotNull VirtualFile file2, boolean hiddenFlag) {
        PersistentFSImpl.setFlag(file2, 64, hiddenFlag);
        ((VirtualFileSystemEntry)file2).updateProperty(VirtualFile.PROP_HIDDEN, hiddenFlag);
    }

    private static void executeSetTarget(@NotNull VirtualFile file2, String target) {
        ((VirtualFileSystemEntry)file2).setLinkTarget(target);
    }

    private static void setFlag(@NotNull VirtualFile file2, int mask, boolean value2) {
        PersistentFSImpl.setFlag(PersistentFSImpl.getFileId(file2), mask, value2);
    }

    private static void setFlag(int id, int mask, boolean value2) {
        int flags;
        int oldFlags = FSRecords.getFlags(id);
        int n = flags = value2 ? oldFlags | mask : oldFlags & ~mask;
        if (oldFlags != flags) {
            FSRecords.setFlags(id, flags, true);
        }
    }

    private static boolean checkFlag(int fileId, int mask) {
        return BitUtil.isSet((int)FSRecords.getFlags(fileId), (int)mask);
    }

    private static void executeTouch(@NotNull VirtualFile file2, boolean reloadContentFromDelegate, long newModificationStamp) {
        if (reloadContentFromDelegate) {
            PersistentFSImpl.setFlag(file2, 8, true);
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        FileAttributes attributes = delegate.getAttributes(file2);
        FSRecords.setLength(PersistentFSImpl.getFileId(file2), attributes != null ? attributes.length : 0L);
        FSRecords.setTimestamp(PersistentFSImpl.getFileId(file2), attributes != null ? attributes.lastModified : 0L);
        ((VirtualFileSystemEntry)file2).setModificationStamp(newModificationStamp);
    }

    private void executeMove(@NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        this.clearIdCache();
        int fileId = PersistentFSImpl.getFileId(file2);
        int newParentId = PersistentFSImpl.getFileId(newParent);
        int oldParentId = PersistentFSImpl.getFileId(file2.getParent());
        PersistentFSImpl.removeIdFromParentList(oldParentId, fileId, file2.getParent(), file2);
        FSRecords.setParent(fileId, newParentId);
        PersistentFSImpl.appendIdToParentList(newParentId, fileId);
        ((VirtualFileSystemEntry)file2).setParent(newParent);
    }

    @Override
    public String getName(int id) {
        assert (id > 0);
        return FSRecords.getName(id);
    }

    public void cleanPersistedContents() {
        int[] roots = FSRecords.listRoots();
        if (roots != null) {
            for (int root : roots) {
                this.markForContentReloadRecursively(root);
            }
        }
    }

    private void markForContentReloadRecursively(int id) {
        if (PersistentFSImpl.isDirectory(this.getFileAttributes(id))) {
            for (int child : FSRecords.list(id)) {
                this.markForContentReloadRecursively(child);
            }
        } else {
            PersistentFSImpl.setFlag(id, 8, true);
        }
    }

    private static boolean looksCanonical(@NotNull String pathBeforeSlash) {
        int i2;
        if (pathBeforeSlash.endsWith("/")) {
            return false;
        }
        int start = 0;
        while ((i2 = pathBeforeSlash.indexOf("..", start)) != -1) {
            if (i2 != 0 && pathBeforeSlash.charAt(i2 - 1) == '/') {
                return false;
            }
            if (i2 < pathBeforeSlash.length() - 2 && pathBeforeSlash.charAt(i2 + 2) == '/') {
                return false;
            }
            start = i2 + 1;
        }
        return true;
    }

    private static class FsRoot
    extends VirtualDirectoryImpl {
        private final String myName;
        private final String myPathBeforeSlash;

        private FsRoot(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data, @NotNull NewVirtualFileSystem fs, @NotNull String name, @NotNull String pathBeforeSlash) {
            super(id, segment, data, null, fs);
            this.myName = name;
            if (!PersistentFSImpl.looksCanonical(pathBeforeSlash)) {
                throw new IllegalArgumentException("path must be canonical but got: '" + pathBeforeSlash + "'");
            }
            this.myPathBeforeSlash = pathBeforeSlash;
        }

        @Override
        @NotNull
        public CharSequence getNameSequence() {
            return this.myName;
        }

        @Override
        protected char[] appendPathOnFileSystem(int pathLength, int[] position) {
            char[] chars = new char[pathLength + this.myPathBeforeSlash.length()];
            position[0] = FsRoot.copyString(chars, position[0], this.myPathBeforeSlash);
            return chars;
        }

        @Override
        public void setNewName(@NotNull String newName) {
            throw new IncorrectOperationException();
        }

        @Override
        public final void setParent(@NotNull VirtualFile newParent) {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myPathBeforeSlash + '/';
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.getFileSystem().getProtocol() + "://" + this.getPath();
        }
    }

    private static class EventWrapper {
        private final VFileDeleteEvent event;
        private final int id;

        private EventWrapper(VFileDeleteEvent event, int id) {
            this.event = event;
            this.id = id;
        }
    }
}

