/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.impl.ShadowPainter;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

final class WindowShadowPainter
extends AbstractPainter {
    private static final ShadowPainter PAINTER = new ShadowPainter(AllIcons.Ide.Shadow.Popup.Top, AllIcons.Ide.Shadow.Popup.Top_right, AllIcons.Ide.Shadow.Popup.Right, AllIcons.Ide.Shadow.Popup.Bottom_right, AllIcons.Ide.Shadow.Popup.Bottom, AllIcons.Ide.Shadow.Popup.Bottom_left, AllIcons.Ide.Shadow.Popup.Left, AllIcons.Ide.Shadow.Popup.Top_left);
    private static final long MASK = 262209L;
    private static final AtomicReference<AWTEventListener> WINDOW_LISTENER = new AtomicReference<1>(new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            Object source;
            Object object = source = event == null ? null : event.getSource();
            if (source instanceof Window) {
                Container c = (Window)source;
                while (c instanceof Window && c instanceof RootPaneContainer) {
                    WindowShadowPainter painter;
                    Component pane;
                    JRootPane root = ((RootPaneContainer)((Object)c)).getRootPane();
                    if (root != null && (pane = root.getGlassPane()) instanceof IdeGlassPaneImpl && (painter = ((IdeGlassPaneImpl)pane).myWindowShadowPainter) != null && pane == painter.myComponent) {
                        List shadows = painter.myShadows;
                        painter.myShadows = WindowShadowPainter.getShadows(pane, c);
                        if (!Objects.equals(painter.myShadows, shadows)) {
                            pane.repaint();
                        }
                    }
                    c = c.getParent();
                }
            }
        }
    });
    private List<Rectangle> myShadows;
    private Component myComponent;

    public WindowShadowPainter() {
        AWTEventListener listener2 = WINDOW_LISTENER.getAndSet(null);
        if (listener2 != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 262209L);
        }
    }

    public boolean needsRepaint() {
        return true;
    }

    public void executePaint(Component component, Graphics2D g) {
        Window window = UIUtil.getWindow((Component)component);
        if (window != null) {
            List<Rectangle> shadows;
            if (this.myComponent != component) {
                this.myComponent = component;
                this.myShadows = WindowShadowPainter.getShadows(component, window);
            }
            if ((shadows = this.myShadows) != null) {
                for (Rectangle bounds : shadows) {
                    PAINTER.paintShadow(component, g, bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        }
    }

    private static List<Rectangle> getShadows(Component component, Window window) {
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, component);
        return WindowShadowPainter.getShadows(null, point, window.getOwnedWindows());
    }

    private static List<Rectangle> getShadows(List<Rectangle> list, Point point, Window ... windows) {
        if (windows != null) {
            for (Window window : windows) {
                Rectangle bounds = WindowShadowPainter.getShadowBounds(point, window);
                if (bounds != null) {
                    if (list == null) {
                        list = ContainerUtil.newArrayList();
                    }
                    list.add(bounds);
                }
                list = WindowShadowPainter.getShadows(list, point, window.getOwnedWindows());
            }
        }
        return list;
    }

    private static Rectangle getShadowBounds(Point point, Window window) {
        Object property;
        RootPaneContainer container;
        JRootPane root;
        Dialog dialog2;
        Frame frame;
        if (!window.isShowing()) {
            return null;
        }
        if (!window.isDisplayable()) {
            return null;
        }
        if (window instanceof Frame && !(frame = (Frame)window).isUndecorated()) {
            return null;
        }
        if (window instanceof Dialog && !(dialog2 = (Dialog)window).isUndecorated()) {
            return null;
        }
        if (window instanceof RootPaneContainer && (root = (container = (RootPaneContainer)((Object)window)).getRootPane()) != null && (property = root.getClientProperty("Window.shadow")) instanceof Boolean && !((Boolean)property).booleanValue()) {
            return null;
        }
        Rectangle bounds = window.getBounds();
        if (bounds.isEmpty()) {
            return null;
        }
        bounds.x -= AllIcons.Ide.Shadow.Popup.Left.getIconWidth() + point.x;
        bounds.y -= AllIcons.Ide.Shadow.Popup.Top.getIconHeight() + point.y;
        bounds.width += AllIcons.Ide.Shadow.Popup.Left.getIconWidth() + AllIcons.Ide.Shadow.Popup.Right.getIconWidth();
        bounds.height += AllIcons.Ide.Shadow.Popup.Top.getIconHeight() + AllIcons.Ide.Shadow.Popup.Bottom.getIconHeight();
        return bounds;
    }
}

