/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RequestFocusInEditorComponentCmd
extends FinalizableCommand {
    private JComponent myComponent;
    private final boolean myForced;
    private final ActionCallback myDoneCallback;
    private final IdeFocusManager myFocusManager;
    private final Expirable myTimestamp;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.commands.RequestFocusInEditorComponentCmd");

    public RequestFocusInEditorComponentCmd(@NotNull EditorsSplitters splitters, IdeFocusManager focusManager, Runnable finishCallBack, boolean forced) {
        super(finishCallBack);
        EditorWithProviderComposite editor;
        boolean shouldLogFocuses = Registry.is((String)"ide.log.focuses");
        if (shouldLogFocuses) {
            LOG.info((Throwable)new Exception());
        }
        this.myComponent = null;
        EditorWindow window = splitters.getCurrentWindow();
        if (window != null && (editor = window.getSelectedEditor()) != null) {
            this.myComponent = editor.getPreferredFocusedComponent();
        }
        this.myForced = forced;
        this.myFocusManager = focusManager;
        this.myDoneCallback = new ActionCallback();
        this.myTimestamp = this.myFocusManager.getTimestamp(true);
    }

    public ActionCallback getDoneCallback() {
        return this.myDoneCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            Component owner;
            if (this.myTimestamp.isExpired()) {
                owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (owner != null && owner == this.myComponent) {
                    this.myDoneCallback.setDone();
                } else {
                    this.myDoneCallback.setRejected();
                }
            }
            Component component = owner = this.myComponent != null ? SwingUtilities.getWindowAncestor(this.myComponent) : null;
            if (owner == null) {
                this.myDoneCallback.setRejected();
                return;
            }
            Window activeFrame = IdeFrameImpl.getActiveFrame();
            if (activeFrame != null && owner instanceof IdeFrameImpl && activeFrame != owner) {
                this.myDoneCallback.setRejected();
                return;
            }
            if (this.myComponent != null) {
                boolean forced = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == null;
                this.myFocusManager.requestFocus((Component)this.myComponent, this.myForced || forced).notifyWhenDone(this.myDoneCallback).doWhenDone(() -> RequestFocusInEditorComponentCmd.lambda$run$0((Window)owner));
            } else {
                this.myDoneCallback.setRejected();
            }
        }
        finally {
            this.finish();
        }
    }

    @Nullable
    private static Window getActiveWindow(Window[] windows) {
        for (Window window1 : windows) {
            Window window = window1;
            if (window.isShowing() && window.isActive()) {
                return window;
            }
            if ((window = RequestFocusInEditorComponentCmd.getActiveWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }

    private static /* synthetic */ void lambda$run$0(Window owner) {
        Window activeWindow;
        if (SystemInfo.isLinux && Registry.is((String)"suppress.focus.stealing")) {
            return;
        }
        if (!owner.isActive() && ((activeWindow = RequestFocusInEditorComponentCmd.getActiveWindow(owner.getOwnedWindows())) == null || activeWindow instanceof FloatingDecorator)) {
            owner.toFront();
        }
    }
}

