/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorBasedWidget
implements StatusBarWidget,
FileEditorManagerListener {
    protected StatusBar myStatusBar;
    protected Project myProject;
    protected MessageBusConnection myConnection;
    private volatile boolean myDisposed;

    protected EditorBasedWidget(@NotNull Project project2) {
        this.myProject = project2;
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this);
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    @Nullable
    protected final Editor getEditor() {
        FileEditorManager manager;
        Editor editor;
        Project project2 = this.getProject();
        if (project2 == null || project2.isDisposed()) {
            return null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(project2, this.myStatusBar);
        Editor result2 = null;
        if (fileEditor instanceof TextEditor) {
            result2 = ((TextEditor)fileEditor).getEditor();
        }
        if (result2 == null && (editor = (manager = FileEditorManager.getInstance((Project)project2)).getSelectedTextEditor()) != null && WindowManager.getInstance().getStatusBar((Component)editor.getComponent(), project2) == this.myStatusBar) {
            result2 = editor;
        }
        return result2;
    }

    protected boolean isOurEditor(Editor editor) {
        return editor != null && editor.getComponent().isShowing() && !Boolean.TRUE.equals(editor.getUserData(EditorTextField.SUPPLEMENTARY_KEY)) && WindowManager.getInstance().getStatusBar((Component)editor.getComponent(), editor.getProject()) == this.myStatusBar;
    }

    @Nullable
    protected VirtualFile getSelectedFile() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        return FileDocumentManager.getInstance().getFile(document);
    }

    @Nullable
    protected final Project getProject() {
        return this.myProject;
    }

    public void install(@NotNull StatusBar statusBar) {
        this.myStatusBar = statusBar;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myStatusBar = null;
        this.myConnection.disconnect();
        this.myConnection = null;
        this.myProject = null;
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }
}

