/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.UIBundle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InsertOverwritePanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget,
PropertyChangeListener {
    private final TextPanel myTextPanel = new TextPanel();
    private EditorEx myOldEditor;

    public InsertOverwritePanel(Project project2) {
        super(project2);
        this.myTextPanel.setRightPadding(7);
    }

    @NotNull
    public String ID() {
        return "InsertOverwrite";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type2) {
        return null;
    }

    public StatusBarWidget copy() {
        return new InsertOverwritePanel(this.getProject());
    }

    public JComponent getComponent() {
        return this.myTextPanel;
    }

    private void updateStatus() {
        Editor editor = this.getEditor();
        if (editor == null || !editor.isColumnMode()) {
            this.myTextPanel.setBorder(null);
            this.myTextPanel.setVisible(false);
        } else {
            this.myTextPanel.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
            this.myTextPanel.setVisible(true);
            this.myTextPanel.setText(UIBundle.message((String)"status.bar.column.status.text", (Object[])new Object[0]));
            this.myTextPanel.setToolTipText("Column selection mode");
        }
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.updateStatus();
        this.switchEditor();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.updateStatus();
        this.switchEditor();
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        if ("insertMode".equals(evt.getPropertyName()) || "columnMode".equals(evt.getPropertyName())) {
            this.updateStatus();
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        this.updateStatus();
        this.switchEditor();
    }

    private void switchEditor() {
        EditorEx editor;
        if (this.myOldEditor != null) {
            this.myOldEditor.removePropertyChangeListener(this);
            this.myOldEditor = null;
        }
        if ((editor = (EditorEx)this.getEditor()) != null) {
            editor.addPropertyChangeListener(this);
            this.myOldEditor = editor;
        }
    }
}

