/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryUsagePanel
extends JButton
implements CustomStatusBarWidget {
    @NonNls
    public static final String WIDGET_ID = "Memory";
    private static final int MEGABYTE = 0x100000;
    @NonNls
    private static final String SAMPLE_STRING;
    private static final Color USED_COLOR;
    private static final Color UNUSED_COLOR;
    private long myLastTotal = -1L;
    private long myLastUsed = -1L;
    private Image myBufferedImage;
    private boolean myWasPressed;

    public MemoryUsagePanel() {
        this.setOpaque(false);
        this.setFocusable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
                MemoryUsagePanel.this.updateState();
            }
        });
        this.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        this.updateUI();
        new UiNotifyConnector((Component)this, new Activatable(){
            private ScheduledFuture<?> myFuture;

            public void showNotify() {
                this.myFuture = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> MemoryUsagePanel.this.updateState(), 1L, 5L, TimeUnit.SECONDS);
            }

            public void hideNotify() {
                if (this.myFuture != null) {
                    this.myFuture.cancel(true);
                    this.myFuture = null;
                }
            }
        });
    }

    public void dispose() {
    }

    public void install(@NotNull StatusBar statusBar) {
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type2) {
        return null;
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    public void setShowing(boolean showing) {
        if (showing != this.isVisible()) {
            this.setVisible(showing);
            this.revalidate();
        }
    }

    @Override
    public void updateUI() {
        this.myBufferedImage = null;
        super.updateUI();
        this.setFont(MemoryUsagePanel.getWidgetFont());
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    private static Font getWidgetFont() {
        return JBUI.Fonts.label((float)11.0f);
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean pressed = this.getModel().isPressed();
        boolean stateChanged = this.myWasPressed != pressed;
        this.myWasPressed = pressed;
        if (this.myBufferedImage == null || stateChanged) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            this.myBufferedImage = UIUtil.createImage((Graphics)g, (int)size.width, (int)size.height, (int)2);
            Graphics2D g2 = (Graphics2D)this.myBufferedImage.getGraphics().create();
            Runtime rt = Runtime.getRuntime();
            long maxMem = rt.maxMemory();
            long allocatedMem = rt.totalMemory();
            long unusedMem = rt.freeMemory();
            long usedMem = allocatedMem - unusedMem;
            int totalBarLength = size.width - insets.left - insets.right;
            int usedBarLength = (int)((long)totalBarLength * usedMem / maxMem);
            int unusedBarLength = (int)((long)totalBarLength * unusedMem / maxMem);
            int barHeight = Math.max(size.height, this.getFont().getSize() + 2);
            int yOffset = (size.height - barHeight) / 2;
            int xOffset = insets.left;
            g2.setColor(UIUtil.getPanelBackground());
            g2.fillRect(0, 0, size.width, size.height);
            g2.setColor(USED_COLOR);
            g2.fillRect(xOffset, yOffset, usedBarLength, barHeight);
            g2.setColor(UNUSED_COLOR);
            g2.fillRect(xOffset + usedBarLength, yOffset, unusedBarLength, barHeight);
            g2.setFont(this.getFont());
            long used = usedMem / 0x100000L;
            long total = maxMem / 0x100000L;
            String info = UIBundle.message((String)"memory.usage.panel.message.text", (Object[])new Object[]{used, total});
            FontMetrics fontMetrics = g.getFontMetrics();
            int infoWidth = fontMetrics.charsWidth(info.toCharArray(), 0, info.length());
            int infoHeight = fontMetrics.getAscent();
            UISettings.setupAntialiasing((Graphics)g2);
            Color fg = pressed ? UIUtil.getLabelDisabledForeground() : JBColor.foreground();
            g2.setColor(fg);
            g2.drawString(info, xOffset + (totalBarLength - infoWidth) / 2, yOffset + infoHeight + (barHeight - infoHeight) / 2 - 1);
            g2.dispose();
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myBufferedImage, (int)0, (int)0, null);
        if (UIUtil.isJreHiDPI((Graphics2D)((Graphics2D)g)) && !UIUtil.isUnderDarcula()) {
            Graphics2D g2 = (Graphics2D)g.create(0, 0, this.getWidth(), this.getHeight());
            float s = JBUI.sysScale((Graphics2D)g2);
            g2.scale(1.0f / s, 1.0f / s);
            g2.setColor((Color)(UIUtil.isUnderIntelliJLaF() ? Gray.xC9 : Gray.x91));
            g2.drawLine(0, 0, (int)(s * (float)this.getWidth()), 0);
            g2.scale(1.0, 1.0);
            g2.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int width = this.getFontMetrics(MemoryUsagePanel.getWidgetFont()).stringWidth(SAMPLE_STRING) + insets.left + insets.right + JBUI.scale((int)2);
        int height = this.getFontMetrics(MemoryUsagePanel.getWidgetFont()).getHeight() + insets.top + insets.bottom + JBUI.scale((int)2);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void updateState() {
        if (!this.isShowing()) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory() / 0x100000L;
        long used = total - runtime.freeMemory() / 0x100000L;
        if (total != this.myLastTotal || used != this.myLastUsed) {
            this.myLastTotal = total;
            this.myLastUsed = used;
            UIUtil.invokeLaterIfNeeded(() -> {
                this.myBufferedImage = null;
                this.repaint();
            });
            this.setToolTipText(UIBundle.message((String)"memory.usage.panel.statistics.message", (Object[])new Object[]{total, used}));
        }
    }

    static {
        long maxMemory = Math.min(Runtime.getRuntime().maxMemory() / 0x100000L, 9999L);
        SAMPLE_STRING = maxMemory + " of " + maxMemory + "M ";
        USED_COLOR = new JBColor((Color)Gray._185, (Color)Gray._110);
        UNUSED_COLOR = new JBColor(Gray._200.withAlpha(100), (Color)Gray._90);
    }
}

