/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextPanel
extends JComponent
implements Accessible {
    @Nullable
    private String myText;
    @Nullable
    private Color myCustomColor;
    private Integer myPrefHeight;
    private Dimension myExplicitSize;
    private float myAlignment;
    private int myRightPadding = JBUI.scale((int)14);

    protected TextPanel() {
        this.setOpaque(false);
    }

    @Override
    public Font getFont() {
        return SystemInfo.isMac ? JBUI.Fonts.label((float)11.0f) : JBUI.Fonts.label();
    }

    public void recomputeSize() {
        JLabel label = new JLabel("XXX");
        label.setFont(this.getFont());
        this.myPrefHeight = label.getPreferredSize().height;
    }

    public void resetColor() {
        this.myCustomColor = null;
    }

    public void setCustomColor(@Nullable Color customColor) {
        this.myCustomColor = customColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        String s = this.getText();
        Rectangle bounds = this.getBounds();
        if (UIUtil.isUnderDarcula()) {
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (s == null) {
            return;
        }
        Insets insets = this.getInsets();
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.getFont());
        UISettings.setupAntialiasing((Graphics)g);
        FontMetrics fm = g2.getFontMetrics();
        int sWidth = fm.stringWidth(s);
        int x = insets.left;
        if (this.myAlignment == 0.5f || this.myAlignment == 1.0f) {
            x = this.myAlignment == 0.5f ? (bounds.width - sWidth) / 2 : bounds.width - insets.right - sWidth;
        }
        Rectangle textR = new Rectangle();
        Rectangle iconR = new Rectangle();
        Rectangle viewR = new Rectangle(bounds);
        textR.height = 0;
        textR.width = 0;
        textR.y = 0;
        textR.x = 0;
        viewR.width -= insets.left;
        viewR.width -= insets.right;
        int maxWidth = bounds.width - insets.left - insets.right;
        if (sWidth > maxWidth) {
            s = this.truncateText(s, bounds, fm, textR, iconR, maxWidth);
        }
        int y = UIUtil.getStringY((String)s, (Rectangle)bounds, (Graphics2D)g2);
        g2.setColor(this.myCustomColor == null ? this.getForeground() : this.myCustomColor);
        g2.drawString(s, x, y);
    }

    protected String truncateText(String text, Rectangle bounds, FontMetrics fm, Rectangle textR, Rectangle iconR, int maxWidth) {
        return SwingUtilities.layoutCompoundLabel(fm, text, null, 0, 0, 0, 11, bounds, iconR, textR, 0);
    }

    public void setTextAlignment(float alignment) {
        this.myAlignment = alignment;
    }

    private static String splitText(JLabel label, String text, int widthLimit) {
        FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
        String[] lines = UIUtil.splitText((String)text, (FontMetrics)fontMetrics, (int)widthLimit, (char)' ');
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i > 0) {
                result2.append('\n');
            }
            result2.append(line);
        }
        return result2.toString();
    }

    public final void setText(@Nullable String text) {
        if ((text = StringUtil.notNullize((String)text)).equals(this.myText)) {
            return;
        }
        String oldAccessibleName = null;
        if (this.accessibleContext != null) {
            oldAccessibleName = this.accessibleContext.getAccessibleName();
        }
        this.myText = text;
        if (this.accessibleContext != null && !StringUtil.equals((CharSequence)this.accessibleContext.getAccessibleName(), (CharSequence)oldAccessibleName)) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, this.accessibleContext.getAccessibleName());
        }
        this.setPreferredSize(this.getPanelDimensionFromFontMetrics(this.myText));
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myExplicitSize != null) {
            return this.myExplicitSize;
        }
        String text = this.getTextForPreferredSize();
        return this.getPanelDimensionFromFontMetrics(text);
    }

    public void setRightPadding(int rightPadding) {
        this.myRightPadding = rightPadding;
    }

    private Dimension getPanelDimensionFromFontMetrics(String text) {
        int width = text == null ? 0 : this.myRightPadding + this.getFontMetrics(this.getFont()).stringWidth(text);
        int height = this.myPrefHeight == null ? this.getMinimumSize().height : this.myPrefHeight;
        return new Dimension(width, height);
    }

    @Nullable
    protected String getTextForPreferredSize() {
        return this.myText;
    }

    public void setExplicitSize(@Nullable Dimension explicitSize) {
        this.myExplicitSize = explicitSize;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTextPanel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleTextPanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleTextPanel() {
            super(TextPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public String getAccessibleName() {
            return TextPanel.this.myText;
        }
    }

    public static class ExtraSize
    extends TextPanel {
        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(size.width + 3, size.height);
        }
    }

    public static class WithIconAndArrows
    extends TextPanel {
        private static final int GAP = 2;
        @Nullable
        private Icon myIcon;

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            super.paintComponent(g);
            if (this.getText() != null) {
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                Icon arrows = AllIcons.Ide.Statusbar_arrows;
                arrows.paintIcon(this, g, r.width - insets.right - arrows.getIconWidth() - 1, r.height / 2 - arrows.getIconHeight() / 2);
                if (this.myIcon != null) {
                    this.myIcon.paintIcon(this, g, insets.left - 2 - this.myIcon.getIconWidth(), r.height / 2 - this.myIcon.getIconHeight() / 2);
                }
            }
        }

        @Override
        @NotNull
        public Insets getInsets() {
            Insets insets = super.getInsets();
            if (this.myIcon != null) {
                insets.left += this.myIcon.getIconWidth() + 4;
            }
            return insets;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int deltaWidth = AllIcons.Ide.Statusbar_arrows.getIconWidth();
            if (this.myIcon != null) {
                deltaWidth += this.myIcon.getIconWidth();
            }
            return new Dimension(preferredSize.width + deltaWidth, preferredSize.height);
        }

        public void setIcon(@Nullable Icon icon) {
            this.myIcon = icon;
        }
    }
}

