/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.Gray;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBSlidingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlatWelcomeFrame
extends JFrame
implements IdeFrame,
Disposable,
AccessibleContextAccessor {
    public static final String BOTTOM_PANEL = "BOTTOM_PANEL";
    private static final String ACTION_GROUP_KEY = "ACTION_GROUP_KEY";
    public static final int DEFAULT_HEIGHT = 460;
    public static final int MAX_DEFAUL_WIDTH = 777;
    private BalloonLayout myBalloonLayout;
    private final ProjectManagerAdapter myListener;
    private boolean myDisposed;

    public FlatWelcomeFrame() {
        JRootPane rootPane = this.getRootPane();
        FlatWelcomeScreen screen = new FlatWelcomeScreen();
        Disposer.register((Disposable)this, (Disposable)screen);
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane){

            @Override
            public void addNotify() {
                super.addNotify();
                TransactionGuard.submitTransaction((Disposable)FlatWelcomeFrame.this, () -> JBProtocolCommand.handleCurrentCommand());
            }
        };
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.setContentPane(screen.getWelcomePanel());
        this.setTitle(this.getWelcomeFrameTitle());
        AppUIUtil.updateWindowIcon(this);
        int width = RecentProjectsManager.getInstance().getRecentProjectsActions(false).length == 0 ? 666 : 777;
        this.getRootPane().setPreferredSize((Dimension)JBUI.size((int)width, (int)Math.max(460, this.getMinimumSize().height)));
        this.setResizable(false);
        Dimension size = this.getPreferredSize();
        Point location = DimensionService.getInstance().getLocation("WELCOME_SCREEN", null);
        Rectangle screenBounds = ScreenUtil.getScreenRectangle((Point)(location != null ? location : new Point(0, 0)));
        this.setBounds(screenBounds.x + (screenBounds.width - size.width) / 2, screenBounds.y + (screenBounds.height - size.height) / 3, size.width, size.height);
        UiNotifyConnector.doWhenFirstShown((Component)this, this::pack);
        this.myListener = new ProjectManagerAdapter(){

            public void projectOpened(Project project2) {
                Disposer.dispose((Disposable)FlatWelcomeFrame.this);
            }
        };
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)this.myListener);
        this.myBalloonLayout = PlatformUtils.isAndroidStudio() ? new WelcomeBalloonLayoutImpl(rootPane, (Insets)JBUI.insets((int)8), screen.myEventListener, screen.myEventLocation) : new BalloonLayoutImpl(rootPane, (Insets)JBUI.insets((int)8));
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        screen.setupFrame(this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        ProjectManager.getInstance().removeProjectManagerListener((ProjectManagerListener)this.myListener);
        FlatWelcomeFrame.saveLocation(this.getBounds());
        super.dispose();
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        WelcomeFrame.resetInstance();
        FocusTrackback.release(this);
    }

    private static void saveLocation(Rectangle location) {
        Point middle = new Point(location.x + location.width / 2, location.y + location.height / 2);
        DimensionService.getInstance().setLocation("WELCOME_SCREEN", middle, null);
    }

    public StatusBar getStatusBar() {
        return null;
    }

    public static Color getMainBackground() {
        return new JBColor(0xF7F7F7, 4540234);
    }

    public static Color getProjectsBackground() {
        return new JBColor((Color)Gray.xFF, (Color)Gray.x39);
    }

    public static Color getLinkNormalColor() {
        return new JBColor((Color)Gray._0, (Color)Gray.xBB);
    }

    public static Color getListSelectionColor(boolean hasFocus) {
        return hasFocus ? new JBColor(3700182, 4943535) : new JBColor((Color)Gray.xDD, (Color)Gray.x45);
    }

    public static Color getActionLinkSelectionColor() {
        return new JBColor(14411253, 4741237);
    }

    public static JBColor getSeparatorColor() {
        return new JBColor((Color)Gray.xEC, new Color(72, 75, 78));
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    protected String getWelcomeFrameTitle() {
        return "Welcome to " + ApplicationNamesInfo.getInstance().getFullProductName();
    }

    @Nullable
    public static JComponent getPreferredFocusedComponent(@NotNull Pair<JPanel, JBList> pair) {
        JBTextField textField;
        if (((JBList)pair.second).getModel().getSize() == 1 && (textField = (JBTextField)UIUtil.uiTraverser((Component)((Component)pair.first)).filter(JBTextField.class).first()) != null) {
            return textField;
        }
        return (JComponent)pair.second;
    }

    public static boolean isUseProjectGroups() {
        return Registry.is((String)"welcome.screen.project.grouping.enabled");
    }

    private static Runnable createUsageTracker(AnAction action) {
        return () -> UsageTrigger.trigger("welcome.screen." + ActionManager.getInstance().getId(action));
    }

    private static JLabel createArrow(final ActionLink link) {
        JLabel arrow = new JLabel(AllIcons.General.Combo3);
        arrow.setCursor(Cursor.getPredefinedCursor(12));
        arrow.setVerticalAlignment(3);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                MouseEvent newEvent = MouseEventAdapter.convert((MouseEvent)e, (Component)link, (int)e.getX(), (int)e.getY());
                link.doClick((InputEvent)newEvent);
                return true;
            }
        }.installOn((Component)arrow);
        return arrow;
    }

    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    public Rectangle suggestChildFrameBounds() {
        return this.getBounds();
    }

    @Nullable
    public Project getProject() {
        return ProjectManager.getInstance().getDefaultProject();
    }

    public void setFrameTitle(String title) {
        this.setTitle(title);
    }

    public void setFileTitle(String fileTitle, File ioFile) {
        this.setTitle(fileTitle);
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key2) {
        return null;
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    public static void notifyFrameClosed(JFrame frame) {
        FlatWelcomeFrame.saveLocation(frame.getBounds());
    }

    public static Pair<JPanel, JBList> createActionGroupPanel(ActionGroup action, JComponent parent, final Runnable backAction, @NotNull Disposable parentDisposable) {
        JPanel actionsListPanel = new JPanel(new BorderLayout());
        actionsListPanel.setBackground(FlatWelcomeFrame.getProjectsBackground());
        List<AnAction> groups = FlatWelcomeFrame.flattenActionGroups(action);
        final DefaultListModel model = JBList.createDefaultListModel((Object[])ArrayUtil.toObjectArray(groups));
        JBList list = new JBList((ListModel)model);
        for (AnAction group : groups) {
            if (!(group instanceof Disposable)) continue;
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)group));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                model.clear();
            }
        });
        list.setBackground(FlatWelcomeFrame.getProjectsBackground());
        list.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer<AnAction>((ListItemDescriptor)new ListItemDescriptorAdapter<AnAction>(){

            @Nullable
            public String getTextFor(AnAction value2) {
                return FlatWelcomeFrame.getActionText(value2);
            }

            @Nullable
            public String getCaptionAboveOf(AnAction value2) {
                return FlatWelcomeFrame.getParentGroupName(value2);
            }

            public boolean hasSeparatorAboveOf(AnAction value2) {
                int index = model.indexOf(value2);
                String parentGroupName = FlatWelcomeFrame.getParentGroupName(value2);
                if (index < 1) {
                    return parentGroupName != null;
                }
                AnAction upper = (AnAction)model.get(index - 1);
                if (FlatWelcomeFrame.getParentGroupName(upper) == null && parentGroupName != null) {
                    return true;
                }
                return !Comparing.equal((String)FlatWelcomeFrame.getParentGroupName(upper), (String)parentGroupName);
            }
        }){

            @Override
            protected JComponent createItemComponent() {
                this.myTextLabel = new ErrorLabel();
                this.myTextLabel.setOpaque(true);
                this.myTextLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)7));
                return this.myTextLabel;
            }

            protected Color getBackground() {
                return FlatWelcomeFrame.getProjectsBackground();
            }

            @Override
            protected void customizeComponent(JList<? extends AnAction> list, AnAction value2, boolean isSelected) {
                if (this.myTextLabel != null) {
                    this.myTextLabel.setText(FlatWelcomeFrame.getActionText(value2));
                    this.myTextLabel.setIcon(value2.getTemplatePresentation().getIcon());
                    this.myTextLabel.setBackground(isSelected ? UIUtil.getListBackground((boolean)true) : FlatWelcomeFrame.getProjectsBackground());
                }
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)list, (boolean)true);
        pane.setBackground(FlatWelcomeFrame.getProjectsBackground());
        actionsListPanel.add((Component)pane, "Center");
        int width = (int)Math.min(Math.round(list.getPreferredSize().getWidth()), 200L);
        pane.setPreferredSize((Dimension)JBUI.size((int)(width + 14), (int)-1));
        boolean singleProjectGenerator = list.getModel().getSize() == 1;
        Ref selected = Ref.create();
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)actionsListPanel, "West");
        JComponent back = FlatWelcomeFrame.createBackLabel(backAction, singleProjectGenerator);
        if (back != null && !singleProjectGenerator) {
            actionsListPanel.add((Component)back, "South");
        }
        ListSelectionListener selectionListener = e -> {
            Object value2;
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!selected.isNull()) {
                main.remove((Component)selected.get());
            }
            if ((value2 = list.getSelectedValue()) instanceof AbstractActionWithPanel) {
                JPanel first;
                JPanel panel2 = ((AbstractActionWithPanel)((Object)((Object)value2))).createPanel();
                panel2.setBorder((Border)JBUI.Borders.empty((int)7, (int)10));
                selected.set((Object)panel2);
                main.add((Component)selected.get());
                if (singleProjectGenerator && back != null && (first = (JPanel)UIUtil.uiTraverser((Component)panel2).traverse().filter(JPanel.class).filter(it -> BOTTOM_PANEL.equals(it.getName())).first()) != null) {
                    first.add((Component)back, "West");
                }
                for (JButton button : UIUtil.findComponentsOfType((JComponent)main, JButton.class)) {
                    if (button.getClientProperty("DefaultAction") != Boolean.TRUE) continue;
                    parent.getRootPane().setDefaultButton(button);
                    break;
                }
                main.revalidate();
                main.repaint();
            }
        };
        list.addListSelectionListener(selectionListener);
        if (backAction != null) {
            new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    backAction.run();
                }
            }.registerCustomShortcutSet(27, 0, (JComponent)main);
        }
        FlatWelcomeFrame.installQuickSearch(list);
        if (singleProjectGenerator) {
            actionsListPanel.setPreferredSize(new Dimension(0, 0));
        }
        return Pair.create((Object)main, (Object)list);
    }

    @Nullable
    private static JComponent createBackLabel(final @Nullable Runnable backAction, boolean singleProjectGenerator) {
        if (backAction == null) {
            return null;
        }
        if (singleProjectGenerator) {
            JButton button = new JButton("Back");
            button.addActionListener(e -> backAction.run());
            return button;
        }
        JLabel back = new JLabel(AllIcons.Actions.Back);
        back.setBorder((Border)JBUI.Borders.empty((int)3, (int)7, (int)3, (int)7));
        back.setHorizontalAlignment(2);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                backAction.run();
                return true;
            }
        }.installOn((Component)back);
        return back;
    }

    public static void installQuickSearch(JBList list) {
        new ListSpeedSearch((JList)list, (Convertor<Object, String>)((Convertor)o -> {
            if (o instanceof AbstractActionWithPanel) {
                return ((AbstractActionWithPanel)((Object)((Object)o))).getTemplatePresentation().getText();
            }
            return null;
        }));
    }

    private static List<AnAction> flattenActionGroups(@NotNull ActionGroup action) {
        ArrayList groups = ContainerUtil.newArrayList();
        for (AnAction anAction : action.getChildren(null)) {
            if (anAction instanceof ActionGroup) {
                String groupName = FlatWelcomeFrame.getActionText(anAction);
                for (AnAction childAction : ((ActionGroup)anAction).getChildren(null)) {
                    if (groupName != null) {
                        FlatWelcomeFrame.setParentGroupName(groupName, childAction);
                    }
                    groups.add(childAction);
                }
                continue;
            }
            groups.add(anAction);
        }
        return groups;
    }

    private static String getActionText(@NotNull AnAction value2) {
        return value2.getTemplatePresentation().getText();
    }

    private static String getParentGroupName(@NotNull AnAction value2) {
        return (String)value2.getTemplatePresentation().getClientProperty(ACTION_GROUP_KEY);
    }

    private static void setParentGroupName(@NotNull String groupName, @NotNull AnAction childAction) {
        childAction.getTemplatePresentation().putClientProperty(ACTION_GROUP_KEY, (Object)groupName);
    }

    public static class WelcomeScreenActionsPanel {
        private JPanel root;
        private JPanel actions;

        public WelcomeScreenActionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JPanel jPanel2;
            this.root = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.setOpaque(false);
            this.actions = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel.setOpaque(false);
            jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel2.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.root;
        }
    }

    private class FlatWelcomeScreen
    extends JPanel
    implements WelcomeScreen {
        private JBSlidingPanel mySlidingPanel;
        public Consumer<List<NotificationType>> myEventListener;
        public Computable<Point> myEventLocation;

        public FlatWelcomeScreen() {
            super(new BorderLayout());
            this.mySlidingPanel = new JBSlidingPanel();
            this.mySlidingPanel.add("root", (Component)this);
            this.setBackground(FlatWelcomeFrame.getMainBackground());
            if (RecentProjectsManager.getInstance().getRecentProjectsActions(false, FlatWelcomeFrame.isUseProjectGroups()).length > 0) {
                final JComponent recentProjects = this.createRecentProjects();
                this.add((Component)recentProjects, "West");
                final JList projectsList = (JList)UIUtil.findComponentOfType((JComponent)recentProjects, JList.class);
                if (projectsList != null) {
                    projectsList.getModel().addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            this.removeIfNeeded();
                        }

                        private void removeIfNeeded() {
                            if (RecentProjectsManager.getInstance().getRecentProjectsActions(false, FlatWelcomeFrame.isUseProjectGroups()).length == 0) {
                                FlatWelcomeScreen.this.remove(recentProjects);
                                FlatWelcomeScreen.this.revalidate();
                                FlatWelcomeScreen.this.repaint();
                            }
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            this.removeIfNeeded();
                        }
                    });
                    projectsList.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            projectsList.repaint();
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            projectsList.repaint();
                        }
                    });
                }
            }
            this.add((Component)this.createBody(), "Center");
        }

        public JComponent getWelcomePanel() {
            return this.mySlidingPanel;
        }

        private JComponent createBody() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            panel2.add((Component)this.createLogo(), (Object)"North");
            panel2.add((Component)this.createActionPanel(), (Object)"Center");
            panel2.add((Component)this.createSettingsAndDocs(), (Object)"South");
            return panel2;
        }

        private JComponent createSettingsAndDocs() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            NonOpaquePanel toolbar = new NonOpaquePanel();
            AnAction register = ActionManager.getInstance().getAction("Register");
            boolean registeredVisible = false;
            if (register != null) {
                AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)register, null, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext((Component)this));
                register.update(e);
                Presentation presentation = e.getPresentation();
                if (presentation.isEnabled()) {
                    ActionLink registerLink = new ActionLink("Register", register);
                    registerLink.setFocusable(false);
                    registerLink.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
                    NonOpaquePanel button = new NonOpaquePanel((LayoutManager)new BorderLayout());
                    button.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
                    button.add((Component)registerLink);
                    this.installFocusable((JComponent)button, register, 38, 39, true);
                    NonOpaquePanel wrap = new NonOpaquePanel();
                    wrap.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                    wrap.add((Component)button);
                    panel2.add((Component)wrap, "West");
                    registeredVisible = true;
                }
            }
            toolbar.setLayout((LayoutManager)new BoxLayout((Container)toolbar, 0));
            toolbar.add((Component)this.createEventsLink());
            toolbar.add((Component)this.createActionLink("Configure", "WelcomeScreen.Configure", AllIcons.General.GearPlain, !registeredVisible));
            toolbar.add((Component)this.createActionLink("Get Help", "WelcomeScreen.Documentation", null, false));
            panel2.add((Component)toolbar, "East");
            panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)8, (int)11));
            return panel2;
        }

        private JComponent createEventsLink() {
            Ref actionLinkRef = new Ref();
            JComponent panel2 = this.createActionLink("Events", AllIcons.Ide.Notification.NoEvents, (Ref<ActionLink>)actionLinkRef, new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ((WelcomeBalloonLayoutImpl)FlatWelcomeFrame.this.myBalloonLayout).showPopup();
                }
            });
            panel2.setVisible(false);
            this.myEventListener = types -> {
                NotificationType type2 = null;
                for (NotificationType t : types) {
                    if (NotificationType.ERROR == t) {
                        type2 = NotificationType.ERROR;
                        break;
                    }
                    if (NotificationType.WARNING == t) {
                        type2 = NotificationType.WARNING;
                        continue;
                    }
                    if (type2 != null || NotificationType.INFORMATION != t) continue;
                    type2 = NotificationType.INFORMATION;
                }
                if (types.isEmpty()) {
                    panel2.setVisible(false);
                } else {
                    ((ActionLink)actionLinkRef.get()).setIcon((Icon)IdeNotificationArea.createIconWithNotificationCount((JComponent)actionLinkRef.get(), type2, types.size()));
                    panel2.setVisible(true);
                }
            };
            this.myEventLocation = () -> {
                Point location = SwingUtilities.convertPoint(panel2, 0, 0, this.getRootPane().getLayeredPane());
                return new Point(location.x, location.y + 5);
            };
            return panel2;
        }

        private JComponent createActionLink(String text, final String groupId, Icon icon, boolean focusListOnLeft) {
            final Ref ref = new Ref(null);
            AnAction action = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ActionGroup configureGroup = (ActionGroup)ActionManager.getInstance().getAction(groupId);
                    PopupFactoryImpl.ActionGroupPopup popup = (PopupFactoryImpl.ActionGroupPopup)JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new IconsFreeActionGroup(configureGroup), e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, "WelcomeScreen");
                    popup.showUnderneathOfLabel((JLabel)ref.get());
                    UsageTrigger.trigger("welcome.screen." + groupId);
                }
            };
            JComponent panel2 = this.createActionLink(text, icon, (Ref<ActionLink>)ref, action);
            this.installFocusable(panel2, action, 38, 40, focusListOnLeft);
            return panel2;
        }

        private JComponent createActionLink(String text, Icon icon, Ref<ActionLink> ref, AnAction action) {
            ActionLink link = new ActionLink(text, icon, action);
            ref.set((Object)link);
            link.setFocusable(false);
            link.setPaintUnderline(false);
            link.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
            JActionLinkPanel panel2 = new JActionLinkPanel(link);
            panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)6, (int)4, (int)6));
            panel2.add((Component)FlatWelcomeFrame.createArrow(link), "East");
            return panel2;
        }

        private JComponent createActionPanel() {
            NonOpaquePanel actions = new NonOpaquePanel();
            actions.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
            actions.setLayout(new BoxLayout((Container)actions, 1));
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup quickStart = (ActionGroup)actionManager.getAction("WelcomeScreen.QuickStart");
            DefaultActionGroup group = new DefaultActionGroup();
            this.collectAllActions(group, quickStart);
            for (AnAction action : group.getChildren(null)) {
                Icon icon;
                AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext((Component)this));
                action.update(e);
                Presentation presentation = e.getPresentation();
                if (!presentation.isVisible()) continue;
                String text = presentation.getText();
                if (text != null && text.endsWith("...")) {
                    text = text.substring(0, text.length() - 3);
                }
                if ((icon = presentation.getIcon()).getIconHeight() != JBUI.scale((int)16) || icon.getIconWidth() != JBUI.scale((int)16)) {
                    icon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16));
                }
                action = this.wrapGroups(action);
                ActionLink link = new ActionLink(text, icon, action, FlatWelcomeFrame.createUsageTracker(action));
                link.setFocusable(false);
                link.setPaintUnderline(false);
                link.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
                JActionLinkPanel button = new JActionLinkPanel(link);
                button.setBorder((Border)JBUI.Borders.empty((int)8, (int)20));
                if (action instanceof WelcomePopupAction) {
                    button.add((Component)FlatWelcomeFrame.createArrow(link), "East");
                }
                this.installFocusable(button, action, 38, 40, true);
                actions.add(button);
            }
            Component verticalSpacer = Box.createVerticalStrut(25);
            actions.add(verticalSpacer);
            WelcomeScreenActionsPanel panel2 = new WelcomeScreenActionsPanel();
            panel2.actions.add((Component)actions);
            panel2.root.setMinimumSize(panel2.actions.getMinimumSize());
            return panel2.root;
        }

        private AnAction wrapGroups(AnAction action) {
            if (action instanceof ActionGroup && ((ActionGroup)action).isPopup()) {
                Pair<JPanel, JBList> panel2 = FlatWelcomeFrame.createActionGroupPanel((ActionGroup)action, (JComponent)this.mySlidingPanel, () -> this.goBack(), (Disposable)this);
                final Runnable onDone = () -> {
                    ListSelectionListener[] listeners;
                    FlatWelcomeFrame.this.setTitle("New Project");
                    JBList list = (JBList)panel2.second;
                    ScrollingUtil.ensureSelectionExists((JList)list);
                    for (ListSelectionListener listener2 : listeners = (ListSelectionListener[])((DefaultListSelectionModel)list.getSelectionModel()).getListeners(ListSelectionListener.class)) {
                        listener2.valueChanged(new ListSelectionEvent(list, list.getSelectedIndex(), list.getSelectedIndex(), true));
                    }
                    JComponent toFocus = FlatWelcomeFrame.getPreferredFocusedComponent(panel2);
                    if (toFocus != null) {
                        toFocus.requestFocus();
                    }
                };
                final String name = action.getClass().getName();
                this.mySlidingPanel.add(name, (Component)panel2.first);
                Presentation p = action.getTemplatePresentation();
                return new DumbAwareAction(p.getText(), p.getDescription(), p.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        FlatWelcomeScreen.this.mySlidingPanel.getLayout().swipe((Container)FlatWelcomeScreen.this.mySlidingPanel, name, JBCardLayout.SwipeDirection.FORWARD, onDone);
                    }
                };
            }
            return action;
        }

        protected void goBack() {
            this.mySlidingPanel.swipe("root", JBCardLayout.SwipeDirection.BACKWARD).doWhenDone(() -> {
                this.mySlidingPanel.getRootPane().setDefaultButton(null);
                FlatWelcomeFrame.this.setTitle(FlatWelcomeFrame.this.getWelcomeFrameTitle());
            });
        }

        private void collectAllActions(DefaultActionGroup group, ActionGroup actionGroup) {
            for (AnAction action : actionGroup.getChildren(null)) {
                if (action instanceof ActionGroup && !((ActionGroup)action).isPopup()) {
                    this.collectAllActions(group, (ActionGroup)action);
                    continue;
                }
                group.add(action);
            }
        }

        private JComponent createLogo() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            ApplicationInfoEx app = ApplicationInfoEx.getInstanceEx();
            JLabel logo = new JLabel(IconLoader.getIcon((String)app.getWelcomeScreenLogoUrl()));
            logo.setBorder((Border)JBUI.Borders.empty((int)30, (int)0, (int)10, (int)0));
            logo.setHorizontalAlignment(0);
            panel2.add((Component)logo, (Object)"North");
            JLabel appName = new JLabel(ApplicationNamesInfo.getInstance().getFullProductName());
            Font font = this.getProductFont();
            appName.setForeground(JBColor.foreground());
            appName.setFont(font.deriveFont(JBUI.scale((float)36.0f)).deriveFont(0));
            appName.setHorizontalAlignment(0);
            String appVersion = "Version ";
            appVersion = appVersion + app.getFullVersion();
            if (app.isEAP() && !app.getBuild().isSnapshot()) {
                appVersion = appVersion + " (" + app.getBuild().asStringWithoutProductCode() + ")";
            }
            JLabel version = new JLabel(appVersion);
            version.setFont(this.getProductFont().deriveFont(JBUI.scale((float)16.0f)));
            version.setHorizontalAlignment(0);
            version.setForeground((Color)Gray._128);
            panel2.add((Component)appName);
            panel2.add((Component)version, (Object)"South");
            panel2.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
            return panel2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Font getProductFont() {
            String name = "/fonts/Roboto-Light.ttf";
            URL url = AppUIUtil.class.getResource(name);
            if (url == null) {
                Logger.getInstance(AppUIUtil.class).warn("Resource missing: " + name);
            } else {
                Font font;
                InputStream is = url.openStream();
                try {
                    font = Font.createFont(0, is);
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        Logger.getInstance(AppUIUtil.class).warn("Cannot load font: " + url, t);
                    }
                }
                is.close();
                return font;
            }
            return UIUtil.getLabelFont();
        }

        private JComponent createRecentProjects() {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new NewRecentProjectPanel((Disposable)this), "Center");
            panel2.setBackground(FlatWelcomeFrame.getProjectsBackground());
            panel2.setBorder((Border)new CustomLineBorder((Color)FlatWelcomeFrame.getSeparatorColor(), (Insets)JBUI.insetsRight((int)1)));
            return panel2;
        }

        private void installFocusable(final JComponent comp, final AnAction action, final int prevKeyCode, final int nextKeyCode, final boolean focusListOnLeft) {
            comp.setFocusable(true);
            comp.setFocusTraversalKeysEnabled(true);
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JList list = (JList)UIUtil.findComponentOfType((JComponent)FlatWelcomeFrame.this.getComponent(), JList.class);
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        ActionLink link;
                        InputEvent event = e;
                        if (e.getComponent() instanceof JComponent && (link = (ActionLink)UIUtil.findComponentOfType((JComponent)((JComponent)e.getComponent()), ActionLink.class)) != null) {
                            event = new MouseEvent((Component)link, 500, e.getWhen(), e.getModifiers(), 0, 0, 1, false, 1);
                        }
                        action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)event, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext()));
                    } else if (e.getKeyCode() == prevKeyCode) {
                        FlatWelcomeScreen.this.focusPrev(comp);
                    } else if (e.getKeyCode() == nextKeyCode) {
                        FlatWelcomeScreen.this.focusNext(comp);
                    } else if (e.getKeyCode() == 37) {
                        if (focusListOnLeft) {
                            if (list != null) {
                                list.requestFocus();
                            }
                        } else {
                            FlatWelcomeScreen.this.focusPrev(comp);
                        }
                    } else if (e.getKeyCode() == 39) {
                        FlatWelcomeScreen.this.focusNext(comp);
                    }
                }
            });
            comp.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    comp.setOpaque(true);
                    comp.setBackground(FlatWelcomeFrame.getActionLinkSelectionColor());
                }

                @Override
                public void focusLost(FocusEvent e) {
                    comp.setOpaque(false);
                    comp.setBackground(FlatWelcomeFrame.getMainBackground());
                }
            });
        }

        protected void focusPrev(JComponent comp) {
            Component prev;
            FocusTraversalPolicy policy = FlatWelcomeFrame.this.getFocusTraversalPolicy();
            if (policy != null && (prev = policy.getComponentBefore(FlatWelcomeFrame.this, comp)) != null) {
                prev.requestFocus();
            }
        }

        protected void focusNext(JComponent comp) {
            Component next;
            FocusTraversalPolicy policy = FlatWelcomeFrame.this.getFocusTraversalPolicy();
            if (policy != null && (next = policy.getComponentAfter(FlatWelcomeFrame.this, comp)) != null) {
                next.requestFocus();
            }
        }

        public void setupFrame(JFrame frame) {
        }

        public void dispose() {
        }

        private class IconsFreeActionGroup
        extends ActionGroup {
            private final ActionGroup myGroup;

            public IconsFreeActionGroup(ActionGroup group) {
                super(group.getTemplatePresentation().getText(), group.getTemplatePresentation().getDescription(), null);
                this.myGroup = group;
            }

            public boolean isPopup() {
                return this.myGroup.isPopup();
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] children2 = this.myGroup.getChildren(e);
                AnAction[] patched = new AnAction[children2.length];
                for (int i2 = 0; i2 < children2.length; ++i2) {
                    patched[i2] = this.patch(children2[i2]);
                }
                return patched;
            }

            private AnAction patch(final AnAction child) {
                if (child instanceof ActionGroup) {
                    return new IconsFreeActionGroup((ActionGroup)child);
                }
                Presentation presentation = child.getTemplatePresentation();
                return new AnAction(presentation.getText(), presentation.getDescription(), null){

                    public boolean startInTransaction() {
                        return child.startInTransaction();
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        child.actionPerformed(e);
                        UsageTrigger.trigger("welcome.screen." + e.getActionManager().getId(child));
                    }

                    public void update(@NotNull AnActionEvent e) {
                        child.update(e);
                        e.getPresentation().setIcon(null);
                    }

                    public boolean isDumbAware() {
                        return child.isDumbAware();
                    }
                };
            }
        }

        protected class JActionLinkPanel
        extends JPanel {
            @NotNull
            private ActionLink myActionLink;

            public JActionLinkPanel(ActionLink actionLink) {
                super(new BorderLayout());
                this.myActionLink = actionLink;
                this.add((Component)this.myActionLink);
                NonOpaquePanel.setTransparent((JComponent)this);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleJActionLinkPanel(this.myActionLink.getAccessibleContext());
                }
                return this.accessibleContext;
            }

            protected class AccessibleJActionLinkPanel
            extends AccessibleContextDelegate {
                public AccessibleJActionLinkPanel(AccessibleContext context) {
                    super(context);
                }

                public Accessible getAccessibleParent() {
                    if (JActionLinkPanel.this.getParent() instanceof Accessible) {
                        return (Accessible)((Object)JActionLinkPanel.this.getParent());
                    }
                    return super.getAccessibleParent();
                }

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PUSH_BUTTON;
                }
            }
        }
    }
}

