/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.NotificationBalloonShadowBorderProvider;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WelcomeBalloonLayoutImpl
extends BalloonLayoutImpl {
    private static final String TYPE_KEY = "Type";
    private final java.util.function.Consumer<List<NotificationType>> myListener;
    private final Computable<Point> myButtonLocation;
    private BalloonImpl myPopupBalloon;
    private final BalloonPanel myBalloonPanel = new BalloonPanel();
    private boolean myVisible;

    public WelcomeBalloonLayoutImpl(@NotNull JRootPane parent, @NotNull Insets insets, @NotNull java.util.function.Consumer<List<NotificationType>> listener2, @NotNull Computable<Point> buttonLocation) {
        super(parent, insets);
        this.myListener = listener2;
        this.myButtonLocation = buttonLocation;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myPopupBalloon != null) {
            Disposer.dispose((Disposable)this.myPopupBalloon);
            this.myPopupBalloon = null;
        }
    }

    @Override
    public void add(@NotNull Balloon balloon, @Nullable Object layoutData) {
        if (layoutData instanceof BalloonLayoutData && ((BalloonLayoutData)layoutData).welcomeScreen) {
            this.addToPopup((BalloonImpl)balloon, (BalloonLayoutData)layoutData);
        } else {
            super.add(balloon, layoutData);
        }
    }

    private void addToPopup(final @NotNull BalloonImpl balloon, @NotNull BalloonLayoutData layoutData) {
        balloon.traceDispose(false);
        layoutData.doLayout = this::layoutPopup;
        layoutData.configuration = layoutData.configuration.replace(JBUI.scale((int)(this.myPopupBalloon == null ? 7 : 5)), JBUI.scale((int)12));
        if (this.myPopupBalloon == null) {
            final JScrollPane pane = NotificationsManagerImpl.createBalloonScrollPane((Component)((Object)this.myBalloonPanel), true);
            pane.setHorizontalScrollBarPolicy(31);
            pane.setVerticalScrollBarPolicy(20);
            pane.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    pane.setBorder(IdeBorderFactory.createEmptyBorder((int)(SystemInfo.isMac ? 2 : 1), (int)0, (int)1, (int)1));
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    pane.setBorder(IdeBorderFactory.createEmptyBorder());
                }
            });
            this.myPopupBalloon = new BalloonImpl(pane, NotificationsManagerImpl.BORDER_COLOR, new Insets(0, 0, 0, 0), NotificationsManagerImpl.FILL_COLOR, true, false, false, true, false, true, 0L, false, false, null, false, 0, 0, 0, 0, false, null, null, false, false, false, null, false, null, -1);
            this.myPopupBalloon.setAnimationEnabled(false);
            this.myPopupBalloon.setShadowBorderProvider(new NotificationBalloonShadowBorderProvider(NotificationsManagerImpl.FILL_COLOR, NotificationsManagerImpl.BORDER_COLOR));
            this.myPopupBalloon.setHideListener(() -> this.myPopupBalloon.getComponent().setVisible(false));
            this.myPopupBalloon.setActionProvider(new BalloonImpl.ActionProvider(){
                private BalloonImpl.ActionButton myAction;

                @Override
                @NotNull
                public List<BalloonImpl.ActionButton> createActions() {
                    BalloonImpl balloonImpl = WelcomeBalloonLayoutImpl.this.myPopupBalloon;
                    balloonImpl.getClass();
                    this.myAction = balloonImpl.new BalloonImpl.ActionButton(AllIcons.Ide.Notification.Close, null, null, (Consumer<MouseEvent>)Consumer.EMPTY_CONSUMER);
                    return Collections.singletonList(this.myAction);
                }

                @Override
                public void layout(@NotNull Rectangle bounds) {
                    this.myAction.setBounds(0, 0, 0, 0);
                }
            });
        }
        this.myBalloonPanel.add(balloon.getContent());
        balloon.getContent().putClientProperty(TYPE_KEY, layoutData.type);
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                WelcomeBalloonLayoutImpl.this.myBalloons.remove(balloon);
                WelcomeBalloonLayoutImpl.this.myBalloonPanel.remove(balloon.getContent());
                WelcomeBalloonLayoutImpl.this.updatePopup();
            }
        });
        this.myBalloons.add(balloon);
        this.updatePopup();
    }

    public void showPopup() {
        this.layoutPopup();
        if (this.myVisible) {
            this.myPopupBalloon.getComponent().setVisible(true);
        } else {
            this.myPopupBalloon.show(this.myLayeredPane);
            this.myVisible = true;
        }
    }

    @Override
    public void queueRelayout() {
        if (this.myVisible) {
            this.layoutPopup();
        }
    }

    private void layoutPopup() {
        Dimension layeredSize = this.myLayeredPane.getSize();
        Dimension size = new Dimension(this.myPopupBalloon.getPreferredSize());
        Point location = (Point)this.myButtonLocation.compute();
        int x = layeredSize.width - size.width - 5;
        int fullHeight = location.y;
        if (x > location.x) {
            x = location.x - 20;
        }
        if (size.height > fullHeight) {
            size.height = fullHeight;
        }
        this.myPopupBalloon.setBounds(new Rectangle(x, fullHeight - size.height, size.width, size.height));
    }

    private void updatePopup() {
        int count = this.myBalloonPanel.getComponentCount();
        ArrayList<NotificationType> types = new ArrayList<NotificationType>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            types.add((NotificationType)((JComponent)this.myBalloonPanel.getComponent(i2)).getClientProperty(TYPE_KEY));
        }
        this.myListener.accept(types);
        if (this.myVisible) {
            if (count == 0) {
                this.myPopupBalloon.getComponent().setVisible(false);
            } else {
                this.layoutPopup();
            }
        }
    }

    private static class BalloonPanel
    extends NonOpaquePanel {
        public BalloonPanel() {
            super((LayoutManager)new AbstractLayoutManager(){

                public Dimension preferredLayoutSize(Container parent) {
                    int count = parent.getComponentCount();
                    int width = 0;
                    int height = 0;
                    for (int i2 = 0; i2 < count; ++i2) {
                        Dimension size = parent.getComponent(i2).getPreferredSize();
                        width = Math.max(width, size.width);
                        height += size.height;
                    }
                    return new Dimension(width + JBUI.scale((int)32), height += count - 1);
                }

                public void layoutContainer(Container parent) {
                    int count = parent.getComponentCount();
                    int width = parent.getWidth() - JBUI.scale((int)32);
                    int height = parent.getHeight();
                    if (count == 1) {
                        parent.getComponent(0).setBounds(JBUI.scale((int)16), 0, width, height);
                    } else {
                        int y = 0;
                        for (int i2 = 0; i2 < count; ++i2) {
                            Component component = parent.getComponent(i2);
                            Dimension size = component.getPreferredSize();
                            component.setBounds(JBUI.scale((int)16), y, width, size.height);
                            y += size.height + JBUI.scale((int)2);
                        }
                    }
                }
            });
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int count = this.getComponentCount() - 1;
            if (count > 0) {
                int x2 = this.getWidth() - JBUI.scale((int)16);
                int y = 0;
                g.setColor((Color)new JBColor(0xD0D0D0, 7435125));
                for (int i2 = 0; i2 < count; ++i2) {
                    Dimension size = this.getComponent(i2).getPreferredSize();
                    g.drawLine(JBUI.scale((int)16), y += size.height + 1, x2, y);
                }
            }
        }
    }
}

