/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeListsScopesProvider
extends CustomScopesProviderEx {
    @NotNull
    private final Project myProject;

    public static ChangeListsScopesProvider getInstance(Project project2) {
        return (ChangeListsScopesProvider)((Object)Extensions.findExtension((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)project2, ChangeListsScopesProvider.class));
    }

    public ChangeListsScopesProvider(@NotNull Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public List<NamedScope> getCustomScopes() {
        if (this.myProject.isDefault() || !ProjectLevelVcsManager.getInstance((Project)this.myProject).hasAnyMappings()) {
            return Collections.emptyList();
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        ArrayList<NamedScope> result2 = new ArrayList<NamedScope>();
        result2.add(ChangeListsScopesProvider.createScope(changeListManager.getAffectedFiles(), IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0])));
        for (ChangeList list : changeListManager.getChangeListsCopy()) {
            result2.add(ChangeListsScopesProvider.createChangeListScope(list));
        }
        return result2;
    }

    private static NamedScope createChangeListScope(@NotNull ChangeList list) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        Collection changes = list.getChanges();
        for (Change change : changes) {
            VirtualFile vFile;
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null || (vFile = afterRevision.getFile().getVirtualFile()) == null) continue;
            files.add(vFile);
        }
        return ChangeListsScopesProvider.createScope(files, list.getName());
    }

    public NamedScope getCustomScope(@NotNull String name) {
        if (this.myProject.isDefault()) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        if (IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0]).equals(name)) {
            return ChangeListsScopesProvider.createScope(changeListManager.getAffectedFiles(), IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0]));
        }
        LocalChangeList changeList = changeListManager.findChangeList(name);
        if (changeList != null) {
            return ChangeListsScopesProvider.createChangeListScope((ChangeList)changeList);
        }
        return null;
    }

    public boolean isVetoed(NamedScope scope, CustomScopesProviderEx.ScopePlace place) {
        if (place == CustomScopesProviderEx.ScopePlace.SETTING) {
            if (this.myProject.isDefault()) {
                return false;
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            return changeListManager.findChangeList(scope.getName()) != null;
        }
        return false;
    }

    @NotNull
    private static NamedScope createScope(final @NotNull List<VirtualFile> files, @NotNull String changeListName) {
        return new NamedScope(changeListName, (PackageSet)new PackageSetBase(){

            public boolean contains(VirtualFile file2, NamedScopesHolder holder) {
                return files.contains(file2);
            }

            @NotNull
            public PackageSet createCopy() {
                return this;
            }

            @NotNull
            public String getText() {
                return "file:*//*";
            }

            public int getNodePriority() {
                return 0;
            }
        }){

            public boolean equals(Object obj) {
                if (!(obj instanceof NamedScope)) {
                    return false;
                }
                return this.getName().equals(((NamedScope)obj).getName());
            }

            public int hashCode() {
                return this.getName().hashCode();
            }
        };
    }
}

