/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.FindDependencyUtil;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.UsagesPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

public class DependenciesUsagesPanel
extends UsagesPanel {
    private final List<DependenciesBuilder> myBuilders;

    public DependenciesUsagesPanel(Project project2, List<DependenciesBuilder> builders) {
        super(project2);
        this.myBuilders = builders;
        this.setToInitialPosition();
    }

    @Override
    public String getInitialPositionText() {
        return this.myBuilders.get(0).getInitialUsagesPosition();
    }

    @Override
    public String getCodeUsagesString() {
        return this.myBuilders.get(0).getRootNodeNameInUsageView();
    }

    public void findUsages(Set<PsiFile> searchIn, Set<PsiFile> searchFor) {
        this.cancelCurrentFindRequest();
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PanelProgressIndicator progress = new PanelProgressIndicator((Consumer<JComponent>)((Consumer)component -> this.setToComponent((JComponent)component)));
            this.myCurrentProgress = progress;
            ProgressManager.getInstance().runProcess(() -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    UsageInfo[] usages = UsageInfo.EMPTY_ARRAY;
                    Set elementsToSearch = null;
                    try {
                        if (this.myBuilders.get(0).isBackward()) {
                            elementsToSearch = searchIn;
                            usages = FindDependencyUtil.findBackwardDependencies(this.myBuilders, searchFor, searchIn);
                        } else {
                            elementsToSearch = searchFor;
                            usages = FindDependencyUtil.findDependencies(this.myBuilders, searchIn, searchFor);
                        }
                        assert (!new HashSet(elementsToSearch).contains(null));
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                    if (!progress.isCanceled()) {
                        UsageInfo[] finalUsages = usages;
                        PsiElement[] _elementsToSearch = elementsToSearch != null ? PsiUtilCore.toPsiElementArray((Collection)elementsToSearch) : PsiElement.EMPTY_ARRAY;
                        ApplicationManager.getApplication().invokeLater(() -> this.showUsages(_elementsToSearch, finalUsages), ModalityState.stateForComponent((Component)this));
                    }
                });
                this.myCurrentProgress = null;
            }, (ProgressIndicator)progress);
        }), 300);
    }

    public void addBuilder(DependenciesBuilder builder) {
        this.myBuilders.add(builder);
    }
}

