/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactImpl;
import com.intellij.packaging.impl.artifacts.ArtifactLoadingErrorDescription;
import com.intellij.packaging.impl.artifacts.ArtifactManagerStateSplitter;
import com.intellij.packaging.impl.artifacts.ArtifactModelBase;
import com.intellij.packaging.impl.artifacts.ArtifactModelImpl;
import com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactVirtualFileListener;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.UnknownPackagingElementTypeException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.artifact.ArtifactManagerState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactPropertiesState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

@State(name="ArtifactManager", storages={@Storage(value="artifacts", stateSplitter=ArtifactManagerStateSplitter.class)})
public class ArtifactManagerImpl
extends ArtifactManager
implements ProjectComponent,
PersistentStateComponent<ArtifactManagerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.artifacts.ArtifactManagerImpl");
    @NonNls
    public static final String COMPONENT_NAME = "ArtifactManager";
    @NonNls
    public static final String PACKAGING_ELEMENT_NAME = "element";
    @NonNls
    public static final String TYPE_ID_ATTRIBUTE = "id";
    private final ArtifactManagerModel myModel;
    private final Project myProject;
    private final DefaultPackagingElementResolvingContext myResolvingContext;
    private boolean myInsideCommit = false;
    private boolean myLoaded;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    private final Map<String, LocalFileSystem.WatchRequest> myWatchedOutputs = new HashMap<String, LocalFileSystem.WatchRequest>();

    public ArtifactManagerImpl(Project project2) {
        this.myProject = project2;
        this.myModel = new ArtifactManagerModel();
        this.myResolvingContext = new DefaultPackagingElementResolvingContext(this.myProject);
        ((ArtifactPointerManagerImpl)ArtifactPointerManager.getInstance((Project)project2)).setArtifactManager(this);
    }

    @NotNull
    public Artifact[] getArtifacts() {
        return this.myModel.getArtifacts();
    }

    public Artifact findArtifact(@NotNull String name) {
        return this.myModel.findArtifact(name);
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        return this.myModel.getArtifactByOriginal(artifact);
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        return this.myModel.getOriginalArtifact(artifact);
    }

    @NotNull
    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type2) {
        return this.myModel.getArtifactsByType(type2);
    }

    public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
        return this.myModel.getAllArtifactsIncludingInvalid();
    }

    public ArtifactManagerState getState() {
        ArtifactManagerState state = new ArtifactManagerState();
        for (Artifact artifact : this.getAllArtifactsIncludingInvalid()) {
            ArtifactState artifactState;
            if (artifact instanceof InvalidArtifact) {
                artifactState = ((InvalidArtifact)artifact).getState();
            } else {
                artifactState = new ArtifactState();
                artifactState.setBuildOnMake(artifact.isBuildOnMake());
                artifactState.setName(artifact.getName());
                artifactState.setOutputPath(artifact.getOutputPath());
                artifactState.setRootElement(ArtifactManagerImpl.serializePackagingElement(artifact.getRootElement()));
                artifactState.setArtifactType(artifact.getArtifactType().getId());
                for (ArtifactPropertiesProvider provider2 : artifact.getPropertiesProviders()) {
                    ArtifactPropertiesState propertiesState = ArtifactManagerImpl.serializeProperties(provider2, artifact.getProperties(provider2));
                    if (propertiesState == null) continue;
                    artifactState.getPropertiesList().add(propertiesState);
                }
                Collections.sort(artifactState.getPropertiesList(), Comparator.comparing(ArtifactPropertiesState::getId));
            }
            state.getArtifacts().add(artifactState);
        }
        return state;
    }

    @Nullable
    private static <S> ArtifactPropertiesState serializeProperties(ArtifactPropertiesProvider provider2, ArtifactProperties<S> properties) {
        ArtifactPropertiesState state = new ArtifactPropertiesState();
        state.setId(provider2.getId());
        Element options = new Element("options");
        XmlSerializer.serializeInto((Object)properties.getState(), (Element)options, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (options.getContent().isEmpty() && options.getAttributes().isEmpty()) {
            return null;
        }
        state.setOptions(options);
        return state;
    }

    private static Element serializePackagingElement(PackagingElement<?> packagingElement) {
        Element element = new Element(PACKAGING_ELEMENT_NAME);
        element.setAttribute(TYPE_ID_ATTRIBUTE, packagingElement.getType().getId());
        Object bean = packagingElement.getState();
        if (bean != null) {
            XmlSerializer.serializeInto((Object)bean, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
        if (packagingElement instanceof CompositePackagingElement) {
            for (PackagingElement child : ((CompositePackagingElement)packagingElement).getChildren()) {
                element.addContent(ArtifactManagerImpl.serializePackagingElement(child));
            }
        }
        return element;
    }

    private <T> PackagingElement<T> deserializeElement(Element element) throws UnknownPackagingElementTypeException {
        String id = element.getAttributeValue(TYPE_ID_ATTRIBUTE);
        PackagingElementType type2 = PackagingElementFactory.getInstance().findElementType(id);
        if (type2 == null) {
            throw new UnknownPackagingElementTypeException(id);
        }
        PackagingElement packagingElement = type2.createEmpty(this.myProject);
        Object state = packagingElement.getState();
        if (state != null) {
            XmlSerializer.deserializeInto((Object)state, (Element)element);
            packagingElement.loadState(state);
        }
        List children2 = element.getChildren(PACKAGING_ELEMENT_NAME);
        for (Element child : children2) {
            ((CompositePackagingElement)packagingElement).addOrFindChild(this.deserializeElement(child));
        }
        return packagingElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(ArtifactManagerState managerState) {
        List artifactStates = managerState.getArtifacts();
        ArrayList<ArtifactImpl> artifacts = new ArrayList<ArtifactImpl>(artifactStates.size());
        if (!artifactStates.isEmpty()) {
            AccessToken token = ReadAction.start();
            try {
                for (ArtifactState state : artifactStates) {
                    artifacts.add(this.loadArtifact(state));
                }
            }
            finally {
                token.finish();
            }
        }
        if (this.myLoaded) {
            ArtifactModelImpl model = new ArtifactModelImpl(this, artifacts);
            this.doCommit(model);
        } else {
            this.myModel.setArtifactsList(artifacts);
            this.myLoaded = true;
        }
    }

    private ArtifactImpl loadArtifact(ArtifactState state) {
        CompositePackagingElement rootElement;
        ArtifactType type2 = ArtifactType.findById((String)state.getArtifactType());
        if (type2 == null) {
            return this.createInvalidArtifact(state, "Unknown artifact type: " + state.getArtifactType());
        }
        Element element = state.getRootElement();
        String artifactName = state.getName();
        if (element != null) {
            try {
                rootElement = (CompositePackagingElement)this.deserializeElement(element);
            }
            catch (UnknownPackagingElementTypeException e) {
                return this.createInvalidArtifact(state, "Unknown element: " + e.getTypeId());
            }
        } else {
            rootElement = type2.createRootElement(artifactName);
        }
        ArtifactImpl artifact = new ArtifactImpl(artifactName, type2, state.isBuildOnMake(), rootElement, state.getOutputPath());
        List propertiesList = state.getPropertiesList();
        for (ArtifactPropertiesState propertiesState : propertiesList) {
            ArtifactPropertiesProvider provider2 = ArtifactPropertiesProvider.findById((String)propertiesState.getId());
            if (provider2 != null) {
                ArtifactManagerImpl.deserializeProperties(artifact.getProperties(provider2), propertiesState);
                continue;
            }
            return this.createInvalidArtifact(state, "Unknown artifact properties: " + propertiesState.getId());
        }
        return artifact;
    }

    private InvalidArtifact createInvalidArtifact(ArtifactState state, String errorMessage) {
        InvalidArtifact artifact = new InvalidArtifact(state, errorMessage);
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerError(new ArtifactLoadingErrorDescription(this.myProject, artifact));
        UnknownFeaturesCollector.getInstance(this.myProject).registerUnknownFeature("com.intellij.packaging.artifacts.ArtifactType", state.getArtifactType(), "Artifact");
        return artifact;
    }

    private static <S> void deserializeProperties(ArtifactProperties<S> artifactProperties, ArtifactPropertiesState propertiesState) {
        Element options = propertiesState.getOptions();
        if (artifactProperties == null || options == null) {
            return;
        }
        Object state = artifactProperties.getState();
        if (state != null) {
            XmlSerializer.deserializeInto((Object)state, (Element)options);
            artifactProperties.loadState(state);
        }
    }

    public void disposeComponent() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedOutputs.values());
    }

    @NotNull
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public void initComponent() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new ArtifactVirtualFileListener(this.myProject, this), (Disposable)this.myProject);
        this.updateWatchedRoots();
    }

    private void updateWatchedRoots() {
        HashSet<String> pathsToRemove = new HashSet<String>(this.myWatchedOutputs.keySet());
        HashSet<String> toAdd = new HashSet<String>();
        for (Artifact artifact : this.getArtifacts()) {
            String path = artifact.getOutputPath();
            if (path == null || path.length() <= 0) continue;
            pathsToRemove.remove(path);
            if (this.myWatchedOutputs.containsKey(path)) continue;
            toAdd.add(path);
        }
        ArrayList requestsToRemove = new ArrayList();
        for (String path : pathsToRemove) {
            LocalFileSystem.WatchRequest request = this.myWatchedOutputs.remove(path);
            ContainerUtil.addIfNotNull(requestsToRemove, (Object)request);
        }
        Set newRequests = LocalFileSystem.getInstance().replaceWatchedRoots(requestsToRemove, toAdd, null);
        for (LocalFileSystem.WatchRequest request : newRequests) {
            this.myWatchedOutputs.put(request.getRootPath(), request);
        }
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public Artifact[] getSortedArtifacts() {
        return this.myModel.getSortedArtifacts();
    }

    public ModifiableArtifactModel createModifiableModel() {
        return new ArtifactModelImpl(this, this.getArtifactsList());
    }

    public PackagingElementResolvingContext getResolvingContext() {
        return this.myResolvingContext;
    }

    public List<ArtifactImpl> getArtifactsList() {
        return this.myModel.myArtifactsList;
    }

    public void commit(ArtifactModelImpl artifactModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doCommit(artifactModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(ArtifactModelImpl artifactModel) {
        boolean hasChanges;
        LOG.assertTrue(!this.myInsideCommit, (Object)"Recursive commit");
        this.myInsideCommit = true;
        try {
            List<ArtifactImpl> allArtifacts = artifactModel.getOriginalArtifacts();
            THashSet removed = new THashSet((Collection)this.myModel.myArtifactsList);
            ArrayList<ArtifactImpl> added = new ArrayList<ArtifactImpl>();
            ArrayList<Pair> changed = new ArrayList<Pair>();
            for (ArtifactImpl artifact : allArtifacts) {
                boolean isAdded = !removed.remove((Object)artifact);
                ArtifactImpl modifiableCopy = artifactModel.getModifiableCopy((Artifact)artifact);
                if (isAdded) {
                    added.add(artifact);
                    continue;
                }
                if (modifiableCopy == null || ((Object)((Object)modifiableCopy)).equals((Object)artifact)) continue;
                String oldName = artifact.getName();
                artifact.copyFrom(modifiableCopy);
                changed.add(Pair.create((Object)((Object)artifact), (Object)oldName));
            }
            this.myModel.setArtifactsList(allArtifacts);
            this.myModificationTracker.incModificationCount();
            ArtifactListener publisher = (ArtifactListener)this.myProject.getMessageBus().syncPublisher(TOPIC);
            hasChanges = !removed.isEmpty() || !added.isEmpty() || !changed.isEmpty();
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> ArtifactManagerImpl.lambda$doCommit$0((Set)removed, publisher, added, changed));
        }
        finally {
            this.myInsideCommit = false;
        }
        this.updateWatchedRoots();
        if (hasChanges) {
            BuildManager.getInstance().clearState(this.myProject);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Artifact addArtifact(final @NotNull String name, final @NotNull ArtifactType type2, final CompositePackagingElement<?> root) {
        return (Artifact)new WriteAction<Artifact>(){

            protected void run(@NotNull Result<Artifact> result2) {
                ModifiableArtifactModel model = ArtifactManagerImpl.this.createModifiableModel();
                ModifiableArtifact artifact = model.addArtifact(name, type2);
                if (root != null) {
                    artifact.setRootElement(root);
                }
                model.commit();
                result2.setResult((Object)artifact);
            }
        }.execute().getResultObject();
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String relativePath, @NotNull PackagingElement<?> element) {
        this.addElementsToDirectory(artifact, relativePath, Collections.singletonList(element));
    }

    public void addElementsToDirectory(@NotNull Artifact artifact, @NotNull String relativePath, @NotNull Collection<? extends PackagingElement<?>> elements) {
        final ModifiableArtifactModel model = this.createModifiableModel();
        CompositePackagingElement root = model.getOrCreateModifiableArtifact(artifact).getRootElement();
        PackagingElementFactory.getInstance().getOrCreateDirectory(root, relativePath).addOrFindChildren(elements);
        new WriteAction(){

            protected void run(@NotNull Result result2) {
                model.commit();
            }
        }.execute();
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    private static /* synthetic */ void lambda$doCommit$0(Set removed, ArtifactListener publisher, List added, List changed) {
        for (ArtifactImpl artifact : removed) {
            publisher.artifactRemoved((Artifact)artifact);
        }
        for (ArtifactImpl artifact : added) {
            publisher.artifactAdded((Artifact)artifact);
        }
        for (Pair pair : changed) {
            publisher.artifactChanged((Artifact)pair.getFirst(), (String)pair.getSecond());
        }
    }

    private static class ArtifactManagerModel
    extends ArtifactModelBase {
        private List<ArtifactImpl> myArtifactsList = new ArrayList<ArtifactImpl>();
        private Artifact[] mySortedArtifacts;

        private ArtifactManagerModel() {
        }

        public void setArtifactsList(List<ArtifactImpl> artifactsList) {
            this.myArtifactsList = artifactsList;
            this.artifactsChanged();
        }

        @Override
        protected void artifactsChanged() {
            super.artifactsChanged();
            this.mySortedArtifacts = null;
        }

        @Override
        protected List<? extends Artifact> getArtifactsList() {
            return this.myArtifactsList;
        }

        public Artifact[] getSortedArtifacts() {
            if (this.mySortedArtifacts == null) {
                this.mySortedArtifacts = (Artifact[])this.getArtifacts().clone();
                Arrays.sort(this.mySortedArtifacts, ArtifactManager.ARTIFACT_COMPARATOR);
            }
            return this.mySortedArtifacts;
        }
    }
}

