/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.util.Condition;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ArtifactModelBase
implements ArtifactModel {
    private Map<String, Artifact> myArtifactsMap;
    private Artifact[] myArtifactsArray;
    public static final Condition<Artifact> VALID_ARTIFACT_CONDITION = artifact -> !(artifact instanceof InvalidArtifact);

    protected abstract List<? extends Artifact> getArtifactsList();

    @NotNull
    public Artifact[] getArtifacts() {
        if (this.myArtifactsArray == null) {
            List validArtifacts = ContainerUtil.findAll(this.getArtifactsList(), VALID_ARTIFACT_CONDITION);
            this.myArtifactsArray = validArtifacts.toArray(new Artifact[validArtifacts.size()]);
        }
        return this.myArtifactsArray;
    }

    public List<? extends Artifact> getAllArtifactsIncludingInvalid() {
        return Collections.unmodifiableList(this.getArtifactsList());
    }

    public Artifact findArtifact(@NotNull String name) {
        if (this.myArtifactsMap == null) {
            this.myArtifactsMap = new HashMap<String, Artifact>();
            for (Artifact artifact : this.getArtifactsList()) {
                this.myArtifactsMap.put(artifact.getName(), artifact);
            }
        }
        return this.myArtifactsMap.get(name);
    }

    @NotNull
    public Artifact getArtifactByOriginal(@NotNull Artifact artifact) {
        return artifact;
    }

    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        return artifact;
    }

    @NotNull
    public Collection<? extends Artifact> getArtifactsByType(@NotNull ArtifactType type2) {
        ArrayList<Artifact> result2 = new ArrayList<Artifact>();
        for (Artifact artifact : this.getArtifacts()) {
            if (!artifact.getArtifactType().equals(type2)) continue;
            result2.add(artifact);
        }
        return result2;
    }

    protected void artifactsChanged() {
        this.myArtifactsMap = null;
        this.myArtifactsArray = null;
    }
}

