/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactImpl;
import com.intellij.packaging.impl.artifacts.ArtifactManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactModelBase;
import com.intellij.packaging.impl.artifacts.ArtifactPointerManagerImpl;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactModelImpl
extends ArtifactModelBase
implements ModifiableArtifactModel {
    private final List<ArtifactImpl> myOriginalArtifacts;
    private final ArtifactManagerImpl myArtifactManager;
    private final Map<ArtifactImpl, ArtifactImpl> myArtifact2ModifiableCopy = new HashMap<ArtifactImpl, ArtifactImpl>();
    private final Map<ArtifactImpl, ArtifactImpl> myModifiable2Original = new HashMap<ArtifactImpl, ArtifactImpl>();
    private final EventDispatcher<ArtifactListener> myDispatcher = EventDispatcher.create(ArtifactListener.class);

    public ArtifactModelImpl(ArtifactManagerImpl artifactManager, List<ArtifactImpl> originalArtifacts) {
        this.myArtifactManager = artifactManager;
        this.myOriginalArtifacts = new ArrayList<ArtifactImpl>(originalArtifacts);
        this.addListener((ArtifactListener)new ArtifactAdapter(){

            public void artifactChanged(@NotNull Artifact artifact, @NotNull String oldName) {
                ArtifactModelImpl.this.artifactsChanged();
            }
        });
    }

    @Override
    protected List<? extends Artifact> getArtifactsList() {
        ArrayList<ArtifactImpl> list = new ArrayList<ArtifactImpl>();
        for (ArtifactImpl artifact : this.myOriginalArtifacts) {
            ArtifactImpl copy = this.myArtifact2ModifiableCopy.get((Object)artifact);
            if (copy != null) {
                list.add(copy);
                continue;
            }
            list.add(artifact);
        }
        return list;
    }

    @NotNull
    public ModifiableArtifact addArtifact(@NotNull String name, @NotNull ArtifactType artifactType) {
        return this.addArtifact(name, artifactType, artifactType.createRootElement(name));
    }

    @NotNull
    public ModifiableArtifact addArtifact(@NotNull String name, @NotNull ArtifactType artifactType, CompositePackagingElement<?> rootElement) {
        String uniqueName = this.generateUniqueName(name);
        String outputPath = ArtifactUtil.getDefaultArtifactOutputPath(uniqueName, this.myArtifactManager.getProject());
        ArtifactImpl artifact = new ArtifactImpl(uniqueName, artifactType, false, rootElement, outputPath, this.myDispatcher);
        this.myOriginalArtifacts.add(artifact);
        this.myArtifact2ModifiableCopy.put(artifact, artifact);
        this.myModifiable2Original.put(artifact, artifact);
        this.artifactsChanged();
        ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactAdded((Artifact)artifact);
        return artifact;
    }

    private String generateUniqueName(String baseName) {
        String name = baseName;
        int i2 = 2;
        while (this.findArtifact(name) != null) {
            name = baseName + i2++;
        }
        return name;
    }

    public void addListener(@NotNull ArtifactListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeListener(@NotNull ArtifactListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeArtifact(@NotNull Artifact artifact) {
        ArtifactImpl artifactImpl = (ArtifactImpl)artifact;
        ArtifactImpl original = this.myModifiable2Original.remove((Object)artifactImpl);
        if (original != null) {
            this.myOriginalArtifacts.remove((Object)original);
        } else {
            original = artifactImpl;
        }
        this.myArtifact2ModifiableCopy.remove((Object)original);
        this.myOriginalArtifacts.remove((Object)original);
        this.artifactsChanged();
        ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactRemoved((Artifact)original);
    }

    @NotNull
    public ModifiableArtifact getOrCreateModifiableArtifact(@NotNull Artifact artifact) {
        ArtifactImpl artifactImpl = (ArtifactImpl)artifact;
        if (this.myModifiable2Original.containsKey((Object)artifactImpl)) {
            return artifactImpl;
        }
        ArtifactImpl modifiableCopy = this.myArtifact2ModifiableCopy.get((Object)artifactImpl);
        if (modifiableCopy == null) {
            modifiableCopy = artifactImpl.createCopy(this.myDispatcher);
            ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged((Artifact)modifiableCopy, artifact.getName());
            this.myArtifact2ModifiableCopy.put(artifactImpl, modifiableCopy);
            this.myModifiable2Original.put(modifiableCopy, artifactImpl);
            this.artifactsChanged();
        }
        return modifiableCopy;
    }

    @Override
    @NotNull
    public Artifact getOriginalArtifact(@NotNull Artifact artifact) {
        ArtifactImpl original = this.myModifiable2Original.get(artifact);
        return original != null ? original : artifact;
    }

    @NotNull
    public ArtifactImpl getArtifactByOriginal(@NotNull Artifact artifact) {
        ArtifactImpl artifactImpl = (ArtifactImpl)artifact;
        ArtifactImpl copy = this.myArtifact2ModifiableCopy.get((Object)artifactImpl);
        return copy != null ? copy : artifactImpl;
    }

    public boolean isModified() {
        return !this.myOriginalArtifacts.equals(this.myArtifactManager.getArtifactsList()) || !this.myArtifact2ModifiableCopy.isEmpty();
    }

    public void commit() {
        this.myArtifactManager.commit(this);
    }

    public void dispose() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (ArtifactImpl artifact : this.myModifiable2Original.keySet()) {
            if (!((Object)((Object)this.myModifiable2Original.get((Object)artifact))).equals((Object)artifact)) continue;
            artifacts.add((Artifact)artifact);
        }
        ((ArtifactPointerManagerImpl)ArtifactPointerManager.getInstance((Project)this.myArtifactManager.getProject())).disposePointers(artifacts);
    }

    @Nullable
    public ArtifactImpl getModifiableCopy(Artifact artifact) {
        return this.myArtifact2ModifiableCopy.get(artifact);
    }

    public List<ArtifactImpl> getOriginalArtifacts() {
        return this.myOriginalArtifacts;
    }
}

