/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactPointer;
import org.jetbrains.annotations.NotNull;

public class ArtifactPointerImpl
implements ArtifactPointer {
    private String myName;
    private Artifact myArtifact;

    public ArtifactPointerImpl(@NotNull String name) {
        this.myName = name;
    }

    public ArtifactPointerImpl(@NotNull Artifact artifact) {
        this.myArtifact = artifact;
        this.myName = artifact.getName();
    }

    @NotNull
    public String getArtifactName() {
        return this.myName;
    }

    public Artifact getArtifact() {
        return this.myArtifact;
    }

    @NotNull
    public String getArtifactName(@NotNull ArtifactModel artifactModel) {
        if (this.myArtifact != null) {
            return artifactModel.getArtifactByOriginal(this.myArtifact).getName();
        }
        return this.myName;
    }

    public Artifact findArtifact(@NotNull ArtifactModel artifactModel) {
        if (this.myArtifact != null) {
            return artifactModel.getArtifactByOriginal(this.myArtifact);
        }
        return artifactModel.findArtifact(this.myName);
    }

    void setArtifact(Artifact artifact) {
        this.myArtifact = artifact;
    }

    void setName(String name) {
        this.myName = name;
    }
}

