/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElementBase;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleOutputElementTypeBase<E extends ModuleOutputPackagingElementBase>
extends PackagingElementType<E> {
    public ModuleOutputElementTypeBase(String id, String presentableName) {
        super(id, presentableName);
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        return !this.getSuitableModules(context).isEmpty();
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        List<Module> suitableModules = this.getSuitableModules(context);
        List selected = context.chooseModules(suitableModules, ProjectBundle.message((String)"dialog.title.packaging.choose.module", (Object[])new Object[0]));
        ArrayList<ModuleOutputPackagingElementBase> elements = new ArrayList<ModuleOutputPackagingElementBase>();
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)context.getProject());
        for (Module module2 : selected) {
            elements.add(this.createElement(context.getProject(), pointerManager.create(module2)));
        }
        return elements;
    }

    protected abstract ModuleOutputPackagingElementBase createElement(@NotNull Project var1, @NotNull ModulePointer var2);

    private List<Module> getSuitableModules(ArtifactEditorContext context) {
        ModulesProvider modulesProvider = context.getModulesProvider();
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module2 : modulesProvider.getModules()) {
            if (!this.isSuitableModule(modulesProvider, module2)) continue;
            modules.add(module2);
        }
        return modules;
    }

    public abstract boolean isSuitableModule(ModulesProvider var1, Module var2);
}

