/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTask;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProviderBase;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BuildArtifactsBeforeRunTaskProvider
extends BuildArtifactsBeforeRunTaskProviderBase<BuildArtifactsBeforeRunTask> {
    @NonNls
    public static final String BUILD_ARTIFACTS_ID = "BuildArtifacts";
    public static final Key<BuildArtifactsBeforeRunTask> ID = Key.create((String)"BuildArtifacts");

    public BuildArtifactsBeforeRunTaskProvider(Project project2) {
        super(BuildArtifactsBeforeRunTask.class, project2);
    }

    public Key<BuildArtifactsBeforeRunTask> getId() {
        return ID;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public String getName() {
        return CompilerBundle.message((String)"build.artifacts.before.run.description.empty", (Object[])new Object[0]);
    }

    public Icon getTaskIcon(BuildArtifactsBeforeRunTask task) {
        List<ArtifactPointer> pointers = task.getArtifactPointers();
        if (pointers == null || pointers.isEmpty()) {
            return this.getIcon();
        }
        Artifact artifact = pointers.get(0).getArtifact();
        if (artifact == null) {
            return this.getIcon();
        }
        return artifact.getArtifactType().getIcon();
    }

    public String getDescription(BuildArtifactsBeforeRunTask task) {
        List<ArtifactPointer> pointers = task.getArtifactPointers();
        if (pointers.isEmpty()) {
            return CompilerBundle.message((String)"build.artifacts.before.run.description.empty", (Object[])new Object[0]);
        }
        if (pointers.size() == 1) {
            return CompilerBundle.message((String)"build.artifacts.before.run.description.single", (Object[])new Object[]{pointers.get(0).getArtifactName()});
        }
        return CompilerBundle.message((String)"build.artifacts.before.run.description.multiple", (Object[])new Object[]{pointers.size()});
    }

    public static void setBuildArtifactBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, Project project2, @NotNull Artifact artifact, boolean enable) {
        BeforeRunTaskProvider provider2 = BuildArtifactsBeforeRunTaskProvider.getProvider((Project)project2, ID);
        if (provider2 != null) {
            ((BuildArtifactsBeforeRunTaskProvider)provider2).setBuildArtifactBeforeRunOption(runConfigurationEditorComponent, artifact, enable);
        }
    }

    public static void setBuildArtifactBeforeRun(@NotNull Project project2, @NotNull RunConfiguration configuration, @NotNull Artifact artifact) {
        RunManagerEx runManager = RunManagerEx.getInstanceEx(project2);
        List<BuildArtifactsBeforeRunTask> buildArtifactsTasks = runManager.getBeforeRunTasks(configuration, ID);
        if (buildArtifactsTasks.isEmpty()) {
            BuildArtifactsBeforeRunTask task = new BuildArtifactsBeforeRunTask(project2);
            buildArtifactsTasks.add(task);
            List<BeforeRunTask> tasks = runManager.getBeforeRunTasks(configuration);
            tasks.add(task);
            runManager.setBeforeRunTasks(configuration, tasks, false);
        }
        for (BuildArtifactsBeforeRunTask task : buildArtifactsTasks) {
            task.setEnabled(true);
            task.addArtifact(artifact);
        }
    }

    @Override
    protected BuildArtifactsBeforeRunTask doCreateTask(Project project2) {
        return new BuildArtifactsBeforeRunTask(project2);
    }

    @Override
    protected CompileScope createCompileScope(Project project2, List<Artifact> artifacts) {
        return ArtifactCompileScope.createArtifactsScope(project2, artifacts);
    }
}

