/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.run.ArtifactChooser;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskBase;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class BuildArtifactsBeforeRunTaskProviderBase<T extends BuildArtifactsBeforeRunTaskBase>
extends BeforeRunTaskProvider<T> {
    private final Project myProject;
    @NotNull
    private final Class<T> myTaskClass;

    public BuildArtifactsBeforeRunTaskProviderBase(@NotNull Class<T> taskClass, Project project2) {
        this.myProject = project2;
        this.myTaskClass = taskClass;
        project2.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactAdapter(){

            public void artifactRemoved(@NotNull Artifact artifact) {
                RunManagerEx runManager = RunManagerEx.getInstanceEx(BuildArtifactsBeforeRunTaskProviderBase.this.myProject);
                for (RunConfiguration configuration : runManager.getAllConfigurationsList()) {
                    List tasks = runManager.getBeforeRunTasks(configuration, BuildArtifactsBeforeRunTaskProviderBase.this.getId());
                    for (BuildArtifactsBeforeRunTaskBase task : tasks) {
                        ArtifactPointer[] pointers;
                        String artifactName = artifact.getName();
                        List<ArtifactPointer> pointersList = task.getArtifactPointers();
                        for (ArtifactPointer pointer : pointers = pointersList.toArray(new ArtifactPointer[pointersList.size()])) {
                            if (!pointer.getArtifactName().equals(artifactName) || ArtifactManager.getInstance((Project)BuildArtifactsBeforeRunTaskProviderBase.this.myProject).findArtifact(artifactName) != null) continue;
                            task.removeArtifact(pointer);
                        }
                    }
                }
            }
        });
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(RunConfiguration runConfiguration, T task) {
        Artifact[] artifacts = ArtifactManager.getInstance((Project)this.myProject).getArtifacts();
        THashSet pointers = new THashSet();
        for (Artifact artifact : artifacts) {
            pointers.add(ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact));
        }
        pointers.addAll(((BuildArtifactsBeforeRunTaskBase)((Object)task)).getArtifactPointers());
        ArtifactChooser chooser = new ArtifactChooser(new ArrayList<ArtifactPointer>((Collection<ArtifactPointer>)pointers));
        chooser.markElements(((BuildArtifactsBeforeRunTaskBase)((Object)task)).getArtifactPointers());
        chooser.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(CompilerBundle.message((String)"build.artifacts.before.run.selector.title", (Object[])new Object[0]));
        builder.setDimensionServiceKey("#BuildArtifactsBeforeRunChooser");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)chooser);
        builder.setPreferredFocusComponent((JComponent)chooser);
        if (builder.show() == 0) {
            ((BuildArtifactsBeforeRunTaskBase)((Object)task)).setArtifactPointers(chooser.getMarkedElements());
            return true;
        }
        return false;
    }

    public T createTask(RunConfiguration runConfiguration) {
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.doCreateTask(this.myProject);
    }

    public boolean canExecuteTask(RunConfiguration configuration, T task) {
        for (ArtifactPointer pointer : ((BuildArtifactsBeforeRunTaskBase)((Object)task)).getArtifactPointers()) {
            if (pointer.getArtifact() == null) continue;
            return true;
        }
        return false;
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, T task) {
        final Ref result2 = Ref.create((Object)false);
        final Semaphore finished2 = new Semaphore();
        ArrayList artifacts = new ArrayList();
        new ReadAction((BuildArtifactsBeforeRunTaskBase)((Object)task), artifacts){
            final /* synthetic */ BuildArtifactsBeforeRunTaskBase val$task;
            final /* synthetic */ List val$artifacts;
            {
                this.val$task = buildArtifactsBeforeRunTaskBase;
                this.val$artifacts = list;
            }

            protected void run(@NotNull Result result2) {
                List<ArtifactPointer> pointers = this.val$task.getArtifactPointers();
                for (ArtifactPointer pointer : pointers) {
                    ContainerUtil.addIfNotNull((Object)pointer.getArtifact(), (Collection)this.val$artifacts);
                }
            }
        }.execute();
        CompileStatusNotification callback = new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                result2.set((Object)(!aborted && errors == 0 ? 1 : 0));
                finished2.up();
            }
        };
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
            CompileScope scope = this.createCompileScope(this.myProject, artifacts);
            ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)env));
            finished2.down();
            manager.make(scope, CompilerFilter.ALL, callback);
        }, ModalityState.NON_MODAL);
        finished2.waitFor();
        return (Boolean)result2.get();
    }

    protected void setBuildArtifactBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, @NotNull Artifact artifact, boolean enable) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)runConfigurationEditorComponent);
        ConfigurationSettingsEditorWrapper editor = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
        if (editor != null) {
            List tasks = ContainerUtil.findAll(editor.getStepsBeforeLaunch(), this.myTaskClass);
            if (enable && tasks.isEmpty()) {
                T task = this.doCreateTask(this.myProject);
                ((BuildArtifactsBeforeRunTaskBase)((Object)task)).addArtifact(artifact);
                task.setEnabled(true);
                editor.addBeforeLaunchStep((BeforeRunTask<?>)task);
            } else {
                for (BuildArtifactsBeforeRunTaskBase task : tasks) {
                    if (enable) {
                        task.addArtifact(artifact);
                        task.setEnabled(true);
                        continue;
                    }
                    task.removeArtifact(artifact);
                    if (!task.getArtifactPointers().isEmpty()) continue;
                    task.setEnabled(false);
                }
            }
        }
    }

    protected abstract T doCreateTask(Project var1);

    protected abstract CompileScope createCompileScope(Project var1, List<Artifact> var2);
}

