/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

public class DirectoryCopyPresentation
extends PackagingElementPresentation {
    private final String mySourcePath;
    private final String mySourceFileName;
    private final VirtualFile myFile;

    public DirectoryCopyPresentation(String filePath) {
        VirtualFile parent;
        this.mySourceFileName = PathUtil.getFileName((String)filePath);
        this.myFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        String parentPath = this.myFile != null ? ((parent = this.myFile.getParent()) != null ? FileUtil.toSystemDependentName((String)parent.getPath()) : "") : FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)filePath));
        this.mySourcePath = parentPath;
    }

    public String getPresentableName() {
        return this.mySourceFileName;
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        presentationData.setIcon(AllIcons.Nodes.CopyOfFolder);
        if (this.myFile == null || !this.myFile.isDirectory()) {
            mainAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            VirtualFile parentFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.mySourcePath));
            if (parentFile == null) {
                commentAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            }
        }
        presentationData.addText(CompilerBundle.message((String)"node.text.0.directory.content", (Object[])new Object[]{this.mySourceFileName}), mainAttributes);
        presentationData.addText(" (" + this.mySourcePath + ")", commentAttributes);
    }

    public int getWeight() {
        return 40;
    }
}

