/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackageFileAction
extends AnAction {
    private static final SyncDateFormat TIME_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("h:mm:ss a"));

    public PackageFileAction() {
        super(CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]), CompilerBundle.message((String)"action.description.package.file", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent e) {
        List<VirtualFile> files;
        boolean visible = false;
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 != null && !(files = PackageFileAction.getFilesToPackage(e, project2)).isEmpty()) {
            visible = true;
            e.getPresentation().setText(files.size() == 1 ? CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]) : CompilerBundle.message((String)"action.name.package.files", (Object[])new Object[0]));
        }
        e.getPresentation().setVisible(visible);
    }

    @NotNull
    private static List<VirtualFile> getFilesToPackage(@NotNull AnActionEvent e, @NotNull Project project2) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        block0: for (VirtualFile file2 : files) {
            if (file2 == null || file2.isDirectory() || fileIndex.isUnderSourceRootOfType(file2, JavaModuleSourceRootTypes.SOURCES) && compilerManager.isCompilableFileType(file2.getFileType())) {
                return Collections.emptyList();
            }
            Collection<? extends Artifact> artifacts = ArtifactBySourceFileFinder.getInstance(project2).findArtifacts(file2);
            for (Artifact artifact : artifacts) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                result2.add(file2);
                continue block0;
            }
        }
        return result2;
    }

    public void actionPerformed(AnActionEvent event) {
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> files = PackageFileAction.getFilesToPackage(event, project2);
        Artifact[] allArtifacts = ArtifactManager.getInstance((Project)project2).getArtifacts();
        PackageFileWorker.startPackagingFiles(project2, files, allArtifacts, () -> PackageFileAction.setStatusText(project2, files));
    }

    private static void setStatusText(Project project2, List<VirtualFile> files) {
        if (!files.isEmpty()) {
            StringBuilder fileNames = new StringBuilder();
            for (VirtualFile file2 : files) {
                if (fileNames.length() != 0) {
                    fileNames.append(", ");
                }
                fileNames.append("'").append(file2.getName()).append("'");
            }
            String time = TIME_FORMAT.format(Clock.getTime());
            String statusText = CompilerBundle.message((String)"status.text.file.has.been.packaged", (Object[])new Object[]{files.size(), fileNames, time});
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
            if (statusBar != null) {
                statusBar.setInfo(statusText);
            }
        }
    }
}

