/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns.compiler;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.patterns.compiler.PatternClassBean;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.patterns.compiler.PatternCompilerFactory;
import com.intellij.patterns.compiler.PatternCompilerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PatternCompilerFactoryImpl
extends PatternCompilerFactory {
    public static final ExtensionPointName<PatternClassBean> PATTERN_CLASS_EP = new ExtensionPointName("com.intellij.patterns.patternClass");
    private final Map<String, Class[]> myClasses = new ConcurrentFactoryMap<String, Class[]>(){

        protected Class[] create(String key2) {
            ArrayList<Class> result2 = new ArrayList<Class>(1);
            List<String> typeList = key2 == null ? null : Arrays.asList(key2.split(",|\\s"));
            for (PatternClassBean bean : (PatternClassBean[])PATTERN_CLASS_EP.getExtensions()) {
                if (typeList != null && !typeList.contains(bean.getAlias())) continue;
                result2.add(bean.getPatternClass());
            }
            return result2.isEmpty() ? ArrayUtil.EMPTY_CLASS_ARRAY : result2.toArray(new Class[result2.size()]);
        }
    };
    private final Map<List<Class>, PatternCompiler> myCompilers = new ConcurrentFactoryMap<List<Class>, PatternCompiler>(){

        protected PatternCompiler create(List<Class> key2) {
            return new PatternCompilerImpl(key2);
        }
    };

    @NotNull
    public Class[] getPatternClasses(String alias) {
        return this.myClasses.get(alias);
    }

    @NotNull
    public <T> PatternCompiler<T> getPatternCompiler(@NotNull Class[] patternClasses) {
        return this.myCompilers.get(Arrays.asList(patternClasses));
    }
}

