/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PlatformProjectViewStructureProvider
implements TreeStructureProvider,
DumbAware {
    private final Project myProject;

    public PlatformProjectViewStructureProvider(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
        VirtualFile vFile;
        if (parent instanceof PsiDirectoryNode && (vFile = ((PsiDirectoryNode)parent).getVirtualFile()) != null && Comparing.equal((Object)ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getContentRootForFile(vFile), (Object)vFile)) {
            Collection<AbstractTreeNode> moduleChildren = ((PsiDirectoryNode)parent).getChildren();
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            for (AbstractTreeNode moduleChild : moduleChildren) {
                PsiDirectory value2;
                if (moduleChild instanceof PsiDirectoryNode && (value2 = (PsiDirectory)((PsiDirectoryNode)moduleChild).getValue()).getName().equals(".idea") && Registry.is((String)"projectView.hide.dot.idea")) continue;
                result2.add(moduleChild);
            }
            return result2;
        }
        return children2;
    }
}

