/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.renameProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameProjectHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + RenameProjectHandler.class.getName()));

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return RenameProjectHandler.isAvailable(dataContext);
    }

    static boolean isAvailable(DataContext dataContext) {
        Module module2 = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        return module2 != null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.project.handler.title");
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        LOG.error("Project renaming should be never invoked from file");
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        LOG.assertTrue(project2 instanceof ProjectEx);
        Module module2 = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        LOG.assertTrue(module2 != null);
        Messages.showInputDialog((Project)project2, (String)RefactoringBundle.message((String)"enter.new.project.name"), (String)RefactoringBundle.message((String)"rename.project"), (Icon)Messages.getQuestionIcon(), (String)module2.getName(), (InputValidator)new MyInputValidator((ProjectEx)project2, module2));
    }

    public static boolean renameProject(@NotNull ProjectEx project2, @Nullable Module module2, String newName) {
        if (RenameProjectHandler.shouldRenameProject(project2, module2, newName)) {
            project2.setProjectName(newName);
            project2.save();
        }
        if (module2 != null && !newName.equals(module2.getName())) {
            ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
            try {
                modifiableModel.renameModule(module2, newName);
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                Messages.showErrorDialog((Project)project2, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{newName}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return false;
            }
            Ref success = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand((Project)project2, () -> ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit()), IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{module2.getName()}), null);
            return (Boolean)success.get();
        }
        return true;
    }

    private static boolean shouldRenameProject(@NotNull Project project2, @Nullable Module module2, String inputString) {
        if (inputString.equals(project2.getName())) {
            return false;
        }
        if (module2 == null) {
            return true;
        }
        if (ProjectAttachProcessor.canAttachToProject()) {
            return module2 == ModuleAttachProcessor.getPrimaryModule(project2);
        }
        return module2 == ModuleAttachProcessor.findModuleInBaseDir(project2);
    }

    protected static class MyInputValidator
    implements InputValidator {
        private final ProjectEx myProject;
        @Nullable
        private final Module myModule;

        public MyInputValidator(ProjectEx project2, @Nullable Module module2) {
            this.myProject = project2;
            this.myModule = module2;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && inputString.length() > 0;
        }

        public boolean canClose(String inputString) {
            return RenameProjectHandler.renameProject(this.myProject, this.myModule, inputString);
        }
    }
}

