/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.util.JdomKt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalArchivedTemplate
extends ArchivedProjectTemplate {
    public static final String DESCRIPTION_PATH = ".idea/description.html";
    static final String TEMPLATE_DESCRIPTOR = ".idea/project-template.xml";
    static final String TEMPLATE_META_XML = "template-meta.xml";
    static final String META_TEMPLATE_DESCRIPTOR_PATH = ".idea/template-meta.xml";
    public static final String UNENCODED_ATTRIBUTE = "unencoded";
    static final String ROOT_FILE_NAME = "root";
    private final URL myArchivePath;
    private final ModuleType myModuleType;
    @Nullable
    private final List<RootDescription> myModuleDescriptions;
    private boolean myEscaped = true;
    private Icon myIcon;

    public LocalArchivedTemplate(@NotNull URL archivePath, @NotNull ClassLoader classLoader) {
        super(LocalArchivedTemplate.getTemplateName(archivePath), null);
        String meta;
        this.myArchivePath = archivePath;
        this.myModuleType = LocalArchivedTemplate.computeModuleType(this);
        String s = this.readEntry(TEMPLATE_DESCRIPTOR);
        if (s != null) {
            try {
                Element templateElement = JdomKt.loadElement((CharSequence)s);
                this.populateFromElement(templateElement);
                String iconPath = templateElement.getChildText("icon-path");
                if (iconPath != null) {
                    this.myIcon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((meta = this.readEntry(META_TEMPLATE_DESCRIPTOR_PATH)) != null) {
            try {
                Element templateElement = JdomKt.loadElement((CharSequence)meta);
                String unencoded = templateElement.getAttributeValue(UNENCODED_ATTRIBUTE);
                if (unencoded != null) {
                    this.myEscaped = Boolean.valueOf(unencoded) == false;
                }
                this.myModuleDescriptions = RootDescription.readRoots(templateElement);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.myModuleDescriptions = null;
        }
    }

    public ValidationResult validate(@NotNull String baseDirPath) {
        if (this.myModuleDescriptions != null && !this.myModuleDescriptions.isEmpty()) {
            File baseDirFile = new File(baseDirPath);
            for (RootDescription description : this.myModuleDescriptions) {
                File rootFile = new File(baseDirFile + "/" + description.myRelativePath);
                try {
                    if (!(rootFile = rootFile.getCanonicalFile()).exists()) continue;
                    String[] list = rootFile.list();
                    if (list == null) {
                        return new ValidationResult("<html>File '" + rootFile.getAbsolutePath() + "' already exists, so project root can't be created</html>");
                    }
                    if (list.length <= 0) continue;
                    return new ValidationResult("<html>Directory '" + rootFile.getAbsolutePath() + "' already exists and is not empty, so project root can't be created</html>");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    private static String getTemplateName(URL url) {
        String fileName = new File(url.getPath()).getName();
        return fileName.substring(0, fileName.length() - ".zip".length()).replace('_', ' ');
    }

    public String getDescription() {
        return this.readEntry(DESCRIPTION_PATH);
    }

    @Override
    public Icon getIcon() {
        return this.myIcon == null ? super.getIcon() : this.myIcon;
    }

    public boolean isEscaped() {
        return this.myEscaped;
    }

    @Nullable
    String readEntry(final @NotNull String endsWith) {
        try {
            return this.processStream(new ArchivedProjectTemplate.StreamProcessor<String>(){

                @Override
                public String consume(@NotNull ZipInputStream stream) throws IOException {
                    ZipEntry entry;
                    while ((entry = stream.getNextEntry()) != null) {
                        if (!entry.getName().endsWith(endsWith)) continue;
                        return StreamUtil.readText((InputStream)stream, (Charset)CharsetToolkit.UTF8_CHARSET);
                    }
                    return null;
                }
            });
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @NotNull
    private static ModuleType computeModuleType(LocalArchivedTemplate template) {
        String iml = template.readEntry(".iml");
        if (iml == null) {
            return ModuleType.EMPTY;
        }
        try {
            String type2 = JdomKt.loadElement((CharSequence)iml).getAttributeValue("type");
            return ModuleTypeManager.getInstance().findByID(type2);
        }
        catch (Exception e) {
            return ModuleType.EMPTY;
        }
    }

    @Override
    protected ModuleType getModuleType() {
        return this.myModuleType;
    }

    @Override
    public <T> T processStream(@NotNull ArchivedProjectTemplate.StreamProcessor<T> consumer2) throws IOException {
        return LocalArchivedTemplate.consumeZipStream(consumer2, new ZipInputStream(this.myArchivePath.openStream()));
    }

    public URL getArchivePath() {
        return this.myArchivePath;
    }

    @Override
    public void handleUnzippedDirectories(File dir, List<File> filesToRefresh) throws IOException {
        if (this.myModuleDescriptions == null) {
            filesToRefresh.add(dir);
            return;
        }
        for (RootDescription description : this.myModuleDescriptions) {
            File root = new File(dir, ROOT_FILE_NAME + description.myIndex);
            File target = new File(dir.getAbsolutePath() + "/" + description.myRelativePath);
            target.mkdirs();
            FileUtil.copyDir((File)root, (File)target);
            FileUtil.delete((File)root);
            filesToRefresh.add(target);
        }
    }

    static class RootDescription {
        private static final String ROOTS_ELEMENT = "roots";
        private static final String ROOT_ELEMENT = "root";
        private static final String INDEX_ATTRIBUTE = "index";
        private static final String PATH_ATTRIBUTE = "path";
        final VirtualFile myFile;
        final String myRelativePath;
        final int myIndex;

        public RootDescription(VirtualFile file2, String path, int index) {
            this.myFile = file2;
            this.myRelativePath = path;
            this.myIndex = index;
        }

        private void write(Element parent) {
            Element rootChild = new Element("root");
            rootChild.setAttribute(INDEX_ATTRIBUTE, String.valueOf(this.myIndex));
            rootChild.setAttribute(PATH_ATTRIBUTE, this.myRelativePath);
            parent.addContent(rootChild);
        }

        private static List<RootDescription> read(Element parent) {
            List children2 = parent.getChildren("root");
            ArrayList<RootDescription> result2 = new ArrayList<RootDescription>(children2.size());
            for (Element child : children2) {
                int index = Integer.parseInt(child.getAttributeValue(INDEX_ATTRIBUTE));
                String path = child.getAttributeValue(PATH_ATTRIBUTE);
                result2.add(index, new RootDescription(null, path, index));
            }
            return result2;
        }

        static void writeRoots(Element element, List<RootDescription> rootDescriptions) {
            Element rootsElement = new Element(ROOTS_ELEMENT);
            for (RootDescription description : rootDescriptions) {
                description.write(rootsElement);
            }
            element.addContent(rootsElement);
        }

        @Nullable
        static List<RootDescription> readRoots(Element element) {
            Element modulesElement = element.getChild(ROOTS_ELEMENT);
            if (modulesElement != null) {
                return RootDescription.read(modulesElement);
            }
            return null;
        }
    }
}

