/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.CommonBundle;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ManageProjectTemplatesDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final JBList myTemplatesList;
    private final JTextPane myDescriptionPane;

    ManageProjectTemplatesDialog() {
        super(false);
        this.setTitle("Manage Project Templates");
        ProjectTemplate[] templates = new ArchivedTemplatesFactory().createTemplates("User-defined", new WizardContext(null, this.getDisposable()));
        this.myTemplatesList = new JBList((ListModel)new CollectionListModel<ProjectTemplate>(Arrays.asList(templates)){

            public void remove(int index) {
                ProjectTemplate template = (ProjectTemplate)this.getElementAt(index);
                super.remove(index);
                if (template instanceof LocalArchivedTemplate) {
                    FileUtil.delete((File)new File(((LocalArchivedTemplate)template).getArchivePath().getPath()));
                }
            }
        });
        this.myTemplatesList.setEmptyText("No user-defined project templates");
        this.myTemplatesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
                this.append(((ProjectTemplate)value2).getName());
            }
        });
        this.myTemplatesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTemplate template = ManageProjectTemplatesDialog.this.getSelectedTemplate();
                ManageProjectTemplatesDialog.this.myDescriptionPane.setText(template == null ? null : template.getDescription());
            }
        });
        this.myPanel = new JPanel(new BorderLayout(0, 5));
        JPanel panel2 = ToolbarDecorator.createDecorator((JList)this.myTemplatesList).disableUpDownActions().createPanel();
        panel2.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
        this.myPanel.add(panel2);
        this.myDescriptionPane = new JTextPane();
        this.myDescriptionPane.setPreferredSize((Dimension)JBUI.size((int)300, (int)50));
        Messages.installHyperlinkSupport((JTextPane)this.myDescriptionPane);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myDescriptionPane, (int)22, (int)30), "South");
        if (templates.length > 0) {
            this.myTemplatesList.setSelectedValue((Object)templates[0], true);
        }
        this.init();
    }

    @Nullable
    private ProjectTemplate getSelectedTemplate() {
        return (ProjectTemplate)this.myTemplatesList.getSelectedValue();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{new DialogWrapper.DialogWrapperAction(CommonBundle.getCloseButtonText()){

            protected void doAction(ActionEvent e) {
                ManageProjectTemplatesDialog.this.doCancelAction();
            }
        }};
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTemplatesList;
    }
}

