/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.JdomKt;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteTemplatesFactory
extends ProjectTemplatesFactory {
    private static final Logger LOG = Logger.getInstance(RemoteTemplatesFactory.class);
    private static final String URL = "http://download.jetbrains.com/idea/project_templates/";
    private final ClearableLazyValue<MultiMap<String, ArchivedProjectTemplate>> myTemplates = new ClearableLazyValue<MultiMap<String, ArchivedProjectTemplate>>(){

        @NotNull
        protected MultiMap<String, ArchivedProjectTemplate> compute() {
            try {
                return (MultiMap)HttpRequests.request((String)(RemoteTemplatesFactory.URL + ApplicationInfo.getInstance().getBuild().getProductCode() + "_templates.xml")).connect(request -> {
                    try {
                        return RemoteTemplatesFactory.create(JdomKt.loadElement((Reader)request.getReader()));
                    }
                    catch (JDOMException e) {
                        LOG.error((Throwable)e);
                        return MultiMap.emptyInstance();
                    }
                });
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return MultiMap.emptyInstance();
        }
    };

    @Override
    @NotNull
    public String[] getGroups() {
        this.myTemplates.drop();
        return ArrayUtil.toStringArray((Collection)((MultiMap)this.myTemplates.getValue()).keySet());
    }

    @Override
    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        Collection templates = ((MultiMap)this.myTemplates.getValue()).get((Object)group);
        return templates.isEmpty() ? ProjectTemplate.EMPTY_ARRAY : templates.toArray(new ProjectTemplate[templates.size()]);
    }

    @NotNull
    public static MultiMap<String, ArchivedProjectTemplate> createFromText(@NotNull String value2) throws IOException, JDOMException {
        return RemoteTemplatesFactory.create(JdomKt.loadElement((CharSequence)value2));
    }

    @NotNull
    private static MultiMap<String, ArchivedProjectTemplate> create(@NotNull Element element) throws IOException, JDOMException {
        MultiMap map2 = MultiMap.create();
        for (ArchivedProjectTemplate template : RemoteTemplatesFactory.createGroupTemplates(element)) {
            map2.putValue((Object)template.getCategory(), (Object)template);
        }
        return map2;
    }

    private static List<ArchivedProjectTemplate> createGroupTemplates(Element groupElement) {
        List children2 = groupElement.getChildren("template");
        return ContainerUtil.mapNotNull((Collection)children2, (Function)((NullableFunction)element -> {
            if (!RemoteTemplatesFactory.checkRequiredPlugins(element)) {
                return null;
            }
            ModuleType moduleType = ModuleTypeManager.getInstance().findByID(element.getChildText("moduleType"));
            String path = element.getChildText("path");
            String description = element.getChildTextTrim("description");
            String name = element.getChildTextTrim("name");
            RemoteProjectTemplate template = new RemoteProjectTemplate(name, (Element)element, moduleType, path, description);
            template.populateFromElement((Element)element);
            return template;
        }));
    }

    private static boolean checkRequiredPlugins(Element element) {
        for (Element plugin : element.getChildren("requiredPlugin")) {
            if (PluginManager.isPluginInstalled(PluginId.getId((String)plugin.getTextTrim()))) continue;
            return false;
        }
        return true;
    }

    private static class RemoteProjectTemplate
    extends ArchivedProjectTemplate {
        private final ModuleType myModuleType;
        private final String myPath;
        private final String myDescription;

        public RemoteProjectTemplate(String name, Element element, ModuleType moduleType, String path, String description) {
            super(name, element.getChildTextTrim("category"));
            this.myModuleType = moduleType;
            this.myPath = path;
            this.myDescription = description;
        }

        @Override
        protected ModuleType getModuleType() {
            return this.myModuleType;
        }

        @Override
        public <T> T processStream(@NotNull ArchivedProjectTemplate.StreamProcessor<T> consumer2) throws IOException {
            return (T)HttpRequests.request((String)(RemoteTemplatesFactory.URL + this.myPath)).connect(request -> RemoteProjectTemplate.consumeZipStream(consumer2, new ZipInputStream(request.getInputStream())));
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }
    }
}

