/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.templates.LocalArchivedTemplate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateProjectDirectoryGenerator
implements DirectoryProjectGenerator<Object> {
    private final LocalArchivedTemplate myTemplate;
    private final ModuleBuilder myModuleBuilder;

    public TemplateProjectDirectoryGenerator(@NotNull LocalArchivedTemplate template) {
        this.myTemplate = template;
        this.myModuleBuilder = this.myTemplate.createModuleBuilder();
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        return this.myTemplate.getName();
    }

    @Override
    @Nullable
    public Icon getLogo() {
        return this.myTemplate.getIcon();
    }

    @Override
    public void generateProject(@NotNull Project newProject, @NotNull VirtualFile baseDir, @Nullable Object settings, @NotNull Module module2) {
        throw new IllegalStateException("Usn't supposed to be invoked, use generateProject(String, String) instead.");
    }

    public void generateProject(String name, String path) {
        try {
            this.myModuleBuilder.createProject(name, path);
        }
        finally {
            this.myModuleBuilder.cleanup();
        }
    }

    @Override
    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        String message2 = "Invalid settings";
        for (WizardInputField field : this.myTemplate.getInputFields()) {
            try {
                if (field.validate()) {
                    continue;
                }
            }
            catch (ConfigurationException e) {
                message2 = e.getMessage();
            }
            return new ValidationResult(message2);
        }
        ValidationResult result2 = this.myTemplate.validate(baseDirPath);
        if (result2 != null) {
            return result2;
        }
        return ValidationResult.OK;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        for (WizardInputField field : this.myTemplate.getInputFields()) {
            field.addToSettings(settingsStep);
        }
        if (this.myTemplate.getInputFields().isEmpty()) {
            settingsStep.addSettingsComponent((JComponent)new JLabel());
        }
    }
}

