/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.Producer;
import com.intellij.util.containers.Predicate;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadUtil {
    public static final String CONTENT_LENGTH_TEMPLATE = "${content-length}";
    private static final Logger LOG = Logger.getInstance(DownloadUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull File tempFile, @Nullable Predicate<String> contentChecker) throws IOException {
        try {
            String content;
            DownloadUtil.downloadContentToFile(indicator, url, tempFile);
            if (contentChecker != null && !contentChecker.apply((Object)(content = FileUtil.loadFile((File)tempFile)))) {
                boolean bl = false;
                return bl;
            }
            FileUtil.rename((File)tempFile, (File)outputFile);
            boolean bl = true;
            return bl;
        }
        finally {
            FileUtil.delete((File)tempFile);
        }
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile) throws IOException {
        File tempFile = FileUtil.createTempFile((String)"for-actual-downloading-", null);
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile, null);
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull File tempFile) throws IOException {
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile, null);
    }

    @NotNull
    public static <V> Outcome<V> provideDataWithProgressSynchronously(@Nullable Project project2, @NotNull String progressTitle, @NotNull String actionShortDescription, @NotNull Callable<V> supplier, @Nullable Producer<Boolean> tryAgainProvider) {
        int attemptNumber = 1;
        while (true) {
            Ref dataRef = Ref.create(null);
            Ref innerExceptionRef = Ref.create(null);
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText(actionShortDescription);
                try {
                    Object data = supplier.call();
                    dataRef.set(data);
                }
                catch (Exception ex) {
                    innerExceptionRef.set((Object)ex);
                }
            }, progressTitle, true, project2);
            if (!completed) {
                return Outcome.createAsCancelled();
            }
            Exception latestInnerException = (Exception)innerExceptionRef.get();
            if (latestInnerException == null) {
                return Outcome.createNormal(dataRef.get());
            }
            LOG.info("[attempt#" + attemptNumber + "] Cannot '" + actionShortDescription + "'");
            boolean onceMore = false;
            if (tryAgainProvider != null) {
                onceMore = Boolean.TRUE.equals(tryAgainProvider.produce());
            }
            if (!onceMore) {
                return Outcome.createAsException(latestInnerException);
            }
            ++attemptNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadContentToFile(@Nullable ProgressIndicator progress, @NotNull String url, @NotNull File outputFile) throws IOException {
        boolean parentDirExists = FileUtil.createParentDirs((File)outputFile);
        if (!parentDirExists) {
            throw new IOException("Parent dir of '" + outputFile.getAbsolutePath() + "' can not be created!");
        }
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            DownloadUtil.download(progress, url, out);
        }
    }

    private static void download(final @Nullable ProgressIndicator progress, @NotNull String location, final @NotNull OutputStream output) throws IOException {
        final String originalText = progress != null ? progress.getText() : null;
        DownloadUtil.substituteContentLength(progress, originalText, -1);
        if (progress != null) {
            progress.setText2("Downloading " + location);
        }
        HttpRequests.request((String)location).productNameAsUserAgent().connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

            public Object process(@NotNull HttpRequests.Request request) throws IOException {
                try {
                    int contentLength = request.getConnection().getContentLength();
                    DownloadUtil.substituteContentLength(progress, originalText, contentLength);
                    NetUtils.copyStreamContent((ProgressIndicator)progress, (InputStream)request.getInputStream(), (OutputStream)output, (int)contentLength);
                }
                catch (IOException e) {
                    throw new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)true), e);
                }
                return null;
            }
        });
    }

    private static void substituteContentLength(@Nullable ProgressIndicator progress, @Nullable String text, int contentLengthInBytes) {
        int ind;
        if (progress != null && text != null && (ind = text.indexOf(CONTENT_LENGTH_TEMPLATE)) != -1) {
            String mes = DownloadUtil.formatContentLength(contentLengthInBytes);
            String newText = text.substring(0, ind) + mes + text.substring(ind + CONTENT_LENGTH_TEMPLATE.length());
            progress.setText(newText);
        }
    }

    private static String formatContentLength(int contentLengthInBytes) {
        if (contentLengthInBytes < 0) {
            return "";
        }
        int kilo = 1024;
        if (contentLengthInBytes < 1024) {
            return ", " + contentLengthInBytes + " bytes";
        }
        if (contentLengthInBytes < 0x100000) {
            return String.format(Locale.US, ", %.1f kB", (double)contentLengthInBytes / 1024.0);
        }
        return String.format(Locale.US, ", %.1f MB", (double)contentLengthInBytes / 1048576.0);
    }
}

