/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ToolDescriptors {
    @NotNull
    private final Descriptor myDefaultDescriptor;
    @NotNull
    private final List<Descriptor> myNonDefaultDescriptors;

    private ToolDescriptors(@NotNull Descriptor defaultDescriptor, @NotNull List<Descriptor> nonDefaultDescriptors) {
        this.myDefaultDescriptor = defaultDescriptor;
        this.myNonDefaultDescriptors = nonDefaultDescriptors;
    }

    public static ToolDescriptors fromScopeToolState(ScopeToolState state, @NotNull InspectionProfileModifiableModel profile2, Project project2) {
        List<ScopeToolState> nonDefaultTools = profile2.getNonDefaultTools(state.getTool().getShortName(), project2);
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(nonDefaultTools.size());
        for (ScopeToolState nonDefaultToolState : nonDefaultTools) {
            descriptors.add(new Descriptor(nonDefaultToolState, profile2, project2));
        }
        return new ToolDescriptors(new Descriptor(state, profile2, project2), descriptors);
    }

    @NotNull
    public Descriptor getDefaultDescriptor() {
        return this.myDefaultDescriptor;
    }

    @NotNull
    public List<Descriptor> getNonDefaultDescriptors() {
        return this.myNonDefaultDescriptors;
    }

    @NotNull
    public ScopeToolState getDefaultScopeToolState() {
        return this.myDefaultDescriptor.getState();
    }
}

