/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionConfigTreeNode
extends DefaultMutableTreeNode {
    private final ClearableLazyValue<Boolean> myProperSetting = new ClearableLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            ToolDescriptors descriptors = InspectionConfigTreeNode.this.getDescriptors();
            if (descriptors != null) {
                Descriptor defaultDescriptor = descriptors.getDefaultDescriptor();
                return defaultDescriptor.getInspectionProfile().isProperSetting(defaultDescriptor.getToolWrapper().getShortName());
            }
            for (int i2 = 0; i2 < InspectionConfigTreeNode.this.getChildCount(); ++i2) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)InspectionConfigTreeNode.this.getChildAt(i2);
                if (!node.isProperSetting()) continue;
                return true;
            }
            return false;
        }
    };

    public HighlightDisplayKey getKey() {
        return this.getDefaultDescriptor().getKey();
    }

    @Nullable
    public Descriptor getDefaultDescriptor() {
        ToolDescriptors descriptors = this.getDescriptors();
        return descriptors == null ? null : descriptors.getDefaultDescriptor();
    }

    @Nullable
    public ToolDescriptors getDescriptors() {
        Object userObject = this.getUserObject();
        return userObject instanceof String ? null : (ToolDescriptors)userObject;
    }

    @Nullable
    public String getGroupName() {
        return this.userObject instanceof String ? (String)this.userObject : null;
    }

    @Nullable
    public String getScopeName() {
        ToolDescriptors descriptors = this.getDescriptors();
        return descriptors != null ? descriptors.getDefaultScopeToolState().getScopeName() : null;
    }

    public boolean isProperSetting() {
        return (Boolean)this.myProperSetting.getValue();
    }

    public void dropCache() {
        this.myProperSetting.drop();
    }

    @Override
    public String toString() {
        Object userObject = this.getUserObject();
        if (userObject instanceof ToolDescriptors) {
            return ((ToolDescriptors)userObject).getDefaultDescriptor().getText();
        }
        if (userObject instanceof Descriptor) {
            return ((Descriptor)userObject).getText();
        }
        return super.toString();
    }

    public static class Tool
    extends InspectionConfigTreeNode {
        @NotNull
        private final HighlightDisplayKey myKey;
        @NotNull
        private final SingleInspectionProfilePanel myPanel;

        public Tool(@NotNull HighlightDisplayKey key2, @NotNull SingleInspectionProfilePanel panel2) {
            this.myKey = key2;
            this.myPanel = panel2;
        }

        @Override
        public Object getUserObject() {
            return this.myPanel.getInitialToolDescriptors().get(this.myKey);
        }
    }

    public static class Group
    extends InspectionConfigTreeNode {
        public Group(@NotNull String label) {
            this.setUserObject(label);
        }
    }
}

