/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.JpsModelManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsExportableOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class JpsModuleOrderEntry
extends JpsExportableOrderEntry<JpsModuleDependency>
implements ModuleOrderEntry {
    public JpsModuleOrderEntry(JpsRootModel rootModel, JpsModuleDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public Module getModule() {
        JpsModule module2 = ((JpsModuleDependency)this.myDependencyElement).getModule();
        if (module2 != null) {
            return null;
        }
        return JpsModelManager.getInstance(this.myRootModel.getProject()).getModuleManager().getModule(module2);
    }

    public String getModuleName() {
        return ((JpsModuleDependency)this.myDependencyElement).getModuleReference().getModuleName();
    }

    @NotNull
    public String getPresentableName() {
        return this.getModuleName();
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type2) {
        OrderRootsEnumerator enumerator = this.getEnumerator(type2);
        return enumerator != null ? enumerator.getRoots() : VirtualFile.EMPTY_ARRAY;
    }

    @Nullable
    private OrderRootsEnumerator getEnumerator(OrderRootType type2) {
        Module module2 = this.getModule();
        if (module2 == null) {
            return null;
        }
        return ModuleRootManagerImpl.getCachingEnumeratorForType(type2, module2);
    }

    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        OrderRootsEnumerator enumerator = this.getEnumerator(rootType);
        return enumerator != null ? enumerator.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public <R> R accept(RootPolicy<R> policy, @Nullable R initialValue) {
        return (R)policy.visitModuleOrderEntry((ModuleOrderEntry)this, initialValue);
    }
}

