/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.JpsSdkManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.module.JpsSdkDependency;

public abstract class JpsSdkOrderEntryBase
extends JpsOrderEntry<JpsSdkDependency>
implements JdkOrderEntry {
    public JpsSdkOrderEntryBase(JpsRootModel rootModel, JpsSdkDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    public String getJdkName() {
        JpsSdkReference reference = ((JpsSdkDependency)this.myDependencyElement).getSdkReference();
        return reference != null ? reference.getSdkName() : null;
    }

    @NotNull
    public VirtualFile[] getFiles(OrderRootType type2) {
        return this.getRootFiles(type2);
    }

    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        return this.getRootUrls(rootType);
    }

    public Sdk getJdk() {
        JpsLibrary library = ((JpsSdkDependency)this.myDependencyElement).resolveSdk();
        if (library == null) {
            return null;
        }
        return JpsSdkManager.getInstance().getSdk(library);
    }

    @NotNull
    public String getPresentableName() {
        return "< " + this.getJdkName() + " >";
    }

    public VirtualFile[] getRootFiles(OrderRootType type2) {
        Sdk sdk = this.getJdk();
        if (sdk == null) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return sdk.getRootProvider().getFiles(type2);
    }

    public String[] getRootUrls(OrderRootType type2) {
        Sdk jdk2 = this.getJdk();
        if (jdk2 == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return jdk2.getRootProvider().getUrls(type2);
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }
}

