/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    private static final EverythingGlobalScope ALL_SCOPE = new EverythingGlobalScope();
    protected final Project myProject;
    private volatile PackageDirectoryCache myCache;
    private final PsiManager myManager;
    private final String[] myFileExtensions;

    public NonClasspathClassFinder(@NotNull Project project2, String ... fileExtensions) {
        this.myProject = project2;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myFileExtensions = (String[])ArrayUtil.append((Object[])fileExtensions, (Object)"class");
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                NonClasspathClassFinder.this.clearCache();
            }
        });
        LowMemoryWatcher.register(() -> this.clearCache(), (Disposable)project2);
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        PackageDirectoryCache cache2 = this.myCache;
        if (cache2 == null) {
            this.myCache = cache2 = NonClasspathClassFinder.createCache(this.calcClassRoots());
        }
        return cache2;
    }

    @NotNull
    protected static PackageDirectoryCache createCache(@NotNull List<VirtualFile> roots) {
        MultiMap map2 = MultiMap.create();
        map2.putValues((Object)"", roots);
        return new PackageDirectoryCache((MultiMap<String, VirtualFile>)map2);
    }

    public void clearCache() {
        this.myCache = null;
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope) {
        return this.getCache(scope).getDirectoriesByPackageName("");
    }

    public List<VirtualFile> getClassRoots() {
        return this.getClassRoots((GlobalSearchScope)ALL_SCOPE);
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        Ref result2 = Ref.create();
        this.processDirectories(StringUtil.getPackageName((String)qualifiedName), scope, (Processor<VirtualFile>)((Processor)dir -> {
            PsiClass[] classes2;
            PsiFile file2;
            VirtualFile virtualFile = NonClasspathClassFinder.findChild(dir, StringUtil.getShortName((String)qualifiedName), this.myFileExtensions);
            PsiFile psiFile = file2 = virtualFile == null ? null : this.myManager.findFile(virtualFile);
            if (file2 instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)file2).getClasses()).length == 1) {
                result2.set((Object)classes2[0]);
                return false;
            }
            return true;
        }));
        return (PsiClass)result2.get();
    }

    protected abstract List<VirtualFile> calcClassRoots();

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        ArrayList result2 = ContainerUtil.newArrayList();
        this.processDirectories(psiPackage.getQualifiedName(), scope, (Processor<VirtualFile>)((Processor)dir -> {
            for (VirtualFile file2 : dir.getChildren()) {
                PsiFile psi;
                if (file2.isDirectory() || !ArrayUtil.contains((String)file2.getExtension(), (String[])this.myFileExtensions) || !((psi = this.myManager.findFile(file2)) instanceof PsiClassOwner)) continue;
                ContainerUtil.addAll((Collection)result2, (Object[])((PsiClassOwner)psi).getClasses());
            }
            return true;
        }));
        return result2.toArray(new PsiClass[result2.size()]);
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        HashSet<String> result2 = new HashSet<String>();
        this.processDirectories(psiPackage.getQualifiedName(), scope, (Processor<VirtualFile>)((Processor)dir -> {
            for (VirtualFile file2 : dir.getChildren()) {
                if (file2.isDirectory() || !ArrayUtil.contains((String)file2.getExtension(), (String[])this.myFileExtensions)) continue;
                result2.add(file2.getNameWithoutExtension());
            }
            return true;
        }));
        return result2;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.processDirectories(qualifiedName, (GlobalSearchScope)ALL_SCOPE, (Processor<VirtualFile>)processor2);
        return processor2.getFoundValue() != null ? this.createPackage(qualifiedName) : null;
    }

    private PsiPackageImpl createPackage(String qualifiedName) {
        return new PsiPackageImpl(this.myManager, qualifiedName);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer2, boolean includeLibrarySources) {
        return this.processDirectories(psiPackage.getQualifiedName(), scope, (Processor<VirtualFile>)((Processor)dir -> {
            PsiDirectory psiDirectory = psiPackage.getManager().findDirectory(dir);
            return psiDirectory == null || consumer2.process((Object)psiDirectory);
        }));
    }

    private boolean processDirectories(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope, @NotNull Processor<VirtualFile> processor2) {
        return ContainerUtil.process(this.getCache(scope).getDirectoriesByPackageName(qualifiedName), file2 -> !scope.contains(file2) || processor2.process(file2));
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        String pkgName = psiPackage.getQualifiedName();
        Set<String> names = this.getCache(scope).getSubpackageNames(pkgName);
        if (names.isEmpty()) {
            return super.getSubPackages(psiPackage, scope);
        }
        ArrayList<PsiPackageImpl> result2 = new ArrayList<PsiPackageImpl>();
        for (String name : names) {
            result2.add(this.createPackage(pkgName.isEmpty() ? name : pkgName + "." + name));
        }
        return result2.toArray(new PsiPackage[result2.size()]);
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        PsiClass psiClass = this.findClass(qualifiedName, scope);
        if (psiClass == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        return psiClassArray;
    }

    @NotNull
    public static GlobalSearchScope addNonClasspathScope(@NotNull Project project2, @NotNull GlobalSearchScope base) {
        GlobalSearchScope scope = base;
        for (PsiElementFinder finder : (PsiElementFinder[])Extensions.getExtensions((ExtensionPointName)EP_NAME, (AreaInstance)project2)) {
            if (!(finder instanceof NonClasspathClassFinder)) continue;
            scope = scope.uniteWith(NonClasspathDirectoriesScope.compose(((NonClasspathClassFinder)finder).getClassRoots()));
        }
        return scope;
    }

    public PsiManager getPsiManager() {
        return this.myManager;
    }

    @Nullable
    private static VirtualFile findChild(@NotNull VirtualFile root, @NotNull String relPath, @NotNull String[] extensions) {
        VirtualFile file2 = null;
        for (String extension : extensions) {
            file2 = root.findChild(relPath + '.' + extension);
            if (file2 != null) break;
        }
        return file2;
    }
}

