/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.WrappedElementAnchor;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAnchor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.PsiAnchor");

    @Nullable
    public abstract PsiElement retrieve();

    public abstract PsiFile getFile();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    @NotNull
    public static PsiAnchor create(@NotNull PsiElement element) {
        PsiUtilCore.ensureValid((PsiElement)element);
        PsiAnchor anchor = PsiAnchor.doCreateAnchor(element);
        if (ApplicationManager.getApplication().isUnitTestMode() && !element.equals(anchor.retrieve())) {
            LOG.error("Cannot restore element " + element + " of " + element.getClass() + " from anchor " + anchor);
        }
        return anchor;
    }

    @NotNull
    private static PsiAnchor doCreateAnchor(@NotNull PsiElement element) {
        if (element instanceof PsiFile) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            if (virtualFile != null) {
                return new PsiFileReference(virtualFile, (PsiFile)element);
            }
            return new HardReference(element);
        }
        if (element instanceof PsiDirectory) {
            VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
            return new PsiDirectoryReference(virtualFile, element.getProject());
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return new HardReference(element);
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return new HardReference(element);
        }
        StubIndexReference stubRef = PsiAnchor.createStubReference(element, file2);
        if (stubRef != null) {
            return stubRef;
        }
        if (!element.isPhysical()) {
            return PsiAnchor.wrapperOrHardReference(element);
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return PsiAnchor.wrapperOrHardReference(element);
        }
        Language lang = null;
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language l : viewProvider.getLanguages()) {
            if (viewProvider.getPsi(l) != file2) continue;
            lang = l;
            break;
        }
        if (lang == null) {
            return PsiAnchor.wrapperOrHardReference(element);
        }
        return new TreeRangeReference(file2, textRange.getStartOffset(), textRange.getEndOffset(), Identikit.fromPsi(element, lang), virtualFile);
    }

    @NotNull
    private static PsiAnchor wrapperOrHardReference(@NotNull PsiElement element) {
        for (SmartPointerAnchorProvider provider2 : (SmartPointerAnchorProvider[])SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
            PsiAnchor wrappedAnchor;
            PsiElement anchorElement = provider2.getAnchor(element);
            if (anchorElement == null || anchorElement == element || (wrappedAnchor = PsiAnchor.create(anchorElement)) instanceof HardReference) continue;
            return new WrappedElementAnchor(provider2, wrappedAnchor);
        }
        return new HardReference(element);
    }

    @Nullable
    public static StubIndexReference createStubReference(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element instanceof StubBasedPsiElement && element.isPhysical() && (element instanceof PsiCompiledElement || PsiAnchor.canHaveStub(containingFile))) {
            int index;
            StubBasedPsiElement elt = (StubBasedPsiElement)element;
            IStubElementType elementType = elt.getElementType();
            if ((elt.getStub() != null || elementType.shouldCreateStub(element.getNode())) && (index = PsiAnchor.calcStubIndex((StubBasedPsiElement)element)) != -1) {
                return new StubIndexReference(containingFile, index, containingFile.getLanguage(), elementType);
            }
        }
        return null;
    }

    private static boolean canHaveStub(PsiFile file2) {
        if (!(file2 instanceof PsiFileImpl)) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        IStubFileElementType elementType = ((PsiFileImpl)file2).getElementTypeForStubBuilder();
        return elementType != null && vFile != null && elementType.shouldBuildStubFor(vFile);
    }

    public static int calcStubIndex(@NotNull StubBasedPsiElement psi) {
        if (psi instanceof PsiFile) {
            return 0;
        }
        StubElement liveStub = psi.getStub();
        if (liveStub != null) {
            return ((StubBase)liveStub).id;
        }
        PsiFileImpl file2 = (PsiFileImpl)psi.getContainingFile();
        StubTree stubTree = file2.calcStubTree();
        for (StubElement stb : stubTree.getPlainList()) {
            if (stb.getPsi() != psi) continue;
            return ((StubBase)stb).id;
        }
        return -1;
    }

    @Nullable
    public static PsiElement restoreFromStubIndex(PsiFileWithStubSupport fileImpl, int index, @NotNull IStubElementType elementType, boolean throwIfNull) {
        List list;
        if (fileImpl == null) {
            if (throwIfNull) {
                throw new AssertionError((Object)"Null file");
            }
            return null;
        }
        StubTree tree = fileImpl.getStubTree();
        if (tree == null) {
            if (fileImpl instanceof PsiFileImpl) {
                tree = ((PsiFileImpl)fileImpl).calcStubTree();
            } else {
                if (throwIfNull) {
                    throw new AssertionError((Object)("Not PsiFileImpl: " + fileImpl.getClass()));
                }
                return null;
            }
        }
        if (index >= (list = tree.getPlainList()).size()) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Too large index: " + index + ">=" + list.size()));
            }
            return null;
        }
        StubElement stub = (StubElement)list.get(index);
        if (stub.getStubType() != elementType) {
            if (throwIfNull) {
                throw new AssertionError((Object)("Element type mismatch: " + stub.getStubType() + "!=" + elementType));
            }
            return null;
        }
        return stub.getPsi();
    }

    public static class StubIndexReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final int myIndex;
        private final Language myLanguage;
        private final IStubElementType myElementType;

        private StubIndexReference(@NotNull PsiFile file2, int index, @NotNull Language language, @NotNull IStubElementType elementType) {
            this.myLanguage = language;
            this.myElementType = elementType;
            this.myVirtualFile = file2.getVirtualFile();
            this.myProject = file2.getProject();
            this.myIndex = index;
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            if (this.myProject.isDisposed() || !this.myVirtualFile.isValid()) {
                return null;
            }
            FileViewProvider viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(this.myVirtualFile);
            PsiFile file2 = viewProvider == null ? null : viewProvider.getPsi(this.myLanguage);
            return file2 instanceof PsiFileWithStubSupport ? file2 : null;
        }

        @Override
        public PsiElement retrieve() {
            return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> StubIndexReference.restoreFromStubIndex((PsiFileWithStubSupport)this.getFile(), this.myIndex, this.myElementType, false)));
        }

        public String diagnoseNull() {
            PsiFile file2 = (PsiFile)ApplicationManager.getApplication().runReadAction(() -> this.getFile());
            try {
                PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> StubIndexReference.restoreFromStubIndex((PsiFileWithStubSupport)file2, this.myIndex, this.myElementType, true)));
                return "No diagnostics, element=" + element + "@" + (element == null ? 0 : System.identityHashCode(element));
            }
            catch (AssertionError e) {
                String msg = ((Throwable)((Object)e)).getMessage();
                msg = msg + (file2 == null ? "\n no PSI file" : "\n current file stamp=" + (short)file2.getModificationStamp());
                Document document = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
                if (document != null) {
                    msg = msg + "\n committed=" + PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(document);
                    msg = msg + "\n saved=" + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
                }
                return msg;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StubIndexReference)) {
                return false;
            }
            StubIndexReference that = (StubIndexReference)o;
            return this.myIndex == that.myIndex && this.myVirtualFile.equals(that.myVirtualFile) && Comparing.equal((Object)this.myElementType, (Object)that.myElementType) && this.myLanguage == that.myLanguage;
        }

        public int hashCode() {
            return ((31 * this.myVirtualFile.hashCode() + this.myIndex) * 31 + (this.myElementType == null ? 0 : this.myElementType.hashCode())) * 31 + this.myLanguage.hashCode();
        }

        @NonNls
        public String toString() {
            return "StubIndexReference{myVirtualFile=" + this.myVirtualFile + ", myProject=" + this.myProject + ", myIndex=" + this.myIndex + ", myLanguage=" + this.myLanguage + ", myElementType=" + this.myElementType + '}';
        }

        @Override
        public int getStartOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType + "; " + this.myVirtualFile);
            }
            return resolved.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            PsiElement resolved = this.retrieve();
            if (resolved == null) {
                throw new PsiInvalidElementAccessException(null, "Element type: " + this.myElementType + "; " + this.myVirtualFile);
            }
            return resolved.getTextRange().getEndOffset();
        }

        public VirtualFile getVirtualFile() {
            return this.myVirtualFile;
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }
    }

    private static class PsiDirectoryReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;

        private PsiDirectoryReference(@NotNull VirtualFile file2, @NotNull Project project2) {
            this.myFile = file2;
            this.myProject = project2;
            assert (file2.isDirectory()) : file2;
        }

        @Override
        public PsiElement retrieve() {
            return SelfElementInfo.restoreDirectoryFromVirtual(this.myFile, this.myProject);
        }

        @Override
        public PsiFile getFile() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiDirectoryReference)) {
                return false;
            }
            PsiDirectoryReference reference = (PsiDirectoryReference)o;
            if (!this.myFile.equals(reference.myFile)) {
                return false;
            }
            return this.myProject.equals(reference.myProject);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }
    }

    private static class PsiFileReference
    extends PsiAnchor {
        private final VirtualFile myFile;
        private final Project myProject;
        @NotNull
        private final Language myLanguage;

        private PsiFileReference(@NotNull VirtualFile file2, @NotNull PsiFile psiFile) {
            this.myFile = file2;
            this.myProject = psiFile.getProject();
            this.myLanguage = PsiFileReference.findLanguage(psiFile);
        }

        private static Language findLanguage(PsiFile file2) {
            FileViewProvider vp = file2.getViewProvider();
            Set languages = vp.getLanguages();
            for (Language language : languages) {
                if (!file2.equals(vp.getPsi(language))) continue;
                return language;
            }
            throw new AssertionError((Object)("Non-retrievable file: " + file2.getClass() + "; " + file2.getLanguage() + "; " + languages));
        }

        @Override
        public PsiElement retrieve() {
            return this.getFile();
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myFile, this.myProject, this.myLanguage);
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return (int)this.myFile.getLength();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiFileReference)) {
                return false;
            }
            PsiFileReference reference = (PsiFileReference)o;
            if (!this.myFile.equals(reference.myFile)) {
                return false;
            }
            if (!this.myLanguage.equals(reference.myLanguage)) {
                return false;
            }
            return this.myProject.equals(reference.myProject);
        }

        public int hashCode() {
            return 31 * this.myFile.hashCode() + this.myLanguage.hashCode();
        }
    }

    public static class HardReference
    extends PsiAnchor {
        private final PsiElement myElement;

        public HardReference(PsiElement element) {
            this.myElement = element;
        }

        @Override
        public PsiElement retrieve() {
            return this.myElement;
        }

        @Override
        public PsiFile getFile() {
            return this.myElement.getContainingFile();
        }

        @Override
        public int getStartOffset() {
            return this.myElement.getTextRange().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myElement.getTextRange().getEndOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HardReference)) {
                return false;
            }
            HardReference that = (HardReference)o;
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }
    }

    private static class TreeRangeReference
    extends PsiAnchor {
        private final VirtualFile myVirtualFile;
        private final Project myProject;
        private final Identikit myInfo;
        private final int myStartOffset;
        private final int myEndOffset;

        private TreeRangeReference(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Identikit info, @NotNull VirtualFile virtualFile) {
            this.myVirtualFile = virtualFile;
            this.myProject = file2.getProject();
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myInfo = info;
        }

        @Override
        @Nullable
        public PsiElement retrieve() {
            PsiFile psiFile = this.getFile();
            if (psiFile == null || !psiFile.isValid()) {
                return null;
            }
            return this.myInfo.findPsiElement(psiFile, this.myStartOffset, this.myEndOffset);
        }

        @Override
        @Nullable
        public PsiFile getFile() {
            return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myInfo.getFileLanguage());
        }

        @Override
        public int getStartOffset() {
            return this.myStartOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TreeRangeReference)) {
                return false;
            }
            TreeRangeReference that = (TreeRangeReference)o;
            return this.myEndOffset == that.myEndOffset && this.myStartOffset == that.myStartOffset && this.myInfo.equals(that.myInfo) && this.myVirtualFile.equals(that.myVirtualFile);
        }

        public int hashCode() {
            int result2 = this.myInfo.hashCode();
            result2 = 31 * result2 + this.myStartOffset;
            result2 = 31 * result2 + this.myEndOffset;
            result2 = 31 * result2 + this.myVirtualFile.hashCode();
            return result2;
        }
    }
}

